#function to compute weighted qth quantile of a sample of n observations
subroutine wkuantile(n,x,w,ip,q)
integer n,k,l,r,ip(n)
double precision x(n), w(n),q
k=nint(q*n)
l=1
r=n
call wselect(n,x,w,ip,l,r,k)
q=x(ip(k))
return
end
#This is a ratfor adaptation of the Floyd-Rivest algorithm--SELECT
#adapted to compute weighted quantiles
#Reference:  CACM 1975, Algorithm #489, p173, algol-68 version
#As originally proposed with mmax=600, and cs = cd = 1/2.
#Translation of original SELECT by Roger Koenker August, 1996.
#Adaptation for weights by Roger Koenker January, 2020 with added
#inspiration from KPG1_QNTLx by RL Warren-Smith and DS Berry (Starlink)
recursive subroutine wselect(n,x,w,ip,l,r,k)
integer ip(n),n,m,l,r,k,ll,rr,i,j,mmax
double precision x(n),w(n),z,s,d,t,fm,cs,cd
double precision tau, wl, wr, wlo, whi, wtarg
double precision wmid, wgap, half
parameter(cs = 0.5d0)
parameter(cd = 0.5d0)
parameter(half = 0.5d0)
parameter(mmax = 600)
tau = k/dble(n)
wlo = 0.0d0
whi = 0.0d0
while(r > l){
	if(r-l > mmax){
		m=r-l+1
		i=k-l+1
		fm = dble(m)
		z=log(fm)
		s=cs*exp(2*z/3)
		d=cd*sqrt(z*s*(m-s)/fm)*sign(1,i-m/2)
		ll=max(l,nint(k-i*s/fm + d))
		rr=min(r,nint(k+(m-i)*s/fm + d))
		call wselect(n,x,w,ip,ll,rr,k)
		}
	t=x(ip(k))
	i=l
	j=r
	wl = 0.0d0
	wr = 0.0d0
	call iswap(ip(l),ip(k))
	if(x(r) > t) call iswap(ip(r),ip(l))
	while(i < j){
		call iswap(ip(i),ip(j))
		wl = wl + w(ip(i))
		wr = wr + w(ip(j))
		i=i+1
		j=j-1
		while(x(ip(i)) < t){
		    wl = wl + w(ip(i))
		    i = i + 1
		}
		while (x(ip(j)) > t){
		    wr = wr + w(ip(j))
		    j = j - 1
		}
	}
	if(i == j) wl =wl + w(ip(i))
	if(x(ip(l)) == t)
	    call iswap(ip(l),ip(j))
	else{
	    j = j + 1
	    call iswap(ip(j),ip(r))
	    wl = wl + w(ip(j))
	    wr = wr - w(ip(j))
	}
	wtarg = tau*(wlo + wl + whi + wr)
	if(wlo + wl - half * w(ip(j)) < wtarg){
	    wlo = wlo + wl
	    wmid = wr
	    l = j+1
	}
	else{
	    whi = whi + wr + w(ip(j))
	    wmid = wl - w(ip(j))
	    r = j-1
	}
	wgap = wtarg - wlo
	if(l > 1){
	    wgap = wgap + half * w(ip(l-1))
	    wmid = wmid + half * w(ip(l-1))
	}
	if(r < n) {
	    wmid = wmid + half + w(ip(r+1))
	}
	if(wmid != 0.0d0){
	    k = nint((r - l + 2) * (wgap/wmid)) + l - 1
	}
	else{
	    k = (l + r)/2
	}
}
return
end
subroutine iswap(a,b)
integer a,b
integer tmp
tmp = a
a = b
b = tmp
return
end
