# Timeing experiment for univariate sample quantiles
set.seed(17)
require(microbenchmark)
tau = 0.8
ks = 4:9
M = list()
for(i in 1:length(ks)){
    x = rnorm(10^ks[i])
    M[[i]] = microbenchmark(
	    quantile(x, tau),
	    q489(x, tau),
	    kuantile(x, tau), times = 50)
}

