# evaluate FDR for different rules under just capacity constraints. 
# assuming 1-dimensional G. 
# using first 3 years of data. 

require(REBayes)
source("fit1d.R")
load("D.Rda")
z = fit1d(1:3, D)
n = length(z$S)
	pms = predict(z$fs, z$S, newsigma = sqrt(1/z$W))
	est = optim(c(0,1), lik, x = z$S, s = sqrt(1/z$W))$par
 	estmean = est[1]
 	estvar = est[2]
 	EM = EMrule(z$S, sqrt(1/z$W), mean = estmean, estvar = estvar)
	pvalue = (z$S-1)*sqrt(z$W)
	R = estmean + (z$S-estmean) * estvar/(estvar+(1/z$W))  #James-Stein 
	

# right 
alphas = c(4,10,15,20,25)/100
FDRright = matrix(NA, 7, length(alphas))
for (j in 1:length(alphas)){
	alpha = alphas[j]
cnulls = qKW(z$fs, 1-alpha)
tps=  Lfdr.GLmix_temp(z$S, z$fs, sqrt(1/z$W), cnull = cnulls)
 FDRright[1,j] = ThreshFDR(quantile(z$S,1-alpha), z$S,tps)   # MLE (Gaussian MLE, or FE)
FDRright[2,j] = ThreshFDR(quantile(z$D/z$E,1-alpha), z$D/z$E,tps)  #P-MLE (Poisson MLE)
FDRright[3,j] = ThreshFDR(quantile((sqrt(z$D/z$E)-1) * sqrt(4*z$E), 1-alpha), (sqrt(z$D/z$E)-1)*sqrt(4*z$E), tps)  # Pvalue
FDRright[4,j] = ThreshFDR(quantile(EM$v, 1-alpha), EM$v, tps)  # Efron & Morris 
FDRright[5,j] = ThreshFDR(quantile(R, 1-alpha), R, tps)  # James-Stein
FDRright[6,j] = ThreshFDR(quantile(pms,1-alpha), pms, tps)  #Posterior mean
FDRright[7,j] = ThreshFDR(quantile(tps, 1-alpha), tps,tps)	#Posterior tp
}

# left
alphas = c(4,10,15,20,25)/100
FDRleft = matrix(NA, 7, length(alphas))
for (j in 1:length(alphas)){
	alpha = alphas[j]
cnulls = qKW(z$fs, alpha)
tps = Lfdr.GLmix_temp(z$S, z$fs, sqrt(1/z$W), cnull = cnulls, tail = "L")
FDRleft[1,j] = ThreshFDR(-quantile(z$S,alpha), -z$S,tps)  # MLE (Gaussian MLE, or FE)
FDRleft[2,j] = ThreshFDR(-quantile(z$D/z$E,alpha), -z$D/z$E,tps)  #P-MLE (Poisson MLE)
FDRleft[3,j] = ThreshFDR(quantile((1-sqrt(z$D/z$E)) * sqrt(4*z$E), 1-alpha), (1-sqrt(z$D/z$E))*sqrt(4*z$E), tps)  #Pvalue
FDRleft[4,j] = ThreshFDR(-quantile(EM$v, alpha), -EM$v, tps)  #Efron & Morris
FDRleft[5,j] = ThreshFDR(-quantile(R, alpha), -R, tps) # James-Stein
FDRleft[6,j] = ThreshFDR(-quantile(pms,alpha), -pms, tps)  #Posterior mean
FDRleft[7,j] = ThreshFDR(quantile(tps, 1-alpha), tps,tps)   #Posterior tp
}

# tab construction
require(Hmisc)
meths = c("MLE", "Poisson-MLE","Pvalue","Efron-Morris","James-Stein","PM","TP")
alphas = c("$\\alpha=4\\%$", "$\\alpha=10\\%$", "$\\alpha=15\\%$", "$\\alpha=20\\%$", "$\\alpha=25\\%$")
D = rbind(round(FDRright,digits = 3), round(FDRleft,digits = 3))
dimnames(D) = list(rep(meths,2), rep(alphas,1))
cap = "FDR rate: 2004-2006"
latex(D, file = "naive_31_1d.tex", rowlabel = "",  
      rgroup = c("Right Selection","Left Selection"), 
      caption.loc = "bottom", caption = cap, label = "tab: naive_31_1d")
