# stick to the right selection routine (double check later whether left selection routine gives the same thing) # left tail principle (we should be able to prove they lead to same clustering)

require(REBayes)
source("fit1d.R")
load("D.Rda")
as = cumsum(c(4, 9, 35, 30, 22)/100)
n = 3230
TPleaguetable = matrix(NA, n, 5)
PMleaguetable = matrix(NA,n,5)
Pvalueleaguetable = matrix(NA, n, 5)
tset = rbind(c(1:3), c(3:5), c(6:8), c(9:11), c(12:14))
for (t in 1:5){
	z = fit1d(tset[t,], D)
	n = length(z$S)
	pms = predict(z$fs, z$S, newsigma = sqrt(1/z$W))
	pvalue = (z$S-1)*sqrt(z$W)
	tps = matrix(NA, n, 4)
	TPset = matrix(NA, n, 4)
	PMset = matrix(NA,n,4)
	pvalueset = matrix(NA, n,4)
	for (j in 1:4){
	    alpha = as[j]
            cnulls = qKW(z$fs, 1-alpha)
            tps[,j] =  Lfdr.GLmix_temp(z$S, z$fs, sqrt(1/z$W), cnull = cnulls)
            TPset[,j] = (tps[,j] >= quantile(tps[,j], 1- alpha))
            PMset[,j] = (pms >= quantile(pms, 1-alpha))
            pvalueset[,j] = (pvalue >= quantile(pvalue, 1- alpha))
	}
    # check nestedness
    print(c(setdiff(which(TPset[,1]==1), which(TPset[,2]==1)), 
	setdiff(which(TPset[,2]==1), which(TPset[,3]==1)),
	setdiff(which(TPset[,3]==1), which(TPset[,4]==1))))

    TPleaguetable[,t] = apply(TPset,1,sum)+1  # 1 means rate A, 5 means rate F
    PMleaguetable[,t] = apply(PMset,1,sum)+1
    Pvalueleaguetable[,t] = apply(pvalueset,1,sum)+1
}






require(markovchain)
A = data.frame(TPleaguetable)
f = markovchainFit(A)
TM = f$estimate@transitionMatrix
g = LETTERS[c(1:4,6)]
dimnames(TM) = list(g,g)
cap = "Estimated First Order Markov Transition Matrix: Entry
$i,j$ of the matrix estimates the probability of a transition
from state $i$ to state $j$ based on posterior tail probability
rankings for 3-year longitudinal grouping of the center data." 

require(Hmisc)
latex(round(TM,3), file = "TM.tex", caption = cap, label = "tab: TM",
      rowlabel = "", caption.loc = "bottom")

