
# nttab construction
require(Hmisc)
load("LAranking_sim.Rda")
meths = c("OTP", "OPM", "ETP","KWTP", "EPM","KWPM", "LPM","LPM*","EM", "EM*","MLE", "P-val")
alphas = c("$\\alpha=1\\%$","$\\alpha=3\\%$", "$\\alpha=5\\%$", "$\\alpha=10\\%$")
#gammas = c("$\\gamma=5\\%$", "$\\gamma=10\\%$", "$\\gamma=15\\%$")
gammas = c("$\\gamma=5\\%$", "$\\gamma=10\\%$")
D = round(apply(A, 2:5, mean, na.rm = TRUE),3)
D = rbind( D[,,1,1], D[,,1,2], D[,,1,3])
r = c(1,5,2,4,6,8:14, (14 + c(1,5,2,4,6,8:14)), (28 + c(1,5,2,4,6,8:14)))
D = D[r,1:8]
dimnames(D) = list(rep(meths, 3), rep(alphas,2))
cap = "Comparison of Performance of Several Selection Rules for the Teacher Value Added Simulation."
latex(round(D,digits = 3), file = "LArankinga1.tex", rowlabel = "", cgroup = gammas, 
      rgroup = c("Power", "FDR", "Selected"), 
      caption.loc = "bottom", caption = cap, label = "tab:LArankinga")
