# modified all of the functions to suit left tail selection
# Usage of Thresh function: turn the thresholding rule into the ">" inequality, i.e. 1{test stat > max(T0, T1)}. 

Lfdr = function(x, G, s, cnull ){ # Modified for outliers??
	# changed for left tail selection
    v = G$x
    fv = G$y
    A = dnorm(outer(x, v, "-"), sd = s)
    v = 1 - c((A %*% (fv * (v > cnull)))/(A %*% fv))
    #if(any(is.na(v))) v[is.na(v)] = 1-((1 + sign(x[is.na(v)]))/2)
    v
}
PM = function(x, G, s, cnull =3) predict(G, x, newsigma = s)

qKW <- function(f, q){
    G <- cumsum(c(0, f$y[-length(f$y)])/sum(f$y))
    c(f$x[apply(outer(G, q, "<="), 2,sum)])
}

rG = function(n, G, s) rnorm(n,sample(G$x, n, prob = G$y, replace = TRUE),s)

Finv = function(y, F, interval = c(0,1), ...) 
    uniroot(function(x) F(x, ...) - y, interval, extendInt = "yes", maxiter = 50)$root 

ThreshFDR = function(lam, Fun, G, s, H, domain, cnull){
    # find value such that Fun criterion is met
    # changed for left tail selection
    nH = length(H$x)
    nu = rep(NA, nH)
    cnu = rep(NA, nH)
	fs = H$y
    for (j in 1:nH){
        cut = Finv(lam, Fun, interval = domain, G = G, s = H$x[j], cnull)
	nu[j]  = sum(G$y * (pnorm(cut - G$x, sd = H$x[j])))
	cnu[j]  = sum(G$y * (G$x > cnull) * (pnorm(cut - G$x, sd = H$x[j])))
    }
    crossprod(cnu, fs)/crossprod(nu, fs)
}   

ThreshFDREM = function(lam, V, Bhat, s, alpha){
    # assume G = N(0, V)
    # changed for left tail selection!
    gx = seq(-12*sqrt(V), 12*sqrt(V), length = 100)
    G = list(x = gx, y = dnorm(gx, sd = sqrt(V)), sd = sqrt(V))
    cnull = qnorm(alpha, sd = sqrt(V))
    n = length(s)
    nu = rep(NA, n)
    cnu = rep(NA, n)
    for (j in 1:n){
        cut = lam/(1- Bhat[j])
	nu[j] = sum(G$y * (pnorm(cut - G$x, sd = s[j])))
	cnu[j] = sum(G$y * (G$x > cnull) * (pnorm(cut - G$x, sd = s[j])))
    }
    mean(cnu)/mean(nu)
} 



Thresh <- function(v, T0, T1, theta, cnull){
	# changed for left tail selection
    sel <- list()
    a = matrix(NA,3,3)
    if(!length(T1)) return(a)
    Pnonnull = mean(theta  <= cnull)
    trueset = which(theta <= cnull)
    sel[[1]] = which(v > max(T0, T1))
    sel[[2]] = which(v > T0)
    sel[[3]] = which(v > T1)
    for(i in 1:3){
	a[i,1] <- length(intersect(trueset,sel[[i]]))/n/Pnonnull
	a[i,2] <- length(setdiff(sel[[i]], trueset))/length(sel[[i]])
	a[i,3] <- length(sel[[i]])/n
    }
    a
}

P = function(a, d) 1/(2*(a + d)^2) # 1/Var(S)
psi = function(a, s, d) a - sum((s - d)*P(a,d))/sum(P(a,d))	
EM2rule = function(x,s){ # Efron & Morris 1974 Rand Memo
	n = length(x)
	z = rep(0,n)
	estvar = uniroot(psi, c(0.001, 2), s = x^2, d = s^2, extendInt = "yes")$root
	a = rep(estvar,n)
	toler = 1e-05
	it = 0
	while(sum(abs(a-z)) > toler){
		a = z
		it = it + 1
		for (i in 1:n){
			p = P(a, s^2)
			p[i] = 2/(2*(a[i] + s[i]^2)^2)
			c = x^2 - s^2
			c[i] = (x[i]^2 - 3* s[i]^2)/3
			z[i] = sum(c * p)/sum(p)
			}
		}
	khat = rep(0,n)
	for (i in 1:n)
	    khat[i] = sum((a[i] + s[i]^2)^2/(a[i] + s^2)^2)
	chat = pmax((khat-2)/(khat+2),0)
	Bhat = chat * s^2/(a + s^2)
	v = (1 - Bhat) * x
	V = estvar 
	list(v = v, V = V, Bhat = Bhat)
}

	


load("LAmodel.Rda")
varalphaC = Vhat$par[1]
varepsC = Vhat$par[2]


# now simulate based on Ghat and density of standard error
require(REBayes)


# Select teachers with their VA at left tail alpha percent
# true null value is  qKW(Ghat, alpha)

set.seed(23)
R = 100
n = 10000

f = list()
pm = list()
alpha.gamma = expand.grid(c(0.01, 0.03, 0.05,0.1),c(0.05,0.1,0.2))
A = array(NA, c(R,14, nrow(alpha.gamma),3,3))

for (i in 1:R){
ss = sample(H$x, n, prob = H$y, replace=TRUE)
theta = sample(G$x, n, prob = G$y, replace=TRUE)
y = theta + rnorm(n, sd = ss)



f[[1]] = G
f[[2]] = BDGLmix(y, sigma = ss, df = 5)
f[[3]] = GLmix(y, sigma = ss, v = 500)
f[[4]] = KWsmooth(f[[3]], bw = bwKW(f[[3]], k = 0.75))
f[[5]] = EM2rule(y, ss)
VEM = f[[5]]$V
BhatEM = f[[5]]$Bhat
f[[5]] = f[[5]]$v
f[[6]] = y/ss
f[[7]] = y
f[[8]] = y * VEM/((VEM+ss^2))

for(k in 1:4) 
	pm[[k]] = predict(f[[k]], y, newsigma = ss) 
	
	
 for (j in 1:nrow(alpha.gamma)){
	alpha = alpha.gamma[j,1]
	gamma = alpha.gamma[j,2]
	truecnull = qKW(f[[1]], alpha)
for(k in 1:4){ # Tailp methods 
	    cnull <- qKW(f[[k]], alpha)
	    v = Lfdr(y,  G = f[[k]], s = ss, cnull = cnull)
	    T0 = quantile(v, 1-alpha, na.rm = TRUE)
	    int <- c(min(v)+1e-03, max(v) - 1e-03)
	 	T1 <- try(Finv(gamma, ThreshFDR, Fun = Lfdr, interval = int, G = f[[k]], s = ss, 
		H = H, domain = range(y),cnull = cnull), silent = TRUE)
	    if(inherits(T1, "try-error")) T1 = NULL
	    A[i,k,j,,] <- Thresh(v, T0, T1, theta, truecnull)	
	}

for(k in 1:4){ # PM methods
	   	cnull <- qKW(f[[k]], alpha)
	    v = pm[[k]]
	    if((nvna <- sum(is.na(v))) > 0) print(nvna) 
	    T0 = quantile(v, alpha, na.rm = TRUE)
	    int <- c(min(v)+1e-03, max(v) - 1e-03)
	   	T1 <- try(Finv(gamma, ThreshFDR, Fun = PM, interval = int, G = f[[k]], s = ss, 
		H = H,domain = range(y),cnull = cnull), silent = TRUE)
	    if(inherits(T1, "try-error")) T1 = NULL 
	    A[i,4+k,j,,] <- Thresh(-v, -T0, -T1, theta, truecnull)   # negative sign to fit the use of Thresh function
	}
	
# Normal TVA methods	
	Gnorm = list(x = seq(-4*sqrt(VEM), 4*sqrt(VEM), length = 100), y = dnorm(seq(-4*sqrt(VEM), 4*sqrt(VEM), length = 100), sd = sqrt(VEM)))	
	class(Gnorm) = "GLmix"

	#Chetty PM
	    v = f[[8]]
	    T0 = quantile(v, alpha, na.rm = TRUE)
	    int <- c(min(v)+1e-03, max(v) - 1e-03)
	    T1 <- try(Finv(gamma, ThreshFDREM, interval = int, V = VEM, Bhat = ss^2/(VEM+ss^2),s = ss, 
		alpha = alpha), silent = TRUE)
	    if(inherits(T1, "try-error")) T1 = NULL 
	    A[i,9, j,,] <- 	Thresh(-v, -T0, -T1, theta, truecnull)  # negative sign to fit the use of Thresh function
    
    # Chetty PM without FDR constraint 
	   A[i, 10, j,,] <- Thresh(-v, -T0, -T0, theta, truecnull)
	   
	# E&M from Normal assumption
		v = f[[5]]
		T0 = quantile(v, alpha)
		int <- c(min(v)+1e-03, max(v) - 1e-03)
		T1 <- try(Finv(gamma, ThreshFDREM, interval = int, V = VEM, Bhat = BhatEM, s = ss, 
		alpha = alpha), silent = TRUE)
		if(inherits(T1, "try-error")) T1 = NULL
		A[i,11, j,,] <- 	Thresh(-v, -T0, -T1, theta, truecnull)	    # negative sign to fit the use of Thresh function
		
	# E&M from Normal assumption without FDR constraint 
	   A[i,12,j,,] <- Thresh(-v, -T0, -T0, 	theta, truecnull)
	   
	# Naive MLE
		v = f[[7]]
		T0 = quantile(v, alpha)
		A[i,13, j,,] <- 	Thresh(-v, -T0, -T0, theta, truecnull)  # negative sign to fit the use of Thresh function
		
	# Naive p value
		v = f[[6]]
		T0 = quantile(v, alpha)
		A[i,14, j,,] <- 	Thresh(-v, -T0, -T0, theta, truecnull)  # negative sign to fit the use of Thresh function
print(c(i,j))
}
}
#plot(ss, -y, cex = 0.5, xlab = "s", ylab = "FE Estimates")
#agree = intersect(selcap[[3]], selcap[[8]])
#disPM = setdiff(selcap[[8]], selcap[[3]])
#distailP = setdiff(selcap[[3]], selcap[[8]])
#plot(ss[agree], -y[agree], col = 4, pch = 4, cex = 0.75, ylim = c(-1.2, 0))	
#points(ss[disPM],-y[disPM], col = 2, cex = 0.5)
#points(ss[distailP], -y[distailP], col = 3, cex = 0.5)