# Throughout G denotes the mixing density for the Gaussian sequence model
# G is encoded as a GLmix object, e.g.
# normal-discrete 
# contrast rejection region between conventional zero null vs. tail null and compare power

require(REBayes)

  
# So posterior means, and so forth can be computed with predict, e.g.

PM = function(x, G, s, cnull ) predict(G, x, newsigma = s)

# Local fdr needs a cutoff,

Lfdr = function(x, G, s, cnull ){
    v = G$x
    fv = G$y
    A = dnorm(outer(x, v, "-"), sd = s)
    if (sum(A)==0){
    	1}else{
    1 - c((A %*% (fv * (v < cnull)))/(A %*% fv))
    }
}
# Some generic code for computing inverses with uniroot
    # Useage Examples:
    # x0 = Finv(2, F = qnorm, sd = 2) 
    # x1 = mapply(Finv, 1:5/10, MoreArgs = list(F = qnorm, sd = 2)) 

Finv = function(y, F, interval = c(0,1), ...) 
    uniroot(function(x) F(x, ...) - y, interval, extendInt = "yes")$root 

# Generic thresholding functions

Thresh0 = function(lam, Fun, G, s, fs, domain, cnull){
    # find value such that Fun criterion is met
    ns = length(s)
    nu = rep(NA,ns)
    for (j in 1:ns){
        cut = Finv(lam, Fun, interval = domain, G = G, s = s[j], cnull)
        nu[j]  = sum(G$y * (1 - pnorm(cut - G$x, sd = s[j])))
        }
    crossprod(nu, fs)
    }   
Thresh1 = function(lam, Fun, G, s, fs, domain, cnull, znull){
    # find value such that Fun criterion is met
    ns = length(s)
    nu = rep(NA,ns)
    cnu = rep(NA,ns)
    #if(cnull == 4) browser()
    for (j in 1:ns){
        cut = Finv(lam, Fun, interval = domain, G = G, s = s[j], cnull)
        nu[j]  = sum(G$y * (1 - pnorm(cut - G$x, sd = s[j])))
	cnu[j]  = sum(G$y * (G$x < znull) * (1 - pnorm(cut - G$x, sd = s[j])))
        }
    crossprod(cnu, fs)/crossprod(nu, fs)
    }   
    
    
    # DGP: normal - discrete
     G = list(x = c(-1, 0.5, 5), y = c(0.85, 0.1, 0.05), sigma = 1)  
     # note the smaller null effect is change from 2 to 1 in this example so that threshold TLfdr3 does not become 1
    class(G) = "GLmix"
    rG = function(n, G, s) rnorm(n,sample(G$x, prob = G$y, replace = TRUE),s)
    s = seq(0.5,4,length = 200)  # sigma values
    #s = c(1,3)
    x = rG(200, G, s)
    # scaled beta (density of s monotone increasing on the support)
    #fs = dbeta(s/max(s), 6,1)/sum(dbeta(s/max(s), 6,1))  
    fs = rep(1/length(s), length(s))
    postmean = predict(G, x, newsigma = s)


# Now try plotting
    Tpm0 = Finv(0.05, Thresh0, c(0,4), Fun = PM, G = G, s = s, fs = fs, domain = c(-20,20), cnull=4)
    cpm0 = rep(NA, length(s))
    for(i in 1:length(s))
	cpm0[i] = Finv(Tpm0, PM, interval = c(-10,10), G = G, s = s[i]) 
    Tpm1 = Finv(0.1, Thresh1, c(0.1, 4.5), Fun = PM, G = G, s = s, fs = fs, domain = c(-20,20), cnull=4, znull = 4)
    cpm1 = rep(NA, length(s))
    for(i in 1:length(s))
	cpm1[i] = Finv(Tpm1, PM, interval = c(-20,20), G = G, s = s[i]) 

    TLfdr0 = Finv(0.05, Thresh0, c(0.01, 0.6), Fun = Lfdr, G = G, s = s, 
		  fs = fs, domain = c(-20, 20), cnull=4)
    cLfdr0 = rep(NA, length(s))
    for(i in 1:length(s))
	cLfdr0[i] = Finv(TLfdr0, Lfdr, interval = c(-20,20), G = G, s = s[i], cnull = 4) 
    TLfdr1 = Finv(0.1, Thresh1, c(0.001, 0.8), Fun = Lfdr, G = G, s = s, 
		  fs = fs, domain = c(-20, 20), cnull = 4, znull = 4)
    cLfdr1 = rep(NA, length(s))
    for(i in 1:length(s))
	cLfdr1[i] = Finv(TLfdr1, Lfdr, interval = c(-20,20), G = G, s = s[i], cnull = 4) 
	
	 TLfdr2 = Finv(0.05, Thresh0, c(0.1, 0.9999), Fun = Lfdr, G = G, s = s, 
		  fs = fs, domain = c(-20, 20), cnull=0)
    cLfdr2 = rep(NA, length(s))
    for(i in 1:length(s))
	cLfdr2[i] = Finv(TLfdr2, Lfdr, interval = c(-20,20), G = G, s = s[i], cnull = 0) 
    TLfdr3 = Finv(0.1, Thresh1, c(0.1, 0.99999999), Fun = Lfdr, G = G, s = s, 
		  fs = fs, domain = c(-20, 20), cnull = 0, znull = 4)
    cLfdr3 = rep(NA, length(s))
    for(i in 1:length(s))
	cLfdr3[i] = Finv(TLfdr3, Lfdr, interval = c(-20,20), G = G, s = s[i], cnull = 0) 
	



# plot reject region for two Lfdr with different null
pdf("thresh_eg_normaldiscrete_zeronull.pdf")
plot(s, cLfdr0, ylim = c(0,18), type="l",lwd = 2, ylab = "Threshold", xlab = expression(sigma))
#lines(s,cLfdr1,col = 2)
#lines(s, cLfdr2,lty = 2)
lines(s, cLfdr3, col = 2,  lwd = 2, lty = 2)
legend("topleft", c("zeroNull", "tailNull"), col = c(2,1), lty = c(2,1), lwd = c(2,2))

## highlight polygon 
loc = which.min(abs(cLfdr0-cLfdr3))
polygon(x = c(s[1],s[1:loc], s[1:loc]), y = c(cLfdr0[1], cLfdr3[1:loc],cLfdr0[1:loc]) ,density = 20, angle = 90, lty = 2)
polygon(x = c(s[loc],s[(loc+1):length(s)], s[length(s)], s[length(s):(loc+1)]), y = c(cLfdr3[loc], cLfdr0[(loc+1):length(s)],cLfdr3[length(s)], cLfdr3[length(s):(loc+1)]),  ,density = 20, angle = 90, col=4)
lines(s, cLfdr3, col = 2, lwd = 2, lty = 2)
lines(s, cLfdr0,lwd = 2)
dev.off()

    
    
   power = function(cut, s, fs, G, znull){
   	# P(non-null case & reject)/P(non-null) : interpret as among all non-null cases, what's the probability of correct rejection. 
   	 ns = length(s)
    cnu = rep(NA,ns)
    #if(cnull == 4) browser()
    for (j in 1:ns){
	cnu[j]  = sum(G$y * (G$x > znull) * (1 - pnorm(cut[j] - G$x, sd = s[j])))
        }
        nnprop = sum(G$y * (G$x > znull))
    crossprod(cnu, fs)/nnprop
    }   

power(cLfdr0,s,fs,G,znull = 4)
power(cLfdr1,s,fs,G,znull = 4)
power(cLfdr2,s,fs,G,znull = 4)
power(cLfdr3,s,fs,G,znull = 4)
