# compared selected sets
# model
# t ~ N(alpha, theta/m)
# s ~ gamma(r, theta/r)
# m = 2r+1 
# NIX prior (0,1,6,1)



Lfdr = function(t, s, w, m, G, cnull ){ 
	# t: sample mean
	# s: sample variance
	# m: panel length
	# w: scale in sample mean, potentially can be different from m
    u = G$u
    v = G$v
    pu = length(u)
    pv = length(v)
    fuv = G$fuv
    uv <- expand.grid(alpha = u, theta = v)
    if (length(m) == 1) 
      m <- rep(m, length(t))
    r = (m-1)/2
    R <- outer(r * s, v, "/")
    G <- outer(s * gamma(r), rep(1, pv))
    r <- outer((m - 1)/2, rep(1, pv))
    Av <- outer((exp(-R) * R^r)/G, rep(1, pu))
    Av <- aperm(Av, c(1, 3, 2))
    Au <- dnorm(outer(outer(t, u, "-") * outer(sqrt(w), rep(1, 
        pu)), sqrt(v), "/"))
    Au <- Au/outer(outer(1/sqrt(w), rep(1, pu)), sqrt(v))
    A <- Av * Au
    B <- NULL
    for (j in 1:pv) B <- cbind(B, A[, , j])
    1 - c((B %*% (fuv * (uv[,1] < cnull)))/(B %*% fuv))
}


PM = function(t, s, w, m, G ){ 
	# t: sample mean
	# s: sample variance
	# m: panel length
	# w: scale in sample mean, potentially can be different from m
    u = G$u
    v = G$v
    pu = length(u)
    pv = length(v)
    fuv = G$fuv
    uv <- expand.grid(alpha = u, theta = v)
    if (length(m) == 1) 
      m <- rep(m, length(t))
    r = (m-1)/2
    R <- outer(r * s, v, "/")
    G <- outer(s * gamma(r), rep(1, pv))
    r <- outer((m - 1)/2, rep(1, pv))
    Av <- outer((exp(-R) * R^r)/G, rep(1, pu))
    Av <- aperm(Av, c(1, 3, 2))
    Au <- dnorm(outer(outer(t, u, "-") * outer(sqrt(w), rep(1, 
        pu)), sqrt(v), "/"))
    Au <- Au/outer(outer(1/sqrt(w), rep(1, pu)), sqrt(v))
    A <- Av * Au
    B <- NULL
    for (j in 1:pv) B <- cbind(B, A[, , j])
    c(B%*%(fuv * uv[,1]))/c(B%*%fuv)
}


Finv = function(y, F, interval = c(0,1), ...) 
    uniroot(function(x) F(x, ...) - y, interval, extendInt = "yes", maxiter = 50)$root 

ThreshFDR = function(lam, stat, v){
    # find value such that Fun criterion is met
    # v is the Lfdr statistics for specific alpha 
    # stat is the statistics used for ranking 
    # lam is the thresholding value 
    # this function approximates FDR for different values of lam 
    cnu = mean((1-v) * (stat > lam))
    nu = mean(stat > lam)
    cnu/nu
}   

Thresh <- function(v, T0, T1, theta, cnull){
    sel <- list()
    a = matrix(NA,3,3)
    if(!length(T1)) return(a)
    Pnonnull = mean(theta  >= cnull)
    trueset = which(theta >= cnull)
    sel[[1]] = which(v > max(T0, T1))
    sel[[2]] = which(v > T0)
    sel[[3]] = which(v > T1)
    for(i in 1:3){
	a[i,1] <- length(intersect(trueset,sel[[i]]))/n/Pnonnull
	a[i,2] <- length(setdiff(sel[[i]], trueset))/length(sel[[i]])
	a[i,3] <- length(sel[[i]])/n
    }
    a
}

fnix <- function(grid, alpha0, kappa0, nu0, sig0){
	# first entry of grid is the mean and second entry is the variance
	dnorm(grid[1], mean = alpha0, sd = sqrt((grid[2])/kappa0)) * exp(-nu0 * sig0^2/(2*grid[2])) * (sig0^2 * nu0/2)^(nu0/2)/(gamma(nu0/2) * ((grid[2]))^(1+0.5 * nu0))
	}
	
ftix <- function(grid, alpha0, kappa0, nu0, sig0, df = 1){
	# first entry of grid is the mean and second entry is the variance
	dt((grid[1] - alpha0)/sqrt(grid[2]/kappa0), df = df) * exp(-nu0 * sig0^2/(2*grid[2])) * (sig0^2 * nu0/2)^(nu0/2)/(gamma(nu0/2) * (grid[2])^(1+0.5 * nu0))
	}	

	
	
	
require(REBayes)
set.seed(23)
n = 10000
# DGP: NIX G (alpha0 = 0, kappa0 = 1, nu0 = 6, sig0 = 1)
u = seq(0, 5, length = 90)
#v = seq(0.5, 4, length = 50)
v = seq(0.5, 9, length = 50)
uv = as.matrix(expand.grid(alpha = u, theta = v))
#fuv = apply(uv, 1, fnix, alpha0 = 1, kappa0 = 8, nu0 = 6, sig0 = 1)
fuv = apply(uv, 1, fnix, alpha0 = 0, kappa0 = 1, nu0 = 6, sig0 = 1)

fuv = fuv/sum(fuv)
G = list(u = u, v = v, fuv = fuv)
class(G) = "GLVmix"
#contour(u,v,matrix(fuv,90,50))
#plot(G)


#load("/Users/jiayinggu/Dropbox/empirical_bayes_ranking/data/Dialysis/Dialysis_estimation_3yr.Rda")
#rm(s,t,w,m,n,alpha,gamma)
#G = KWfit[[1]]
uv = as.matrix(expand.grid(alpha = G$u, theta = G$v))

alpha = 0.05
gamma = 0.1
n = 50000
sampler = sample(nrow(uv), n, prob = pmax(0,G$fuv), replace = TRUE)

	loc.scale = uv[sampler,]
	m = 9
	#w = rgamma(n,3,2)*200
	w = rep(m,n)
	t = rnorm(n, mean = loc.scale[,1], sd = sqrt((loc.scale[,2])/w))
	s = rgamma(n, shape = (m-1)/2, scale = (loc.scale[,2])/((m-1)/2))
	
	f= G
	
	#nd = data.frame(t = t, s = s, m = rep(9,n))
	pm= PM(t,s,w,m, G)
	Gcnull = qKW2(f, 1 - alpha)
	tp = Lfdr(t,s,w, m,  G = f, cnull = Gcnull)
	
	T01 = quantile(tp, 1-alpha)
	T11 = try(Finv(gamma, ThreshFDR, interval = c(0.01, 0.9), stat = tp, v = tp), silent = TRUE)
	
	T02 = quantile(pm, 1-alpha)
	T12 = try(Finv(gamma, ThreshFDR,stat = pm, v = tp), silent = TRUE)
pdf("nixc.pdf", height = 5, width = 10)	
par(mfrow=c(1,2))

criteria.cap = list(Tailp = which(tp >= T01), Tweedie = which(pm > T02))
agree = intersect(criteria.cap[[1]], criteria.cap[[2]])
dis1 = setdiff(criteria.cap[[1]],criteria.cap[[2]])
dis2 = setdiff(criteria.cap[[2]], criteria.cap[[1]])
	

	plot(sqrt(s[agree]), t[agree],col = "grey", cex = 0.5, 
	     xlab = expression(sqrt(s)), ylab = "y", xlim = c(0,5), 
	     ylim =c(2, 8.5), main = "Capacity constraint")
	points(sqrt(s[dis1]),t[dis1],col=2,cex = 0.5, pch = 3)
	points(sqrt(s[dis2]),t[dis2],col=3,cex= 0.5, pch = 4)
	legend("topleft", c("All agreed", "Tailp extra", "PM extra"), col = c(1,2,3), pch = c(1,3,4))
	
	criteria = list(Tailp = which(tp >= max(T01,T11)), 
			Tweedie = which(pm > max(T02,T12)),
			true = which(loc.scale[,1]>= Gcnull))
agree = intersect(criteria[[1]], criteria[[2]])
dis1 = setdiff(criteria[[1]], criteria[[2]])
dis2 = setdiff(criteria[[2]], criteria[[1]])

	plot(sqrt(s[agree]), t[agree],col = "grey", cex = 0.5, 
	     xlab = expression(sqrt(s)), ylab = "y", xlim = c(0,5), 
	     ylim =c(2, 8.5), main = "FDR constraint")
	points(sqrt(s[dis1]),t[dis1],col=2,cex = 0.5, pch = 3)
	points(sqrt(s[dis2]),t[dis2],col=3,cex= 0.5, pch = 4)
	legend("topleft", c("All agreed", "Tailp extra", "PM extra"), col = c(1,2,3), pch = c(1,3,4))

dev.off()
	
