#load("nix.Rda")
k0 = 1
mu0 = 0
v0 = 6
sig0 = 1
T = 9

# construct level curves
alpha = 0.05
theta.alpha = mu0 + sqrt(sig0^2/k0) * qt(1-alpha, df = v0)
y = seq(1,3.5,length = 200)
s = seq(0.01, 6, length = 200)  # note this is supposed to be square root of sample variance
vys = matrix(NA, nrow = length(y), ncol = length(s))
for (i in 1:length(s)){
    for (j in 1:length(y)){
	D = c(y[j], s[i])
	kn = k0+ T
	mun = (k0*mu0 + T*D[1])/kn
	vn = v0+ T
	signsq = (v0 * sig0^2 + (T-1)*D[2]^2 + T*k0*(mu0-D[1])^2/kn)/vn
	vys[i,j] = 1 - pt((theta.alpha - mun)/(sqrt(signsq)/sqrt(kn)), df = vn)
	}
}
# posterior mean of mu is mun 
# level curves based on posterior mean 
pys = matrix(NA, nrow = length(y), ncol = length(s))
for (i in 1:length(s)){
    for (j in 1:length(y)){
	D = c(y[j], s[i])
	kn = k0+ T
	mun = (k0*mu0 + T*D[1])/kn
	pys[i,j] = mun
	}
}
pdf("nix.pdf", height = 6, width = 9)
par(mfrow=c(1,2))

contour(s,y,vys, levels = c(0.05, 0.1, 0.2, 0.4, 0.6, 0.7,0.8, 0.9, 0.95, 0.99), 
	xlab = expression(sqrt(s)), ylab = "y", main = "Level Curves", lwd = 2)
contour(s,y,pys, add = TRUE, col = 2, lty = 2, 
	levels = c(1.4, 1.5, 1.7, 2, 2.2, 2.4, 2.6, 3), lwd = 2)	
legend("bottomleft", c("PM","TP"), col = c(2,1), lty = c(2,1), lwd = 2)


# simulation approach normal conjugacy 

FDRcut1 = function(c, value, theta, cnull, gamma ){
# for any thresholding rules: 1(value >= c)
# calculate trueFDR - FDRcontrol 
# uniroot will find the cutvalue c given gamma. 
mean((1-value - gamma)*(value >= c))/mean((value >= c))  
# this should approximate well, at least for when G is the true G0 and for tailp rules. 
#Doesn't work for other rules. 
}

FDRcut2 = function(c, value, theta, cnull, gamma ){
# for any thresholding rules: 1(value >= c)
# calculate trueFDR - FDRcontrol 
# uniroot will find the cutvalue c given gamma.
mean((value >= c & theta < cnull))/mean(value >= c) - gamma   #this is not quite a feasible rule 
}

# Bayes procedure with capacity and FDR constraint
set.seed(123)
k0 = 1
mu0 = 0
v0 = 6
sig0 = 1
T = 9
r = (T-1)/2
n = 50000
# first sample sig^2 

sigsq = v0 * sig0^2 /rchisq(n, df = v0)
# then sample theta 
theta = rnorm(n, mean = mu0, sd = sqrt(sigsq/k0))
# then sample (X,S) [sample mean and sample variance]
y = rnorm(n, mean = theta, sd = sqrt(sigsq/T))
s = sqrt(rgamma(n, shape = r, scale = sigsq/r))
valpha = rep(NA, n)
palpha = rep(NA, n)
alpha = 0.05
theta.alpha = mu0 + sqrt(sig0^2/k0) * qt(1-alpha, df = v0)

for (i in 1:length(y)){
    D = c(y[i], s[i])
    kn = k0+ T
    mun = (k0*mu0 + T*D[1])/kn
    vn = v0+ T
    signsq = (v0 * sig0^2 + (T-1)*D[2]^2 + T*k0*(mu0-D[1])^2/kn)/vn
    valpha[i] = 1 - pt((theta.alpha - mun)/(sigma = sqrt(signsq)/sqrt(kn)), df = vn)
    palpha[i] = mun
}
gamma = 0.1

TLfdr0 = quantile(valpha, 1-alpha)
TLfdr1 = uniroot(FDRcut2,interval = c(0, max(valpha)-1e-03), 
		 value = valpha, theta = theta, cnull = theta.alpha, gamma = gamma)$root

Tpm0 = quantile(palpha, 1-alpha)
Tpm1 = uniroot(FDRcut2, interval = c(0, max(palpha)-1e-03), 
	       value = palpha, theta = theta, cnull  = theta.alpha, gamma = gamma)$root

ygrid = seq(2, 3, length = 100)
sgrid = seq(0.01,6, length = 100)
vys = matrix(NA, nrow = length(ygrid), ncol = length(sgrid))
pys  = matrix(NA, nrow = length(ygrid), ncol = length(sgrid))
for (i in 1:length(sgrid)){
    for (j in 1:length(ygrid)){
	D = c(ygrid[j], sgrid[i])
	kn = k0+ T
	mun = (k0*mu0 + T*D[1])/kn
	vn = v0+ T
	signsq = (v0 * sig0^2 + (T-1)*D[2]^2 + T*k0*(mu0-D[1])^2/kn)/vn
	vys[i,j] = 1 - pt((theta.alpha - mun)/(sigma = sqrt(signsq)/sqrt(kn)), df = vn)
	pys[i,j] = mun
	}
}
contour(sgrid,ygrid,vys, levels = round(max(TLfdr0,TLfdr1), digits = 3), lwd = 2, 
	xlab = expression(sqrt(s)), ylab = "y", main = "Selection Boundary")
contour(sgrid, ygrid,pys,levels = round(max(Tpm0, Tpm1),digits = 3), add = TRUE, col = 2, lty = 2, lwd = 2)
legend("bottomright", c("PM","TP"), col = c(2,1), lty = c(2,1), lwd = 2)
dev.off()
