# discrete-normal model 
PM = function(x, s, m, G,  cnull) {
	u = G$x[,1]
	v = G$x[,2]
	fuv = G$y
	r = (m-1)/2
	A = matrix(NA, length(x), length(u))
	for (i in 1:length(x)){
		for (j in 1:length(u)){
			A[i,j] = dnorm(x[i], mean = u[j], sd = sqrt(v[j]^2/m)) * dgamma(s[i]^2, shape = r, scale = v[j]^2/r)
			}
			}
	as.vector((A%*%(u * fuv))/A%*%fuv)		
	}

# Local fdr needs a cutoff,

Lfdr = function(x, s, m, G, cnull){
    u = G$x[,1]
	v = G$x[,2]
	fuv = G$y
	r = (m-1)/2
	A = matrix(NA, length(x), length(u))
	for (i in 1:length(x)){
		for (j in 1:length(u)){
			A[i,j] = dnorm(x[i], mean = u[j], sd = sqrt(v[j]^2/m)) * dgamma(s[i]^2, shape = r, scale = v[j]^2/r)
			}
			}
    1 - c((A %*% (fuv * (u < cnull)))/(A %*% fuv))
}

# Linear shrinkage rule (implementing the empirical Bayes version of posteria mean)
hyperMLE <- function(para, y = y, s = s, t = t){
	# Normal-inverse-chi-squared prior 
	# panel data normal model with conjugate prior 
	# MAP (Gu, Zaheer, Li, IEEE (2014))
	# paper title: multiple population moment estimation: exploiting inter population correlation for efficient moment estimation in analog/mixed-signal validation
	# y is sample mean 
	# s is sample variance
	theta0 = para[1]
	kappa0 = para[2]
	nu0 = para[3]
	sig0sq = para[4]
	kappaT = kappa0 + t
	nuT = nu0 + t
	thetaT = (kappa0 * theta0 + t * y)/kappaT
	sigTsq = (nu0 * sig0sq + (t-1) * s + t * kappa0 * (theta0 - y)^2 /(kappa0 + t))/nuT
	-sum(log((gamma(nuT/2) / gamma(nu0/2)) * sqrt(kappa0 / kappaT) *( nu0 * sig0sq)^(nu0/2)/(nuT  * sigTsq)^(nuT/2) /pi^(T/2)))
	}

LinearPM = function(x, s, m, cnull, kappa0, theta0){
	(kappa0 * theta0 + m * x)/(kappa0 + m)
	}

Linearvalpha = function(x, s, m, cnull, para){
	# calculate P(theta >= theta_alpha | Y, S) based on NIX prior for (theta, sigma^2)
	# = 1 - F((theta_alpha - thetaT)/sqrt(sigTsq/kappaT)) with F being CDF of t with df = nuT 
	# need to feed in sample variance for s !!!
	theta0 = para[1]
	kappa0 = para[2]
	nu0 = para[3]
	sig0sq = para[4]
	kappaT = kappa0 + m
	nuT = nu0 + m
	thetaT = (kappa0 * theta0 + m * x)/kappaT
	sigTsq = (nu0 * sig0sq + (m-1) * s + m * kappa0 * (theta0 - x)^2 /(kappa0 + m))/nuT
	vlalpha = 1 - pt((cnull - thetaT)/sqrt(sigTsq/kappaT), df = nuT)
	return(vlalpha) 
	}
	

# Some generic code for computing inverses with uniroot
    # Useage Examples:
    # x0 = Finv(2, F = qnorm, sd = 2) 
    # x1 = mapply(Finv, 1:5/10, MoreArgs = list(F = qnorm, sd = 2)) 


rG = function(n, T, G) {
r = (T-1)/2
sampler = sample(1:nrow(G$x),n, prob = G$y, replace = TRUE)
x = rnorm(n, G$x[sampler,1], sd = sqrt(G$x[sampler,2]^2/T))
s = sqrt(rgamma(n, shape = r, scale = G$x[sampler,2]^2/r))
list(x = x, s = s, T = T, sampler = sampler)
}

FDRcut1 = function(c, value, theta, cnull, gamma ){
# this should approximate well, at least for when G is the true G0 and for 
# TP rules. Doesn't work for other rules. 
# for any thresholding rules: 1(value >= c)
# calculate trueFDR - FDRcontrol 
# uniroot will find the cutvalue c given gamma. 
mean((1-value - gamma)*(value >= c))/mean((value >= c))  
}

FDRcut2 = function(c, value, theta, cnull, gamma ){
#this is not quite a feasible rule since in practise theta not observed
# for any thresholding rules: 1(value >= c)
# calculate trueFDR - FDRcontrol 
# uniroot will find the cutvalue c given gamma.
mean((value >= c & theta < cnull))/mean(value >= c) - gamma   
}

set.seed(23)
T = 9
n = 50000
r = (T-1)/2
G = list(x = matrix(c(-1, 4, 5, 6,2,4), nrow = 3), y = c(0.85, 0.1, 0.05), sigma = 1)
# could also try matrix(c(-1, 4, 5, 6,2,6), then rej reg monotone, 
# it is crucial here 4 and 5 are close, so that PM rule are confused

D = rG(n, T, G)
truecnull = 4.7
alpha = 0.05
valpha = rep(NA,n)
palpha = rep(NA,n)

hyperest = optim(par = c(0, 7,30,30), hyperMLE, method = "L-BFGS-B", y = D$x, s = D$s^2, t = rep(T, n))$par
cnull = hyperest[1] + sqrt(hyperest[4]/hyperest[2]) * qt(1-alpha, df = hyperest[3])  


plalpha = rep(NA, n)
vlalpha = rep(NA,n)
for (i in 1:n){
    valpha[i] = Lfdr(D$x[i], D$s[i], m = D$T, G = G, cnull = truecnull)
    palpha[i] = PM(D$x[i], D$s[i], m = D$T, G = G, cnull = truecnull)
    plalpha[i] = LinearPM(D$x[i], D$s[i]^2, m = T, cnull = cnull, kappa0 = hyperest[2], theta0 = hyperest[1])
    vlalpha[i] = Linearvalpha(D$x[i], D$s[i]^2, m = T, cnull = cnull, para = hyperest)
}

gamma = 0.1

TLfdr0 = quantile(valpha, 1-alpha)
TLfdr1 = uniroot(FDRcut2,interval = c(0, max(valpha)-1e-03), value = valpha, 
		 theta = G$x[D$sampler,1],cnull = truecnull, gamma = gamma)$root

Tpm0 = quantile(palpha, 1-alpha)
Tpm1 = uniroot(FDRcut2, interval = c(0, max(palpha)-1e-03), value = palpha,
	       theta = G$x[D$sampler,1],cnull = truecnull, gamma = gamma)$root

Tpml0 = quantile(plalpha, 1-alpha)
Tpml1 = uniroot(FDRcut2, interval = c(min(plalpha)+1e-03, max(plalpha)-1e-03), 
		value = plalpha, theta = G$x[D$sampler,1],cnull = cnull, gamma = gamma)$root

TLfdrl0 = quantile(vlalpha, 1-alpha)
TLfdrl1 = uniroot(FDRcut2,interval = c(0, max(vlalpha)-1e-03), value = vlalpha, 
		  theta = G$x[D$sampler,1],cnull = cnull, gamma = gamma)$root

ygrid = seq(1, 10, length = 200)
sgrid = seq(0.01,10, length = 200)
vys = matrix(NA, nrow = length(ygrid), ncol = length(sgrid))
pys  = matrix(NA, nrow = length(ygrid), ncol = length(sgrid))
plys  = matrix(NA, nrow = length(ygrid), ncol = length(sgrid))
vlys = matrix(NA, nrow = length(ygrid), ncol = length(sgrid))
for (i in 1:length(sgrid)){
for (j in 1:length(ygrid)){
	vys[i,j] = Lfdr(ygrid[j], sgrid[i], m = D$T, G = G, cnull = truecnull)
	pys[i,j] = PM(ygrid[j], sgrid[i], m = D$T,  G = G, cnull = truecnull)
	plys[i,j] = LinearPM(ygrid[j], sgrid[i]^2, m = D$T, kappa0 = hyperest[2], theta0 = hyperest[1])
	vlys[i,j] = Linearvalpha(ygrid[j], sgrid[i]^2, m = D$T, cnull = cnull, para = hyperest)
	}
}
pdf("ndpanel.pdf", height = 5, width = 10)	
par(mfrow=c(1,3))		
contour(sgrid,ygrid, vys, levels = c(0.01, 0.05, 1:4/5), 
	xlab = expression(sqrt(s)), ylab = "y", main = "TP Level Curves", lwd = 1.5)
contour(sgrid,ygrid,pys,levels = c(4.8, 4.5,4.1, 4,3.5,2.5,1),col=2,lty = 2, 
	xlab = "s", ylab = "y", main = "PM Level Curves", lwd = 1.5)	

contour(sgrid,ygrid,vys, levels = round(max(TLfdr0,TLfdr1),digits = 3),
	xlab = expression(sqrt(s)), ylab = "y", main = "Selection Boundaries", lwd = 1.5)
contour(sgrid, ygrid,pys,levels = round(max(Tpm0, Tpm1), digits = 3), 
	add = TRUE, col = 2, lty = 2, lwd = 1.5)
dev.off()
