# An attempt to re-organize the threshold code a bit.
# Throughout G denotes the mixing density for the Gaussian sequence model
# G is encoded as a GLmix object, e.g.
# normal-discrete 

require(REBayes)

  
# So posterior means, and so forth can be computed with predict, e.g.

PM = function(x, G, s, cnull ) predict(G, x, newsigma = s)

# Local fdr needs a cutoff,

Lfdr = function(x, G, s, cnull ){
    v = G$x
    fv = G$y
    A = dnorm(outer(x, v, "-"), sd = s)
    if (sum(A)==0){
    	1}else{
    1 - c((A %*% (fv * (v < cnull)))/(A %*% fv))
    }
}
# Some generic code for computing inverses with uniroot
    # Useage Examples:
    # x0 = Finv(2, F = qnorm, sd = 2) 
    # x1 = mapply(Finv, 1:5/10, MoreArgs = list(F = qnorm, sd = 2)) 

Finv = function(y, F, interval = c(0,1), ...) 
    uniroot(function(x) F(x, ...) - y, interval, extendInt = "yes")$root 

# Generic thresholding functions

Thresh0 = function(lam, Fun, G, s, fs, domain, cnull){
    # find value such that Fun criterion is met
    ns = length(s)
    nu = rep(NA,ns)
    for (j in 1:ns){
        cut = Finv(lam, Fun, interval = domain, G = G, s = s[j], cnull)
        nu[j]  = sum(G$y * (1 - pnorm(cut - G$x, sd = s[j])))
        }
    crossprod(nu, fs)
    }   
Thresh1 = function(lam, Fun, G, s, fs, domain, cnull){
    # find value such that Fun criterion is met
    ns = length(s)
    nu = rep(NA,ns)
    cnu = rep(NA,ns)
    #if(cnull == 4) browser()
    for (j in 1:ns){
        cut = Finv(lam, Fun, interval = domain, G = G, s = s[j], cnull)
        nu[j]  = sum(G$y * (1 - pnorm(cut - G$x, sd = s[j])))
	cnu[j]  = sum(G$y * (G$x < cnull) * (1 - pnorm(cut - G$x, sd = s[j])))
        }
    crossprod(cnu, fs)/crossprod(nu, fs)
    }   
    
    
    # DGP: normal - discrete
     G = list(x = c(-1, 2, 5), y = c(0.85, 0.1, 0.05), sigma = 1)
    class(G) = "GLmix"
    rG = function(n, G, s) rnorm(n,sample(G$x, n, prob = G$y, replace = TRUE),s)
    s = seq(0.5,4,length = 200)  # sigma values
    x = rG(200, G, s)
    # scaled beta (density of s monotone increasing on the support)
    #fs = dbeta(s/max(s), 6,1)/sum(dbeta(s/max(s), 6,1))  
    fs = rep(1/length(s), length(s))
    postmean = predict(G, x, newsigma = s)


# Now try plotting
    Tpm0 = Finv(0.05, Thresh0, c(2,4), Fun = PM, G = G, s = s, fs = fs, domain = c(-2,7), cnull=4)
    cpm0 = rep(NA, length(s))
    for(i in 1:length(s))
	cpm0[i] = Finv(Tpm0, PM, interval = c(-2,7), G = G, s = s[i]) 
    Tpm1 = Finv(0.2, Thresh1, c(0.1, 4.3), Fun = PM, G = G, s = s, fs = fs, domain = c(-2,7), cnull=4)
    cpm1 = rep(NA, length(s))
    for(i in 1:length(s))
	cpm1[i] = Finv(Tpm1, PM, interval = c(-2,7), G = G, s = s[i]) 

    TLfdr0 = Finv(0.05, Thresh0, c(0.01, 0.6), Fun = Lfdr, G = G, s = s, 
		  fs = fs, domain = c(-2, 7), cnull=4)
    cLfdr0 = rep(NA, length(s))
    for(i in 1:length(s))
	cLfdr0[i] = Finv(TLfdr0, Lfdr, interval = c(-2,7), G = G, s = s[i], cnull = 4) 
    TLfdr1 = Finv(0.2, Thresh1, c(0.001, 0.8), Fun = Lfdr, G = G, s = s, 
		  fs = fs, domain = c(-2, 7), cnull = 4)
    cLfdr1 = rep(NA, length(s))
    for(i in 1:length(s))
	cLfdr1[i] = Finv(TLfdr1, Lfdr, interval = c(-2,7), G = G, s = s[i], cnull = 4) 



# sampling 
set.seed(1)
n = 10000
ss = runif(n, 0.5, 4)  # sigma values
mu = sample(c(-1, 2, 5), n, replace=TRUE, prob = c(0.85, 0.1, 0.05))
x = mu + rnorm(n, mean = 0, sd = ss)

A = dnorm(outer(x, G$x, "-"), sd = ss)
ghat = A%*%G$y
tghat = A%*%(G$y * (G$x > 4))
tailp = tghat/ghat
pm = A%*%(G$y * G$x)/ghat
ES = A %*%(G$y * (G$x < 4))/ghat


# plot reject region for two criteria and a realized sample

pdf("nd.pdf", width = 9, height = 4)
par(mfrow=c(1,3))
plot(s, cpm0, type="l", ylim = c(2,15),ylab = "Threshold", 
     xlab = expression(sigma), main = "Selection Boundaries")
lines(s, cLfdr0,lty=2)
lines(s,cpm1,col=2)
lines(s,cLfdr1,col=2,lty=2)
legend("topleft", c("Lfdr-C", "PM-C", "Lfdr-FDR","PM-FDR"), col = c(1,1,2,2), lty = c(2,1,2,1))


criteria.cap = list(Tailp = which(tailp >= TLfdr0), Tweedie = which(pm > Tpm0))
setallc = intersect(criteria.cap[[1]], criteria.cap[[2]])
set1diffc = setdiff(criteria.cap[[1]],setallc)
set2diffc = setdiff(criteria.cap[[2]], setallc)
plot(ss[setallc], x[setallc] , ylim =range(c(x[setallc], x[set1diffc],x[set2diffc])), 
     xlim = range(c(ss[setallc], ss[set1diffc], ss[set2diffc])), col = "grey",
     main = "Capacity constraint",   ylab = "y", xlab = expression(sigma))
points(ss[set1diffc], x[set1diffc], col = 2, pch = 3)
points(ss[set2diffc], x[set2diffc], col = 3 , pch = 4)
legend("topleft", c("All agreed", "Tailp extra", "PM extra"), col = c(1, 2, 3), pch = c(1, 3, 4))

criteria.fdr = list(Tailp = which(tailp >= TLfdr1), Tweedie = which(pm > Tpm1))
setallr = intersect(criteria.fdr[[1]], criteria.fdr[[2]])
set1diffr = setdiff(criteria.fdr[[1]],setallr)
set2diffr = setdiff(criteria.fdr[[2]], setallr)
plot(ss[setallr], x[setallr], ylim =range(c(x[setallc], x[set1diffc],x[set2diffc])), 
     xlim = range(c(ss[setallc], ss[set1diffc], ss[set2diffc])), col = "grey",
     main = "FDR constraint",  ylab = "y", xlab = expression(sigma))
points(ss[set1diffr], x[set1diffr], col = 2,  pch = 3)
points(ss[set2diffr], x[set2diffr], col = 3,  pch = 4)
legend("topleft", c("All agreed", "Tailp extra", "PM extra"), col = c(1, 2, 3), pch = c(1, 3, 4))
dev.off()
