# risk frontier based on Lfdr rule for counter-example on crossing behavior 


# Conditional tail probability function
valpha = function(y, s, G, Talpha = 5)
	sum(G$y * dnorm(y, G$x, s) * (G$x >= Talpha))/sum(G$y * dnorm(y, G$x, s))
Valpha = function(y,s, G, Talpha) {
    V = matrix(NA,length(y),1)
    for(i in 1:length(y)){
	    V[i] = valpha(y[i],s[i],G,Talpha)
	}
    V
}
rG = function(n, G, s) rnorm(n,sample(G$x, prob = G$y, replace = TRUE),s)
Ginv = function(G) stepfun(cumsum(G$y), c(G$x, G$x[length(G$x)]))

# Some experiments to explore "crossing"
require(rvalues)
require(REBayes)
# Comparison of npmle in the rvalues package with REBayes
if(FALSE){ # Test of npmle function from rvalues
    data(hiv)
    #f1 = npmle(hiv, family = tdist(df=6), maxiter = 25)
    plot(f1$support, f1$mix.prop, type = "l")
    f0 = TLmix(hiv$estimates/hiv$std.err, df = 6)
    plot(f0)
}
Lfdr = function(x, G, s, cnull ){
    v = G$x
    fv = G$y
    A = dnorm(outer(x, v, "-"), sd = s)
    if (sum(A)==0){
    	1}else{
    1 - c((A %*% (fv * (v < cnull)))/(A %*% fv))
    }
}
Finv = function(y, F, interval = c(0,1), ...) 
    uniroot(function(x) F(x, ...) - y, interval, extendInt = "yes")$root 
Thresh0 = function(lam, Fun, G, s, fs, domain, cnull){
    # find value such that Fun criterion is met
    ns = length(s)
    nu = rep(NA,ns)
    for (j in 1:ns){
        cut = Finv(lam, Fun, interval = domain, G = G, s = s[j], cnull)
        nu[j]  = sum(G$y * (1 - pnorm(cut - G$x, sd = s[j])))
        }
    crossprod(nu, fs)
    }  
    
 Thresh1 = function(lam, Fun, G, s, fs, domain, cnull ){
    # find value such that Fun criterion is met
    ns = length(s)
    nu = rep(NA,ns)
    cnu = rep(NA,ns)
    #if(cnull == 4) browser()
    for (j in 1:ns){
        cut = Finv(lam, Fun, interval = domain, G = G, s = s[j], cnull)
        nu[j]  = sum(G$y * (1 - pnorm(cut - G$x, sd = s[j])))
	cnu[j]  = sum(G$y * (G$x < cnull) * (1 - pnorm(cut - G$x, sd = s[j])))
        }
    crossprod(cnu, fs)/crossprod(nu, fs)
    }   
    
        
#G = list(x = c(-1,  2,3,4, 5), y = c(0.5,0.2,0.1,0.1,0.1), sigma = 1)
G = list(x = c(-1,  2,5), y = c(0.85,0.1,0.05), sigma = 1)
# G = list(x = seq(-3,3,length = 200), y = c(dnorm(seq(-3,3,length = 200))/sum(dnorm(seq(-3,3,length=200)))), sigma = 1)

class(G) = "GLmix"
rG = function(n, G, s) rnorm(n,sample(G$x, prob = G$y, replace = TRUE),s)
s = seq(0.5,4,length = 200)  # sigma values
x = rG(200, G, s)
# scaled beta (density of s monotone increasing on the support)
#fs = dbeta(s/max(s), 6,1)/sum(dbeta(s/max(s), 6,1))  
fs = rep(1/length(s), length(s))
#alphas = 1:25/50
alphas = c(0.04,0.05,0.051,0.06,0.08, 0.1, 0.12, 0.15)
gamma = c(0.01,0.05, 0.1, 0.15,0.3)
alpha_gamma = expand.grid(alphas, gamma)
cLfdr0 = matrix(NA, length(s), nrow(alpha_gamma))
cLfdr1 = matrix(NA, length(s), nrow(alpha_gamma))
cLfdr2 = matrix(NA, length(s), nrow(alpha_gamma))
for(j in 1:nrow(alpha_gamma)){
    TLfdr0 = Finv(alpha_gamma[j,1], Thresh0, c(0.01, 0.99), Fun = Lfdr, G = G, s = s,
                  fs = fs, domain = c(-2, 7), cnull=Ginv(G)(1-alpha_gamma[j,1])-0.01)
    TLfdr1 = Finv(alpha_gamma[j,2], Thresh1, c(0.01, 0.99), Fun = Lfdr, G = G, s = s, fs = fs, domain = c(-2,7), cnull=Ginv(G)(1-alpha_gamma[j,1])-0.01)    
       
    for(i in 1:length(s)){
	cLfdr0[i,j] = Finv(max(TLfdr0, TLfdr1), Lfdr, interval = c(-4,10), G = G, s = s[i], cnull = Ginv(G)(1-alpha_gamma[j,1])-0.01)  #both constraint, whichever binds
	cLfdr1[i,j] = Finv(TLfdr0, Lfdr, interval = c(-2,7), G = G, s = s[i], cnull = Ginv(G)(1-alpha_gamma[j,1])-0.01)	 #just capacity constraint
	cLfdr2[i,j] = Finv(TLfdr1, Lfdr, interval = c(-2,7), G = G, s = s[i], cnull = Ginv(G)(1-alpha_gamma[j,1])-0.01)	 #just FDR constraint
	}
	print(j)
}
#matplot(s, cLfdr0[1:length(alphas),], type = "l", lwd = 2)
#legend("topleft", paste("a = ", alphas), lwd = 2, col = 1:6, lty = 1:6)
#title("Posterior Tail Probability Rule")

missed_discovery = function(cut, s,fs, cnull, G){
	# P(non-rejection, non-null)
	ns = length(s)
    cnu = rep(NA,ns)
    for (i in 1:ns){
	cnu[i]  = sum(G$y * (G$x >= cnull) * pnorm(cut[i] - G$x, sd = s[i]))
        }
	crossprod(cnu,fs)
	}

objeva = rep(NA, nrow(alpha_gamma))
objeva1 = rep(NA, nrow(alpha_gamma))
objeva2 = rep(NA, nrow(alpha_gamma))
for (j in 1:nrow(alpha_gamma)){
objeva[j] = missed_discovery(cLfdr0[,j], s,fs,cnull = Ginv(G)(1-alpha_gamma[j,1])-0.01,G )
objeva1[j] = missed_discovery(cLfdr1[,j], s,fs,Ginv(G)(1-alpha_gamma[j,1])-0.01,G )
objeva2[j] = missed_discovery(cLfdr2[,j], s,fs,Ginv(G)(1-alpha_gamma[j,1])-0.01,G )
}

pdf("Ceg1_obj.pdf", height = 6, width = 6)
plot(alphas, objeva[1:length(alphas)],type="b", ylim = c(0,0.15), lwd = 2,
     xlab = expression(alpha), ylab = "Missed Discovery Probability")

lines(alphas, objeva[(1+length(alphas)):(2*length(alphas))],lwd = 2, pch = 2, type = "b", col=2)

lines(alphas, objeva[(1+2*length(alphas)):(3*length(alphas))],lwd = 2,pch = 3,  type = "b", col=3)

lines(alphas, objeva[(1+3*length(alphas)):(4*length(alphas))],lwd = 2,pch = 4,  type = "b", col=4)

lines(alphas, objeva[(1+4*length(alphas)):(5*length(alphas))],lwd = 2,pch = 5,  type = "b", col=6)
lines(alphas, objeva1[(1+4*length(alphas)):(5*length(alphas))],lwd = 2,lty = 2,pch = 6,  type = "b", col=1)

labs = c("FDR = 0.01","FDR = 0.05", "FDR = 0.1", "FDR = 0.15", "FDR=0.3", "Capacity")
legend("bottomright", labs, col = c(1,2,3,4,6,1),lwd = 2, lty = c(1,1,1,1,1,2), pch = 1:6)
dev.off()
