require(REBayes)
load("D.Rda")

pdf("conflict.pdf", height = 9, width = 8)
par(mfrow = c(2,2))
source("fit1d.R")
z = fit1d(1:3, D)
sR = selectR1d(z, alpha = 0.04, gamma = 0.2)
sL = selectL1d(z, alpha = 0.22, gamma = 0.2)

L25 = level_plot(z, alpha = 0.22, gamma = 0.2, tail = "L", cindex = c(2, 5), constraint = "cap", ygrid = seq(0.5, 1, length = 300), wgrid = 8*(1:100))
title("(a)")

# estimated FDR level of MLE rule under capacity constraint 
cnull = qKW(z$fs, 0.22)
tp = Lfdr.GLmix_temp(z$S, z$fs, sqrt(1/z$W), cnull = cnull, tail = "L")
estfdr_MLE = ThreshFDR(-L25$thresh[5,1], stat = -z$S, v  = tp)


A = sL$A  # cap and fdr constraint
B = sL$B  #cap constraint
cols = c("grey", "blue", "red")
Aagree = intersect(which(A[,2]==1), which(B[,5]==1))  # compare TP under fdr control vs MLE with just cap control.
Adis1 = setdiff(which(A[,2]==1), which(B[,5]==1))
Adis2 = setdiff(which(B[,5]==1), which(A[,2]==1))
ygrid = seq(0.5, 1, length = 300)
wgrid = 8*(1:100)
contour(ygrid, wgrid, L25$cls[,,2], lwd = 2, col = 4,
			levels = round(L25$thresh[2,2],digits = 3),
			xlab = "T", ylab = "W",  drawlabels = FALSE)
abline(v = L25$thresh[5,1], lwd = 2, col = 2)
points(z$S[Aagree], z$W[Aagree], col = "grey", cex = 0.5)
		points(z$S[Adis1],z$W[Adis1],col=4,cex = 0.5)
		points(z$S[Adis2],z$W[Adis2],col=2,cex= 0.5)
		text = c("Agree", paste("TP", " extra", sep =""), 
			 paste("MLE", " extra", sep=""))
		legend("topleft", text,
		       col = cols, pch = 1, cex = 0.95, bty = "n")
title("(b)")


level_plot(z, alpha = 0.22, gamma = 0.2, tail = "L", ygrid = seq(0.5, 1, length = 300), 
	   wgrid = 8*(1:100), cindex = c(2, 8), constraint = "cap")
title("(c)")

#level_plot(z, alpha = 0.22, gamma = 0.2, tail = "L", ygrid = seq(0.5, 1, length = 300), 
#	   wgrid = 8*(1:100), cindex = c(2, 8), constraint = "fdr")  # JS controls fdr by using the Gaussian G estimates
#title("(d)")

# estimated FDR level of JS rule under just capacity constraint 
est = optim(c(0,1), lik, x = z$S, s = sqrt(1/z$W))$par
estmean = est[1]
estvar = est[2]
# Linear rule   
R = estmean + (z$S-estmean) * estvar/(estvar+(1/z$W))
estfdr_JS = ThreshFDR(-L25$thresh[8,1], stat = -R, v = tp)


Aagree = intersect(which(A[,2]==1), which(B[,8]==1))  # compare TP under fdr control vs JS with just cap control.
Adis1 = setdiff(which(A[,2]==1), which(B[,8]==1))
Adis2 = setdiff(which(B[,8]==1), which(A[,2]==1))
ygrid = seq(0.5, 1, length = 300)
wgrid = 8*(1:100)
contour(ygrid, wgrid, L25$cls[,,2], lwd = 2, col = 4,
			levels = round(L25$thresh[2,2],digits = 3),
			xlab = "T", ylab = "W",  drawlabels = FALSE)

contour(ygrid, wgrid, L25$cls[,,8], lwd = 2,
			levels = round(L25$thresh[8,1],digits = 3),
			xlab = "T", ylab = "W", add=TRUE, col = 2 , drawlabels = FALSE)
			
points(z$S[Aagree], z$W[Aagree], col = "grey", cex = 0.5)
		points(z$S[Adis1],z$W[Adis1],col=4,cex = 0.5)
		points(z$S[Adis2],z$W[Adis2],col=2,cex= 0.5)
		text = c("Agree", paste("TP", " extra", sep =""), 
			 paste("JS", " extra", sep=""))
		legend("topleft", text,
		       col = cols, pch = 1, cex = 0.95, bty = "n")
title("(d)")



dev.off()
