# Some exploratory modeling for the Dialysis Data
# Temporal dependence in SMR
load("D.Rda")
n = dim(D)[1]
rhohat = rep(NA,n)
pvalue = rep(NA,n)
Y = D[,,1]^0.5
S = 1/sqrt(4*D[,,4])
require(dynlm)
for(i in 1:n){
    y = zoo::zoo(Y[i,])
    if(any(y == -Inf))next
    Z = dynlm(y ~ L(y,1))
    rhohat[i] = Z$coef[2]
}
pdf(width = 6, height = 6, file = "GPrho.pdf")
hist(rhohat,80, xlab = expression(hat(rho)), main = "", freq = FALSE)
dev.off()
