# Comparison of other bootstrap options 
require(quantreg)
set.seed(1729) # Has been known to claim singular design matrix
tau = 0.8
R = 200
ns = rev(c(5000, 25000,125000,625000))
ps = rev(c(2,5,10,20))
T <- array(0, c(length(ns), length(ps), 2))
Af <- Ag <- list()
k = 0
for(i in 1:length(ns)){
    n = ns[i]
    y = rnorm(n)
    for(j in 1:length(ps)){
	k = k + 1
	p = ps[j]
	x = matrix(rnorm(n*p),n,p)
	f = rq(y ~ x,tau, method = "fn")
	g = rq(y ~ x,tau, method = "conquer")
	T[i,j,1] <- system.time(Af[[k]] <- summary(f, se = "boot", bsmethod = "pwxy")$coef)[1] 
	T[i,j,2] <- system.time(Ag[[k]] <- summary(g, R = 200)$coef)[1] 
	print(c(i,j))
    }
}
