
# Tests of fitting algorithms (with factor variable)

set.seed(1729) # Has been known to claim singular design matrix
ns = c(10000, 25000, 125000, 625000)
qs = c(50, 100, 200, 400)
p = 5
A <- T <- array(0, c(length(ns), length(qs), 3))
for(i in 1:length(ns)){
    n = ns[i]
    X = matrix(rnorm(n*p),n,p)
    y = rnorm(n)
    for(j in 1:length(qs)){
	q = qs[j]
	z = factor(sample(q,n, replace = TRUE))
	T[i,j,1] <- system.time(A[i,j,1] <- rq(y ~ X + z, 0.5, method = "br")$coef[1])[1] 
	T[i,j,2] <- system.time(A[i,j,2] <- rq(y ~ X + z, 0.5, method = "fn",eps = 1.0e-5)$coef[1])[1] 
	T[i,j,3] <- system.time(A[i,j,3] <- rq(y ~ X + z, 0.5, method = "sfn", data = NULL)$coef[1])[1] 
	print(c(i,j))
    }
}
rm(X,y,z)
dimnames(T) <- dimnames(A) <- list(paste("n=",ns),paste("q=",qs),c("br","fn","sfn"))


