"GJKP.ranks"<-
function(v, score = "wilcoxon")
{
#integrate the ahat(t) with respect to the chosen score function
	if(score == "wilcoxon") {
		J <- ncol(v$sol)
		dt <- v$sol[1, 2:J] - v$sol[1, 1:(J - 1)]
		ranks <- as.vector((0.5 * (v$dsol[, 2:J] + v$dsol[, 1:(J - 1)]) %*%
			dt) - 0.5)	#return(ranks, A2 = 1/12)
		return(ranks)
	}
	else if(score == "normal") {
		J <- ncol(v$sol)
		dt <- v$sol[1, 2:J] - v$sol[1, 1:(J - 1)]
		dphi <- c(0, dnorm(qnorm(v$sol[1, 2:(J - 1)])), 0)
		dphi <- diff(dphi)
		ranks <- as.vector((((v$dsol[, 2:J] - v$dsol[, 1:(J - 1)]))) %*% (
			dphi/dt))	#return(ranks, A2=1)
		return(ranks)
	}
	else if(score == "sign") {
		j.5 <- sum(v$sol[1,  ] < 0.5)
		w <- (0.5 - v$sol[1, j.5])/(v$sol[1, j.5 + 1] - v$sol[1, j.5])
		r <- w * v$dsol[, j.5 + 1] + (1 - w) * v$dsol[, j.5]	
	#return(ranks = r - 1/2, A2=1/4)
		return(ranks = r - 1/2)
	}
	else stop("invalid score function")
}
"HK.test"<-
function(x, scores = c("wilcoxon", "normal", "sign"), p = c(1, 2, 4, 8), l = c(
	2, 4, 6, 8))
{
	np <- length(p)
	nl <- length(l)
	nscore <- length(scores)
	test <- array(0, c(nscore, nl, np))
	for(k in 1:np) {
		for(j in 1:nl) {
			for(i in 1:nscore) {
				test[i, j, k] <- uroot.test(log(x), p[k], l[j], 
				  score = scores[i])
			}
		}
	}
	return(test)
}
"NP.data"<-
list(nomgnp = c(33400, 35300, 35800, 39400, 39600, 38600, 40000, 48300, 60400, 
	76400, 84000, 91500, 69600, 74100, 85100, 84700, 93100, 97000, 94900, 
	97000, 103095, 90367, 75820, 58049, 55601, 65054, 72247, 82481, 90446, 
	84670, 90494, 99678, 124540, 157910, 191592, 210104, 211945, 208509, 
	231323, 257562, 256484, 284769, 328404, 345498, 364593, 364841, 397960, 
	419238, 441134, 447334, 483663, 503734, 520097, 560325, 590503, 632410, 
	684884, 749857, 793927, 864202, 929095, 974126), realgnp = c(116.8, 
	120.09999999999999, 123.2, 130.19999999999999, 131.40000000000001, 
	125.59999999999999, 124.5, 134.30000000000001, 135.19999999999999, 
	151.80000000000001, 146.40000000000001, 140, 127.8, 148, 
	165.90000000000001, 165.5, 179.40000000000001, 190, 189.80000000000001, 
	190.90000000000001, 203.59999999999999, 183.5, 169.30000000000001, 
	144.19999999999999, 141.5, 154.30000000000001, 169.5, 193, 
	203.19999999999999, 192.90000000000001, 209.40000000000001, 
	227.19999999999999, 263.69999999999999, 297.80000000000001, 
	337.10000000000002, 361.30000000000001, 355.19999999999999, 
	312.60000000000002, 309.89999999999998, 323.69999999999999, 
	324.10000000000002, 355.30000000000001, 383.39999999999998, 
	395.10000000000002, 412.80000000000001, 407, 438, 446.10000000000002, 
	452.5, 447.30000000000001, 475.89999999999998, 487.69999999999999, 
	497.19999999999999, 529.79999999999995, 551, 581.10000000000002, 
	617.79999999999995, 658.10000000000002, 675.20000000000005, 
	706.60000000000002, 724.70000000000005, 720), pcrgnp = c(1291, 1300, 
	1312, 1366, 1351, 1267, 1238, 1317, 1309, 1471, 1401, 1315, 1177, 1345, 
	1482, 1450, 1549, 1618, 1594, 1584, 1671, 1490, 1364, 1154, 1126, 1220, 
	1331, 1506, 1576, 1484, 1598, 1720, 1977, 2208, 2465, 2611, 2538, 2211, 
	2150, 2208, 2172, 2342, 2485, 2517, 2587, 2506, 2650, 2652, 2642, 2569, 
	2688, 2699, 2707, 2841, 2912, 3029, 3181, 3349, 3399, 3522, 3577, 3516),
	deflator = c(25.899999999999999, 25.399999999999999, 24.899999999999999,
	24, 24.5, 23, 22.699999999999999, 22.100000000000001, 
	22.199999999999999, 22.899999999999999, 23.600000000000001, 
	24.699999999999999, 24.5, 25.399999999999999, 25.699999999999999, 26, 
	26.5, 27.199999999999999, 28.300000000000001, 28.100000000000001, 
	29.100000000000001, 29.899999999999999, 29.699999999999999, 
	30.899999999999999, 31.100000000000001, 31.399999999999999, 32.5, 36.5, 
	45, 52.600000000000001, 53.799999999999997, 61.299999999999997, 
	52.200000000000003, 49.5, 50.700000000000003, 50.100000000000001, 51, 
	51.200000000000003, 50, 50.399999999999999, 50.600000000000001, 
	49.299999999999997, 44.799999999999997, 40.200000000000003, 
	39.299999999999997, 42.200000000000003, 42.600000000000001, 
	42.700000000000003, 44.5, 43.899999999999999, 43.200000000000003, 
	43.899999999999999, 47.200000000000003, 53, 56.799999999999997, 
	58.200000000000003, 59.700000000000003, 66.700000000000003, 
	74.599999999999994, 79.599999999999994, 79.099999999999994, 
	80.200000000000003, 85.599999999999994, 87.5, 88.299999999999997, 
	89.599999999999994, 90.900000000000006, 94, 97.5, 100, 
	101.59999999999999, 103.3, 104.59999999999999, 105.8, 107.2, 108.8, 
	110.90000000000001, 113.90000000000001, 117.59999999999999, 122.3, 
	128.19999999999999, 135.30000000000001), cpi = c(27, 27, 30, 37, 48, 47,
	44, 43, 41, 40, 38, 37, 37, 37, 35, 33, 32, 32, 30, 29, 30, 30, 30, 29, 
	28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 26, 25, 25, 25, 25, 25, 25, 25, 
	26, 27, 27, 27, 28, 29, 28, 28, 29, 29, 30, 29.699999999999999, 
	30.100000000000001, 30.399999999999999, 32.700000000000003, 
	38.399999999999999, 45.100000000000001, 51.799999999999997, 60, 
	53.600000000000001, 50.200000000000003, 51.100000000000001, 
	51.200000000000003, 52.5, 53, 52, 51.299999999999997, 
	51.299999999999997, 50, 45.600000000000001, 40.899999999999999, 
	38.799999999999997, 40.100000000000001, 41.100000000000001, 41.5, 43, 
	42.200000000000003, 41.600000000000001, 42, 44.100000000000001, 
	48.799999999999997, 51.799999999999997, 52.700000000000003, 
	53.899999999999999, 58.5, 66.900000000000006, 72.099999999999994, 
	71.400000000000006, 72.099999999999994, 77.799999999999997, 79.5, 
	80.099999999999994, 80.5, 80.200000000000003, 81.400000000000006, 
	84.299999999999997, 86.599999999999994, 87.299999999999997, 
	88.700000000000003, 89.599999999999994, 90.599999999999994, 
	91.700000000000003, 92.900000000000006, 94.5, 97.200000000000003, 100, 
	104.2, 109.8, 116.3), sp500 = c(4.6900000000000004, 5.0300000000000002, 
	4.7999999999999998, 4.5700000000000003, 4.4500000000000002, 
	4.0599999999999996, 3.1400000000000001, 3.3799999999999999, 
	4.1200000000000001, 5.21, 6.25, 5.9000000000000004, 5.6299999999999999, 
	4.7300000000000004, 4.5999999999999996, 5.3600000000000003, 
	5.5300000000000002, 5.2000000000000002, 5.3200000000000003, 
	5.2699999999999996, 5.0300000000000002, 5.5499999999999998, 
	4.7800000000000002, 4.3899999999999997, 4.5300000000000002, 
	4.2300000000000004, 4.4500000000000002, 5.0499999999999998, 6.29, 
	6.1500000000000004, 7.8399999999999999, 8.4199999999999999, 7.21, 
	7.0499999999999998, 8.9900000000000002, 9.6400000000000006, 
	7.8399999999999999, 7.7800000000000002, 9.7100000000000009, 
	9.3499999999999996, 9.2400000000000002, 9.5299999999999994, 
	8.5099999999999998, 8.0800000000000001, 8.3100000000000005, 
	9.4700000000000006, 8.5, 7.54, 8.7799999999999994, 7.9800000000000004, 
	6.8600000000000003, 8.4100000000000001, 8.5700000000000003, 
	9.0500000000000007, 11.15, 12.59, 15.34, 19.949999999999999, 26.02, 
	21.030000000000001, 13.66, 6.9299999999999997, 8.9600000000000009, 
	9.8399999999999999, 10.6, 15.470000000000001, 15.41, 11.49, 12.06, 
	11.02, 9.8200000000000003, 8.6699999999999999, 11.5, 12.470000000000001,
	15.16, 17.079999999999998, 15.17, 15.529999999999999, 15.23, 
	18.399999999999999, 22.34, 24.5, 24.73, 29.690000000000001, 
	40.490000000000002, 46.619999999999997, 44.380000000000003, 
	46.240000000000002, 57.380000000000003, 55.850000000000001, 
	66.269999999999996, 62.380000000000003, 69.870000000000005, 
	81.370000000000005, 88.170000000000002, 85.260000000000005, 
	91.930000000000007, 98.700000000000003, 97.840000000000003, 
	83.819999999999993), bondyield = c(3.2999999999999998, 3.25, 
	3.2999999999999998, 3.4500000000000002, 3.6000000000000001, 3.5, 
	3.5499999999999998, 3.7999999999999998, 3.9500000000000002, 3.77, 
	3.7999999999999998, 3.8999999999999999, 3.8999999999999999, 4, 
	4.0999999999999996, 4.1500000000000004, 4.0499999999999998, 
	4.0499999999999998, 4.75, 4.75, 5.0999999999999996, 5.1699999999999999, 
	4.71, 4.6100000000000003, 4.6600000000000001, 4.5, 4.4000000000000004, 
	4.2999999999999998, 4.0499999999999998, 4.4199999999999999, 
	4.4000000000000004, 4.0999999999999996, 4.7000000000000002, 
	4.1500000000000004, 3.9900000000000002, 3.5, 3.2000000000000002, 
	3.0800000000000001, 3, 2.75, 2.7000000000000002, 2.6499999999999999, 
	2.6499999999999999, 2.6499999999999999, 2.6000000000000001, 
	2.5499999999999998, 2.4300000000000002, 2.5, 2.7999999999999998, 
	2.7400000000000002, 2.5800000000000001, 2.6699999999999999, 3, 
	3.1499999999999999, 3, 3.04, 3.0899999999999999, 3.6800000000000002, 
	3.6099999999999999, 4.0999999999999996, 4.5499999999999998, 
	4.2199999999999998, 4.4199999999999999, 4.1600000000000001, 
	4.3300000000000001, 4.3499999999999996, 4.75, 4.9500000000000002, 
	5.9299999999999997, 6.54, 7.5999999999999996), industrial = c(
	0.90000000000000002, 0.90000000000000002, 0.90000000000000002, 1, 1, 1, 
	1.2, 1.3, 1.3, 1.3999999999999999, 1.5, 1.5, 1.8, 1.8, 1.7, 1.7, 1.7, 
	1.8, 1.8999999999999999, 2.2000000000000002, 2.5, 2.7999999999999998, 3,
	3, 2.8999999999999999, 2.8999999999999999, 3.5, 3.7000000000000002, 
	3.7999999999999998, 4.0999999999999996, 4.4000000000000004, 4.5, 
	4.7999999999999998, 4.2999999999999998, 4.2000000000000002, 
	4.9000000000000004, 4.5999999999999996, 4.9000000000000004, 
	5.5999999999999996, 6.0999999999999996, 6.2999999999999998, 
	7.0999999999999996, 7.9000000000000004, 8.0999999999999996, 
	7.7999999999999998, 9.1999999999999993, 9.8000000000000007, 10, 8.5, 10,
	10.6, 10.199999999999999, 11.699999999999999, 12.5, 11.699999999999999, 
	13.6, 16.100000000000001, 16.199999999999999, 16, 14.1, 
	14.800000000000001, 11.4, 14.5, 17.300000000000001, 16.199999999999999, 
	17.800000000000001, 18.899999999999999, 18.899999999999999, 
	19.600000000000001, 21.800000000000001, 18.100000000000001, 15, 
	11.699999999999999, 13.800000000000001, 15.1, 17.399999999999999, 
	20.600000000000001, 22.5, 17.800000000000001, 21.800000000000001, 25.5, 
	31.800000000000001, 36.600000000000001, 44.700000000000003, 
	48.299999999999997, 41.299999999999997, 35.200000000000003, 
	39.399999999999999, 41, 38.799999999999997, 44.899999999999999, 
	48.700000000000003, 50.600000000000001, 54.799999999999997, 
	51.799999999999997, 58.399999999999999, 61, 61.799999999999997, 
	57.799999999999997, 64.700000000000003, 66.200000000000003, 
	66.599999999999994, 72.099999999999994, 76.5, 81.799999999999997, 
	89.200000000000003, 98, 100, 105.8, 110.7, 106.7), employment = c(22577,
	22792, 23932, 22321, 21102, 22824, 23129, 23604, 24746, 26911, 27909, 
	28922, 29800, 30506, 30771, 31976, 33749, 34371, 33246, 35072, 35762, 
	36179, 37433, 38298, 37559, 37511, 39364, 40084, 42712, 41938, 40799, 
	38568, 41134, 43955, 43607, 45082, 46464, 46496, 46774, 47890, 45740, 
	42660, 39190, 39010, 41150, 42530, 44710, 46620, 44560, 46120, 48060, 
	51970, 57720, 63490, 65370, 64260, 58700, 58630, 59803, 59266, 60570, 
	63062, 63846, 64726, 63460, 65220, 66659, 66871, 65672, 67182, 68292, 
	68318, 69530, 70500, 72044, 73811, 76018, 77818, 79455, 81408, 81815), 
	unemplymnt = c(4, 5.4000000000000004, 3, 11.699999999999999, 
	18.399999999999999, 13.699999999999999, 14.4, 14.5, 12.4, 6.5, 5, 4, 
	3.7000000000000002, 3.8999999999999999, 5.4000000000000004, 
	4.2999999999999998, 1.7, 2.7999999999999998, 8, 5.0999999999999996, 
	5.9000000000000004, 6.7000000000000002, 4.5999999999999996, 
	4.2999999999999998, 7.9000000000000004, 8.5, 5.0999999999999996, 
	4.5999999999999996, 1.3999999999999999, 1.3999999999999999, 
	5.2000000000000002, 11.699999999999999, 6.7000000000000002, 
	2.3999999999999999, 5, 3.2000000000000002, 1.8, 3.2999999999999998, 
	4.2000000000000002, 3.2000000000000002, 8.6999999999999993, 15.9, 
	23.600000000000001, 24.899999999999999, 21.699999999999999, 
	20.100000000000001, 16.899999999999999, 14.300000000000001, 19, 
	17.199999999999999, 14.6, 9.9000000000000004, 4.7000000000000002, 
	1.8999999999999999, 1.2, 1.8999999999999999, 3.8999999999999999, 
	3.8999999999999999, 3.7999999999999998, 5.9000000000000004, 
	5.2999999999999998, 3.2999999999999998, 3, 2.8999999999999999, 5.5, 
	4.4000000000000004, 4.0999999999999996, 4.2999999999999998, 
	6.7999999999999998, 5.5, 5.5, 6.7000000000000002, 5.5, 
	5.7000000000000002, 5.2000000000000002, 4.5, 3.7999999999999998, 
	3.7999999999999998, 3.6000000000000001, 3.5, 4.9000000000000004), wages
	 = c(487, 511, 537, 548, 538, 561, 577, 598, 548, 599, 651, 632, 651, 
	689, 696, 661, 751, 883, 1107, 1293, 1532, 1396, 1283, 1403, 1427, 1450,
	1476, 1502, 1534, 1543, 1488, 1369, 1150, 1086, 1153, 1216, 1287, 1376, 
	1296, 1363, 1432, 1653, 2023, 2349, 2517, 2517, 2517, 2793, 3038, 3095, 
	3302, 3608, 3832, 4053, 4123, 4356, 4589, 4786, 4946, 5221, 5352, 5507, 
	5730, 5920, 6196, 6389, 6643, 6880, 7347, 7775, 8150), realwage = c(
	19.48, 20.440000000000001, 20.649999999999999, 20.300000000000001, 
	19.93, 20.780000000000001, 20.609999999999999, 20.620000000000001, 
	19.57, 21.390000000000001, 22.449999999999999, 21.789999999999999, 
	21.699999999999999, 23.199999999999999, 23.120000000000001, 
	21.739999999999998, 22.969999999999999, 22.989999999999998, 
	24.550000000000001, 24.960000000000001, 25.530000000000001, 
	26.039999999999999, 25.559999999999999, 27.460000000000001, 
	27.870000000000001, 27.620000000000001, 27.850000000000001, 
	28.879999999999999, 29.899999999999999, 30.079999999999998, 
	29.760000000000002, 30.02, 28.120000000000001, 27.989999999999998, 
	28.75, 29.59, 31.010000000000002, 32, 30.710000000000001, 
	32.759999999999998, 34.100000000000001, 37.479999999999997, 
	41.450000000000003, 45.350000000000001, 47.759999999999998, 
	46.700000000000003, 43.030000000000001, 41.75, 42.140000000000001, 
	43.350000000000001, 45.799999999999997, 46.380000000000003, 
	48.200000000000003, 50.600000000000001, 51.219999999999999, 
	54.310000000000002, 56.380000000000003, 56.770000000000003, 
	57.109999999999999, 59.810000000000002, 60.340000000000003, 
	61.460000000000001, 63.25, 64.560000000000002, 66.700000000000003, 
	67.609999999999999, 68.340000000000003, 68.799999999999997, 
	70.510000000000005, 70.810000000000002, 70.079999999999998), moneystock
	 = c(3.6000000000000001, 3.9199999999999999, 4.0800000000000001, 
	4.4299999999999997, 4.2599999999999998, 4.2800000000000002, 
	4.4299999999999997, 4.3499999999999996, 4.6399999999999997, 
	5.2599999999999998, 6.0899999999999999, 6.5999999999999996, 
	7.4800000000000004, 8.1699999999999999, 8.6799999999999997, 
	9.2400000000000002, 10.24, 11.08, 11.6, 11.44, 12.68, 13.34, 
	14.119999999999999, 15.130000000000001, 15.73, 16.390000000000001, 
	17.59, 20.850000000000001, 24.370000000000001, 26.73, 
	31.010000000000002, 34.799999999999997, 32.850000000000001, 
	33.719999999999999, 36.600000000000001, 38.579999999999998, 
	42.049999999999997, 43.68, 44.729999999999997, 46.420000000000002, 
	46.600000000000001, 45.729999999999997, 42.689999999999998, 
	36.049999999999997, 32.219999999999999, 34.359999999999999, 39.07, 
	43.479999999999997, 45.68, 45.509999999999998, 49.270000000000003, 
	55.200000000000003, 62.509999999999998, 71.159999999999997, 
	89.909999999999997, 106.8, 126.59999999999999, 138.69999999999999, 146, 
	148.09999999999999, 147.5, 150.80000000000001, 156.40000000000001, 
	164.90000000000001, 171.19999999999999, 177.19999999999999, 
	183.69999999999999, 186.90000000000001, 191.80000000000001, 
	201.09999999999999, 210.09999999999999, 210.69999999999999, 
	221.19999999999999, 233.90000000000001, 249.09999999999999, 
	264.69999999999999, 285.89999999999998, 308, 331.80000000000001, 
	361.60000000000002, 385.19999999999999, 401.30000000000001), velocity
	 = c(5.6100000000000003, 5.1600000000000001, 4.6299999999999999, 
	5.0499999999999998, 4.9500000000000002, 4.71, 4.46, 4.6500000000000004, 
	4.8899999999999997, 5.0599999999999996, 5.0999999999999996, 
	5.3099999999999996, 4.4100000000000001, 4.4100000000000001, 
	4.0099999999999998, 3.8900000000000001, 3.5299999999999998, 
	3.3799999999999999, 3.29, 3.1499999999999999, 3.0800000000000001, 3, 
	2.96, 2.8599999999999999, 2.9300000000000002, 2.5699999999999998, 2.73, 
	2.6299999999999999, 2.7200000000000002, 2.5099999999999998, 
	2.4900000000000002, 2.4900000000000002, 2.4399999999999999, 
	2.3100000000000001, 2.29, 2.1400000000000001, 2.1299999999999999, 
	2.2799999999999998, 2.2799999999999998, 2.0600000000000001, 
	2.1899999999999999, 2.1699999999999999, 2.0699999999999998, 
	2.1200000000000001, 2.1499999999999999, 1.8799999999999999, 
	1.8700000000000001, 2.0899999999999999, 2.1499999999999999, 
	2.4700000000000002, 2.25, 2.1800000000000002, 1.8799999999999999, 
	1.8700000000000001, 2.02, 1.95, 1.8700000000000001, 1.9399999999999999, 
	1.8600000000000001, 1.8300000000000001, 1.9399999999999999, 
	1.6799999999999999, 1.45, 1.24, 1.3200000000000001, 1.47, 1.49, 
	1.5700000000000001, 1.6399999999999999, 1.51, 1.5, 1.48, 
	1.5800000000000001, 1.8200000000000001, 1.75, 1.6100000000000001, 
	1.3700000000000001, 1.1599999999999999, 1.2, 1.3300000000000001, 1.3, 
	1.4099999999999999, 1.5700000000000001, 1.5600000000000001, 
	1.5700000000000001, 1.51, 1.5900000000000001, 1.6599999999999999, 
	1.6799999999999999, 1.6100000000000001, 1.6799999999999999, 1.72, 
	1.6899999999999999, 1.71, 1.6899999999999999, 1.71, 1.72, 1.76, 1.72, 
	1.72, 1.73, 1.73))
"NP.names"<-
c("Nominal GNP", "Real GNP", "Per Capita Real GNP", "GNP deflator", 
	"Consumer Price Index", "Common Stock Prices", "Bond Yield", 
	"Industrial Production", "Employment", "Unemployment Rate", "Wages", 
	"Real Wages", "Money Stock", "Velocity")
"Rank"<-
function(x, na.last = TRUE)
{
	ranks <- sort.list(sort.list(x, na.last = na.last))
	if(is.na(na.last))
		x <- x[is.orderable(x)]
	for(i in unique(x[duplicated(x)])) {
		which <- x == i & !is.na(x)
		ranks[which] <- max(ranks[which])
	}
	ranks
}
"determinant"<-
function(a)
{
#see Spector(1995) p.54
	prod(diag(qr(a)$qr)) * ifelse(nrow(a) %% 2, 1, -1)
}
"make.adf.model"<-
function(x, L = 0, trend = FALSE)
{
#Construct Data for Augmented Dickey Fuller Model with L lags.
	x <- as.ts(x)
	D <- diff(x)
	if(L > 0) {
		for(i in 1:L)
			D <- ts.intersect(D, lag(diff(x),  - i))
	}
	D <- ts.intersect(lag(x, -1), D)
	if(trend == TRUE)
		D <- ts.intersect(D, time(x))
	D <- cbind(D)	#what does this do?
	dy <- D[, 2]
	z <- D[, 1]
	x0 <- D[,  - c(1, 2)]	
	list(dy = dy , z = z, x0 = x0)
}
"uroot.nuisance"<-
function(x, y, l, res = 0, trend = TRUE, score = "wilcoxon")
{
# x is the adf X matrix under H_o, without intercept term.  
# first p terms are \delta y_t and (p+1)th term is trend if trend==TRUE
# y is the first difference of the univariate time series
# 
# b is the coefficient vector of l_1 fit of the unit root model under H_0 
# r is the residual vector associated with the l_1 fit.  
# p is the number of autoregression terms in the difference
# l is the lag truncation parameter for estimating variance-covariance matrix
# w are the weights for the Newey-West estimator
# res controls the treatment of zero residuals in computing Fhat
#
#Computation of Uhat
	if(is.matrix(x)) n <- nrow(x)
        else n <- length(x)
	fit <- rq(y ~ x)
	r <- fit$residuals
	b <- fit$coefficients
	ut <- rep(0, n)
	if(trend == TRUE) {
		p <- ncol(x) - 1
		xb <- b[p + 2] * x[, (p + 1)]
		ut <- filter(r + xb, b[2:(p + 1)], "rec")
	}
	else ut <- y - r
	w2 <- c(1/2, 1 - (1:l)/(1 + l))
	z <- ut
	z <- ts(c(rep(0, l), z))
	U <- z
	for(i in 1:l)
		U <- ts.intersect(U, lag(z,  - i))
	sgmu2 <- sum(ut^2)/n
	Sigma <- matrix(0, 2, 2)
	Sigma[1, 1] <- (2 * crossprod(crossprod(U)[1,  ], w2))/n	
	#Computation of empirical distribution function
	if(res == 0)
		Fhat <- (Rank(r) - 0.5)/n
	else Fhat <- (rank(r) - 0.5)/n
	if(score == "wilcoxon")
		vt <- Fhat - 0.5
	else if(score == "normal")
		vt <- qnorm(Fhat)
	else if(score == "sign") {
		eps <- .Machine$double.eps
		vt <- 0.5 * sign(Fhat - 0.5) * (abs(Fhat - 0.5) > eps)
	}
	else stop("Invalid Score Function")
	z <- vt	#Computation of nuisance parameter estimates
	z <- ts(c(rep(0, l), z))
	V <- z
	for(i in 1:l)
		V <- ts.intersect(V, lag(z,  - i))
	w1 <- c(1, 1 - (1:l)/(1 + l))
	w <- 1 - (1:l)/(1 + l)
	suv <- crossprod(crossprod(U, V)[1,  ], w1)/n
	svu <- crossprod(crossprod(V, U)[1, -1], w)/n
	Sigma[1, 2] <- suv + svu
	Sigma[2, 1] <- suv + svu
	Sigma[2, 2] <- (2 * crossprod(crossprod(V)[1,  ], w2))/n
	list(Sigma = Sigma, sgmu2 = sgmu2)
}
"uroot.test"<-
function(y, p, l, trend = TRUE, res = 0, score = "wilcoxon")
{
#Compute Hasan-Koenker Regression Rankscore Test of the Unit Root Hypothesis
#y is a univariate timeseries
#p is the lag length of the Augmented Dickey-Fuller Model
#l is the lag truncation length for the Newey-West Estimates
#if trend=TRUE then a trend term is included in the ADF model
#score should be one of the following:
#	"wilcoxon" for the logistic model
#	"normal" for the Gaussian model
#	"sign" for the Laplace model
#res controls the treatment of zero residuals in the estimation of Sigma
#
	M <- make.adf.model(y, p, trend = trend)
	dy <- M$dy
	z <- M$z
	x0 <- M$x0
	R <- GJKP.ranks(rq(dy ~ x0, tau = -1), score)
	x1hat <- as.matrix(qr.resid(qr(cbind(1, x0)), z))
	S <- (t(x1hat) %*% R)/sqrt(crossprod(x1hat))
	sgmzz <- (crossprod(x1hat))/((length(dy)^2))
	adf.coef <- lm(dy ~ cbind(z, x0))$coef[2]
	w <- uroot.nuisance(x0, dy, l, res, trend, score)
	D <- determinant(w$Sigma)
	w1 <- sqrt(w$Sigma[1, 1]/D)
	w2 <- (w$Sigma[1, 2] * sqrt(sgmzz))/(sqrt(D * w$Sigma[1, 1]))
	w3 <- (w$Sigma[1, 1] - w$sgmu2)/(2 * sgmzz)
	rtest <- c(w1 * S - w2 * (length(dy) * adf.coef - w3))
	return(rtest)
}
