\name{rqpd}
\alias{rqpd}
\title{Quantile Regression for Longitudinal (Panel) Data}
\description{This function implements the penalized fixed effect estimation method
proposed in Koenker (2004).  The estimator is based on minimizing a weighted sum of K 
ordinary quantile regression objective functions corresponding to a selection of
K values of tau, with user specified tau-specific weights.  Slope coefficients of
this objective function are tau dependent, whereas coefficients corresponding
to the fixed effects are assumed to be independent of tau.  The vector of fixed
effect coefficients are penalized by an l1 (lasso) penalty term with associated
penalty parameter lambda, thereby shrinking these coefficients toward zero. 
}
\usage{
rqpd(formula, taus = 1:3/4, data = parent.frame(), tauw = c(0.25, 0.5, 0.25), na.action, lambda = 1, contrasts = NULL, ztol = 1e-05, control = NULL, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{formula}{
A formula for the model employing the conventions of the \pkg{Formula} package.
The portion of the formula before the vertical bar is specified like the conventional
\code{\link{lm}} or \code{\link{rq}} functions.  The portion of the formula after the 
vertical bar specifies the structure of the fixed effects.  The latter component would 
typically be a single factor variable indicating the identities of the sample 
"individuals." More complex crossed factor structure for the fixed effects is possible 
for estimation, but not (yet) for inference.  }
  \item{taus}{
A K-vector of tau's lying in (0,1).  The coefficients of the covariate effects before
the bar are allowed to vary with these tau's, whereas the fixed effect coefficients
on the model specification after the bar are assumed to be independent of tau.
}
  \item{data}{
A data.frame containing the variables as specified in the formula.
}

  \item{tauw}{
A K-vector of positive weights, summing to one, specifying the relative weight to
be given to the K distinct components of the objective function.  
}
  \item{na.action}{
A function to filter missing data.  This is applied to the
          model.frame after any subset argument has been used.  The
          default (with 'na.fail') is to create an error if any missing
          values are found.  A possible alternative is 'na.omit', which
          deletes observations that contain one or more missing values.
}
  \item{lambda}{
A parameter controlling the shrinkage of the fixed effects toward zero.
}
  \item{contrasts}{
A list giving contrasts for some or all of the factors
          default = 'NULL' appearing in the model formula.  The
          elements of the list should have the same name as the
          variable and should be either a contrast matrix
          (specifically, any full-rank matrix with as many rows as
          there are levels in the factor), or else a function to
          compute such a matrix given the number of levels.
}
  \item{ztol}{
A parameter controlling the tolerance determining how close estimated
coefficients need to be to zero to be considered zero.
}
  \item{control}{ Control argument for the fitting routines (see 'sfn.control') } 
  \item{\dots}{ Other arguments passed to fitting routines.  }
}
\details{ See Koenker (2004) for further details.  A bare bones version of this
code is available from \url{http://www.econ.uiuc.edu/~roger/research/panel/long.html}.
}

\value{
The function returns a fitted object representing the estimated
     model specified in the formula.  See 'rqss.object' for further
     details on this object, and references to methods to look at it.
}
\references{
[1.]  Koenker, R.  (2004) Quantile Regression for Longitudinal Data, 
	J. Mult. Anal., 91, 74-89.
}
\author{
Roger Koenker
}

\seealso{
\code{\link{summary.rqpd}}, \code{\link{rqpd.object}}.
}
\examples{
set.seed(10)
m <- 3
n <- 10
s <- as.factor(rep(1:n,rep(m,n)))
x <- exp(rnorm(n*m))
u <- x*rnorm(m*n) + (1-x)*rf(m*n,3,3)
a <- rep(rnorm(n),rep(m,n))
y <- a + u
fit <- rqpd(y ~ x | s,lambda = 5)
sfit <- summary(fit,bsmethod = "xy")
}
\keyword{regression}
\keyword{robust}
