\name{summary.rqpd}
\alias{summary.rqpd}
\alias{print.summary.rqpd}
\title{
Summary Method for Quantile Regression for Panel Data
}
\description{
Inferential summary based on models fitted by \code{\link{rqpd}}.
}
\usage{
\method{summary}{rqpd}(object, se = "boot", covariance = FALSE, ...)
\method{print}{summary.rqpd}(x, ...)
}
\arguments{
  \item{object}{
Fitted object from \code{\link{rqpd}}.
}
  \item{se}{
Option specifying method for estimating standard errors;  only the bootstrap
option is currently available.
}
  \item{covariance}{
Logical flag indicated whether a covariance matrix for the estimated parameters
is desired.
}
  \item{\dots}{
Other optional arguments, more specifically, arguments passed to 
\code{\link{boot.rqpd}} to control bootstrap methods.
}
}
\details{
Note that as with other penalty methods like \code{\link{rqss}} inferential
methods are conditional on selection of the penalty parameter lambda.  Thus,
coefficients that are shrunken to zero may have indeterminate and therefore
unmeaningful t-ratios and p-values.  For the moment, inference is based on
boostrapping either using multinomial weighting, \code{method == "xy"}
or using exponential(1) weighting, \code{method = "wxy"}.  
}
\value{
Returns an object of class \code{\link{summary.rqpd}} that contains a matrix
of coefficients, standard errors, t-statistics, and p-values, and a variety
of other components.  Optionally, a covariance matrix for the estimated 
parameters can be returned as part of the object.
}
\author{
Roger Koenker
}
\seealso{
\code{\link{boot.rqpd}}
\code{\link{rqpd}}
}
\keyword{regression}
\keyword{robust}
