"summary.rqss" <- function(object, ..., ztol = 1e-5){
{
    resid <- object$resid
    nrA <- object$nrA
    tau <- object$tau
    n <- length(resid) - nrA[length(nrA)]
    Rho <- function(u, tau) sum(u * (tau - (u < 0)))
    fidelity <- Rho(resid[1:n], tau)
    edf <- sum(abs(resid[1:n]) < ztol)
    if(length(nrA) > 1) {
        penalty <- rep(NA, length(nrA) - 1)
        qssedfs <- rep(NA, length(nrA) - 1)
        for(i in 2:length(nrA)) {
           penalty[i - 1] <- sum(abs(resid[n + ((nrA[i - 1] + 1):nrA[i])]))
           qssedfs[i - 1] <- sum(abs(resid[n + ((nrA[i - 1] + 1):nrA[i])]) > ztol)
           }
        penalty <- penalty/object$lambdas
        z <- list(fidelity = fidelity, penalty = penalty, edf = edf, 
            qssedfs = qssedfs, lambdas = object$lambdas)
        }
    else
        z <- list(fidelity = fidelity, edf = edf) 
    class(z) <- "summary.rqss"
    return(z)
}
