"rqss" <- function (formula, tau = 0.5, data = parent.frame(), weights, 
    na.action, method = "sfn", lambda = NULL, contrasts = NULL, ...) 
{
    call <- match.call()
    m <- match.call(expand = FALSE)
    temp <- c("", "formula", "data", "weights", "na.action")
    m <- m[match(temp, names(m), nomatch = 0)]
    m[[1]] <- as.name("model.frame")
    special <- "qss"
    Terms <- if (missing(data)) 
        terms(formula, special)
    else terms(formula, special, data = data)
    qssterms <- attr(Terms, "specials")$qss
    dropx <- NULL
    if (length(qssterms)) {
        tmpc <- untangle.specials(Terms, "qss")
        ord <- attr(Terms, "order")[tmpc$terms]
        if (any(ord > 1)) 
            stop("qss can not be used in an interaction")
        dropx <- tmpc$terms
        if (length(dropx)) 
            Terms <- Terms[-dropx]
        attr(Terms, "specials") <- tmpc$vars
        qssnames <- unlist(lapply(parse(text = tmpc$vars), function(x) deparse(x[[2]])))
    }
    m$formula <- Terms
    m <- eval(m, parent.frame())
    weights <- model.extract(m, weights)
    process <- (tau < 0 || tau > 1)
    Y <- model.extract(m, "response")
    X <- model.matrix(Terms, m, contrasts)
    vnames <- dimnames(X)[[2]]
    p <- ncol(X)
    pf <- environment(formula)
    if(method == "lasso"){
	    if(!length(lambda))
		stop("No lambda specified for lasso constraint")
	    if(length(lambda) == 1)
		lambda <- c(0,rep(lambda,p-1))
	    if(length(lambda) != p)
		stop("lambda must be either of length p, or length 1")
	    if(any(lambda < 0))
		stop("negative lambdas disallowed")
	    L <- diag(lambda,nrow = length(lambda))
	    L <- L[which(lambda != 0), , drop = FALSE]
            L <- as.matrix.csr(L)
	}
# Now make the rest of the fidelity matrix, sparsify and append.
    if (length(qssterms) > 0) {
        F <- as.matrix.csr(X)
        qss <- lapply(tmpc$vars, function(u) eval(parse(text = u), 
            data, enclos = pf))
        mqss <- length(qss)
        ncA <- rep(0, mqss + 1)
        nrA <- rep(0, mqss + 1)
        nrR <- rep(0, mqss + 1)
        for (i in 1:mqss) {
            F <- cbind(F, qss[[i]]$F)
            ncA[i + 1] <- ncol(qss[[i]]$A)
            nrA[i + 1] <- nrow(qss[[i]]$A)
            nrR[i + 1] <- ifelse(is.null(nrow(qss[[i]]$R)), 0, 
                nrow(qss[[i]]$R))
            vnames <- c(vnames,paste(qssnames[i],1:ncA[i+1],sep=""))
        }
        A <- as.matrix.csr(0, sum(nrA), sum(ncA))
        if (sum(nrR) > 0) {
            R <- as.matrix.csr(0, sum(nrR), sum(ncA))
            nrR <- cumsum(nrR)
        }
        ncA <- cumsum(ncA)
        nrA <- cumsum(nrA)
        lambdas <- rep(0, mqss)
        for (i in 1:mqss) {
            lambdas[i] <- qss[[i]]$lambda
            Arows <- (1 + nrA[i]):nrA[i + 1]
            Acols <- (1 + ncA[i]):ncA[i + 1]
            A[Arows, Acols] <- qss[[i]]$lambda * qss[[i]]$A
            if (nrR[i] < nrR[i + 1]) 
                R[(1 + nrR[i]):nrR[i + 1], (1 + ncA[i]):ncA[i + 
                  1]] <- qss[[i]]$R
        }
        A <- cbind(as.matrix.csr(0, nrA[mqss + 1], p), A)
        if (nrR[mqss + 1] > 0) {
            R <- cbind(as.matrix.csr(0, nrR[mqss + 1], p), R)
            r <- rep(0, nrR[mqss + 1])
        }
        else {
            R <- NULL
            r <- NULL
        }
        if(method == "lasso"){
	    A <- rbind(cbind(L,as.matrix.csr(0,nrow(L), ncol(F)-ncol(L))),A)
	    }
        X <- rbind(F, A)
        Y <- c(Y, rep(0, nrow(A)))
        rhs <- t(rbind((1 - tau) * F, 0.5 * A)) %*% rep(1, nrow(X))
        XpX <- t(X) %*% X
        nnzdmax <- XpX@ia[length(XpX@ia)] - 1
        nsubmax <- max(nnzdmax, floor(1000 + exp(-1.6) * nnzdmax^1.2))
        nnzlmax <- floor(2e+05 - 2.8 * nnzdmax + 7e-04 * nnzdmax^2)
        tmpmax <- floor(1e+05 + exp(-12.1) * nnzdmax^2.35)
        fit <- if (length(r) > 0) 
            rqss.fit(X, Y, tau = tau, rhs = rhs, method = "sfnc", 
                R = R, r = r, nsubmax = nsubmax, nnzlmax = nnzlmax, 
                tmpmax = tmpmax)
        else rqss.fit(X, Y, tau = tau, rhs = rhs, method = "sfn", 
            nsubmax = nsubmax, nnzlmax = nnzlmax, tmpmax = tmpmax)
        for (i in 1:mqss) {
            ML <- p + 1 + ncA[i]
            MU <- p + ncA[i + 1]
            qss[[i]] <- list(xyz = cbind(qss[[i]]$x$x, qss[[i]]$x$y, 
                c(0, fit$coef[ML:MU])), dummies = qss[[i]]$dummies)
        }
        names(qss) <- qssnames
        fit$qss <- qss
    }
    else {
        vnames <- dimnames(X)[[2]]
        X <- as.matrix.csr(X)
        nrA <- 0
        if (method == "lasso") {
            X <- rbind(X, L)
            Y <- c(Y,rep(0,nrow(L)))
            nrA <- c(nrA, nrow(L))
            }
        if (length(weights)) {
            if (any(weights < 0)) 
                stop("negative weights not allowed")
            X <- X * weights
            Y <- Y * weights
            }
        fit <- rqss.fit(X, Y, tau = tau, ...)
        fit$nrA <- nrA
    }
    names(fit$coef) <- vnames
    fit$terms <- Terms
    fit$formula <- formula
    fit$call <- call
    fit$tau <- tau
    if (length(qssterms)) {
        fit$lambdas <- lambdas
        fit$nrA <- nrA
        }
    attr(fit, "na.message") <- attr(m, "na.message")
    class(fit) <- "rqss"
    fit
}
"summary.rqss" <- function(object, ..., ztol = 1e-5){
{
    resid <- object$resid
    nrA <- object$nrA
    tau <- object$tau
    n <- length(resid) - nrA[length(nrA)]
    Rho <- function(u, tau) sum(u * (tau - (u < 0)))
    fidelity <- Rho(resid[1:n], tau)
    edf <- sum(abs(resid[1:n]) < ztol)
    if(length(nrA) > 1) {
        penalty <- rep(NA, length(nrA) - 1)
        qssedfs <- rep(NA, length(nrA) - 1)
        for(i in 2:length(nrA)) {
           penalty[i - 1] <- sum(abs(resid[n + ((nrA[i - 1] + 1):nrA[i])]))
           qssedfs[i - 1] <- sum(abs(resid[n + ((nrA[i - 1] + 1):nrA[i])]) > ztol)
           }
        penalty <- penalty/object$lambdas
        z <- list(fidelity = fidelity, penalty = penalty, edf = edf, 
            qssedfs = qssedfs, lambdas = object$lambdas)
        }
    else
        z <- list(fidelity = fidelity, edf = edf) 
    class(z) <- "summary.rqss"
    return(z)
}
"logLik.rqss" <- function(object, ...){
	n <- length(object$resid) - object$nrA[length(object$nrA)]
	tau <- object$tau
	z <- summary(object)
	val <- n * (log(tau * (1-tau)) - 1 - log(z$fidelity/n))
	attr(val,"n") <- n
	attr(val,"df") <- z$edf
	class(val) <- "logLik"
	val
	}
"AIC.rqss" <- function(object, ... , k = 2){
	v <- logLik(object)
	if(k < 0) 
		k <- log(attr(v,"n"))
	val <- AIC(logLik(object), k = k)
	attr(val,"edf") <- attr(v,"df")
	val
	}
