/*-*- mode: C; kept-old-versions: 12;  kept-new-versions: 20; -*-
 *
 * cholesky.f -- translated by f2c (version 20031025) and by
 * $Id: f2c-clean,v 1.10 2002/03/28 16:37:27 maechler Exp $
 * plus extended manual code cleaning by Martin Maechler, ETH Zurich
 */

#include <math.h>
#ifndef min
# define	min(a, b)		((a) > (b) ? (b) : (a))
#endif

/* **********************************************************************
********************** DECLARATIONS *************************************
*************************************************************************/

/* The exported API is here : */
#include "cholesky.h"

/* TODO(MM): should call symfc2() from "above" and drop symfct() completely */
/* TODO(MM): should call blkfc2() from "above" and drop blkfct() completely */

/* Those static routines which are only used in *one* other routine,
 * are declared 'extern' in their callers ---
 * unless they are defined after being used: */

/* --- --- --- bfinit() --- --- --- */
static int fnsplt_(int *neqns, int *nsuper, int *xsuper,
		   int *xlindx, int *cachsz, int *split);
static int fntsiz_(int *, int *, int *, int *, int *, int *);

/* --- --- --- blkfc2() --- --- --- */
/* assmb_() , */
static int mmpy_(int *, int *, int *, int *, int *, double *, double *,
		 int *, U_fp);
static int ldindx_(int *, int *, int *);
static int mmpyi_(int *, int *, int *, double *, int *, double *, int *);
static int igathr_(int *, int *, int *, int *);
static void chlsup(int m, int n, int *split, int *xpnt, double *x,
		   double mxdiag, int *ntiny, int *iflag,
		   S_fp mmpyn, U_fp smxpy);
/* --- chlsup() --- */
static void pchol(int m, int n, int *xpnt, double *x,
		  double mxdiag, int *ntiny, int *iflag, S_fp smxpy);
/* - pchol() - */
static void dscal1_(int n, double a, double *x);


/* --- --- --- sfinit() --- --- --- */
/* chordr_(), */
/* etordr_(), */
/* fcnthn_(), */
/* fsup1_(), */
/* fsup2_(), */
/* --- etordr() --- */
static int betree_(int *, int *, int *, int *);
static int etpost_(int *, int *, int *, int *, int *, int *);
static int etree_(int *, int *, int *, int *, int *, int *, int *);
/* invinv_(), */
/* --- chordr() --- */
/* btree2_(), */
static int epost2_(int *, int *, int *, int *, int *, int *, int *);
/* invinv_(), */


/* --- --- --- ordmmd() --- --- --- */
/* genmmd(), */
/* --- genmmd() --- */
static int mmdelm_(int *, int *, int *, int *, int *, int *, int *,
		   int *, int *, int *, int *);
static int mmdupd_(int *, int *, int *, int *, int *, int *, int *,
		   int *, int *, int *, int *, int *, int *, int *);
static int mmdint_(int *, int *, int *, int *, int *, int *, int *,
		   int *, int *);
static int mmdnum_(int *, int *, int *, int *);


/* -------------------------------------------------------------------
 * These are called from more than one routine : */

/* from chordr_() and etordr_() : */
static int invinv_(int *, int *, int *, int *);


/************************************************************************
 ************************************************************************/


static int
assmb_(int *m, int *q, double *y, int *relind,
       int *xlnz, double *lnz, int *lda)
{
/* Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ************	  assmb .... indexed ASSeMBly operation	    ************
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       This routine performs an indexed assembly (i.e., scatter-add)
       operation, assuming data structures used in some of our sparse
       cholesky codes.

   INPUT parameters:
       m	       -   number of rows in y.
       q	       -   number of columns in y.
       y	       -   block update to be incorporated into factor
			   storage.
       relind	       -   relative indices for mapping the updates
			   onto the target columns.
       xlnz	       -   pointers to the start of each column in the
			   target matrix.

   OUTPUT parameters:
       lnz	       -   contains columns modified by the update
			   matrix.

 ***********************************************************************
*/
    int ir, icol, iy = 0 /* -Wall */, ycol, lbot, yoff;

    /* Parameter adjustments */
    --lnz;
    --relind;
    --y;

    /* Function Body */
    yoff = 0;
    for (icol = 1; icol <= *q; ++icol) {
	ycol = *lda - relind[icol];
	lbot = xlnz[ycol] - 1;
/* DIR$ IVDEP */
	for (ir = icol; ir <= *m; ++ir) {
	    int il = lbot - relind[ir];
	    iy = yoff + ir;
	    lnz[il] += y[iy];
	    y[iy] = 0.;
	}
	yoff = iy - icol;
    }

    return 0;
} /* assmb_

 ***********************************************************************
 ***********************************************************************/

static int
betree_(int *neqns, int *parent, int *fson, int *brothr)
{
/* Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Joseph W.H. Liu

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ******	    BETREE ..... Binary TREE representation of ETREE	 *******
 ***********************************************************************
 ***********************************************************************

   Written by Joseph Liu (jul 17, 1985)

   PURPOSE:
       To determine the binary tree representation of the elimination
       tree given by the parent vector.	 The returned representation
       will be given by the first-son and brother vectors.  The root
       of the binary tree is always neqns.

   INPUT parameters:
       neqns	       -   number of equations.
       parent	       -   the parent vector of the elimination tree.
			   it is assumed that parent(i) > i except of
			   the roots.

   OUTPUT parameters:
       fson	       -   the first son vector.
       brothr	       -   the brother vector.

  ************************************************************************/

    int node, ndpar, lroot;

    /* Parameter adjustments */
    --brothr;
    --fson;
    --parent;

    if (*neqns <= 0) {
	return 0;
    }

    for (node = 1; node <= *neqns; ++node) {
	fson[node] = 0;
	brothr[node] = 0;
    }
    lroot = *neqns;
    /* ------------------------------------------------------------
       FOR EACH NODE := NEQNS-1 STEP -1 DOWNTO 1, DO THE FOLLOWING.
       ------------------------------------------------------------ */
    if (*neqns <= 1) {
	return 0;
    }
    for (node = *neqns - 1; node >= 1; --node) {
	ndpar = parent[node];
	if (ndpar <= 0 || ndpar == node) {
	    /* -------------------------------------------------
	       NODE HAS NO PARENT.  GIVEN STRUCTURE IS A FOREST.
	       SET NODE TO BE ONE OF THE ROOTS OF THE TREES.
	       ------------------------------------------------- */
	    brothr[lroot] = node;
	    lroot = node;
	} else {
	    /* -------------------------------------------
	       OTHERWISE, BECOMES FIRST SON OF ITS PARENT.
	       ------------------------------------------- */
	    brothr[node] = fson[ndpar];
	    fson[ndpar] = node;
	}
    }
    brothr[lroot] = 0;

    return 0;
} /* betree_

 ***********************************************************************
 **********************************************************************
*/
int
F77_SUB(bfinit)(int *neqns, int *nsuper, int *xsuper,
		int *snode, int *xlindx, int *lindx, int *cachsz,
		int *tmpsiz, int *split)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ******	    BFINIT ..... INITIALIZATION FOR BLOCK FACTORIZATION	  ******
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       This subroutine computes items needed by the left-looking
       block-to-block cholesky factoritzation routine blkfct.

   INPUT parameters:
       neqns	       -   number of equations.
       nsuper	       -   number of supernodes.
       xsuper	       -   integer array of size (nsuper+1) containing
			   the supernode partitioning.
       snode	       -   supernode membership.
       (xlindx,lindx)  -   arrays describing the supernodal structure.
       cachsz	       -   cache size (in kbytes).

   OUTPUT parameters:
       tmpsiz	       -   size of working storage required by blkfct.
       split	       -   splitting of supernodes so that they fit
			   into cache.

 ***********************************************************************
*/
    /* Determine floating point working space requirement.
       ---------------------------------------------------*/
    fntsiz_(nsuper, xsuper, snode, xlindx, lindx, tmpsiz);

    /* Partition supernodes for cache.
       ------------------------------- */
    fnsplt_(neqns, nsuper, xsuper, xlindx, cachsz, split);

    return 0;
} /* bfinit_ */

/************************************************************************/

void
F77_SUB(blkfc2)(int *nsuper, int *xsuper, int *snode, int *split,
		int *xlindx, int *lindx, int *xlnz, double *lnz,
		int *link, int *length, int *indmap, int *relind,
		int *tmpsiz, double *tmpvec, int *iflag,
		U_fp mmpyn, U_fp smxpy)
{
/* Version:	   0.3
   Last modified:  March 6, 1995
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratoy

 ***********************************************************************
 ***********************************************************************
 *********     blkfc2 .....  block general sparse cholesky     *********
 ***********************************************************************
 ***********************************************************************

   Purpose:

       This subroutine factors a sparse positive definite matrix.
       the computation is organized around kernels that perform
       supernode-to-supernode updates, i.e., block-to-block updates.


   INPUT parameters:
       nsuper	       -   number of supernodes.
       xsuper	       -   supernode partition.
       snode	       -   maps each column to the supernode containing it.
       split	       -   splitting of supernodes so that they fit
			   into cache.
       (xlindx,lindx)  -   row indices for each supernode (including
			   the diagonal elements).
       (xlnz,lnz)      -   on input, contains matrix to be factored.
       tmpsiz	       -   size of temporary working storage.
       mmpyn	       -   external routine: matrix-matrix multiply.
       smxpy	       -   external routine: matrix-vector multiply.

   OUTPUT parameters:

       lnz	       -   on output, contains cholesky factor.
       iflag	       -   error flag.
			       0: successful factorization.
			      -1: nonpositive diagonal encountered,
				  matrix is not positive definite.
			      -2: insufficient working storage [tmpvec(*)].
			     -17: tiny diagonals replaced with Inf

   WORKING parameters:

       link	       -   links together the supernodes in a supernode row.
       length	       -   length of the active portion of each
			   supernode.
       indmap	       -   vector of size neqns into which the global
			   indices are scattered.
       relind	       -   maps locations in the updating columns to
			   the corresponding locations in the updated
			   columns.  (relind is gathered from indmap).
       tmpvec	       -   real vector for accumulating updates.  must
			   accomodate all columns of a supernode.

***********************************************************************
*/
    extern int
	assmb_(int *m, int *q, double *y, int *
	       relind, int *xlnz, double *lnz, int *lda);

    /* Local variables */
    double mxdiag;

    int i, ilen, jlen, klen, jsup, ksup, fjcol, fkcol, ljcol;
    int klast, ilpnt, jlpnt, klpnt, store, ntiny, jxpnt, kxpnt, inddif;
    int njcols, nkcols, ncolup, kfirst, nxtcol, nxksup, nxtsup;


/***********************************************************************/

   /* Parameter adjustments */
    --length;
    --link;
    --lnz;
    --xlnz;
    --lindx;
    --xlindx;
    --split;
    --snode;
    --xsuper;

    /* Function Body */
    *iflag = 0;
    ntiny = 0;

    /* -----------------------------------------------------------
       Initialize empty row lists in link(*) and zero out tmpvec(*).
       ----------------------------------------------------------- */
    for (jsup = 1; jsup <= *nsuper; ++jsup) {
	link[jsup] = 0;
    }
    for (i = 0; i < *tmpsiz; ++i)
	tmpvec[i] = 0.;

    /* Compute maximum diagonal element in input matrix */
    mxdiag = 0.;
    for (i = 1; i < xsuper[*nsuper + 1]; ++i) {
	fjcol = xlnz[i];
	if(mxdiag < lnz[fjcol])
	    mxdiag = lnz[fjcol];
    }

    /*---------------------------
      FOR EACH SUPERNODE JSUP ...
      --------------------------- */
    for (jsup = 1; jsup <= *nsuper; ++jsup) {

	/* ------------------------------------------------
	   fjcol  ...  first column of supernode jsup.
	   ljcol  ...  last column of supernode jsup.
	   njcols ...  number of columns in supernode jsup.
	   jlen	  ...  length of column fjcol.
	   jxpnt  ...  pointer to index of first
		       nonzero in column fjcol.
	   ------------------------------------------------ */
	fjcol = xsuper[jsup];
	njcols = xsuper[jsup + 1] - fjcol;
	ljcol = fjcol + njcols - 1;
	jlen = xlnz[fjcol + 1] - xlnz[fjcol];
	jxpnt = xlindx[jsup];
	/* print *, 'Super Node: ', JSUP, ' first: ', FJCOL,
	   .	       ' last: ', LJCOL */

	/* -----------------------------------------------------
	   set up indmap(*) to map the entries in update columns
	   to their corresponding positions in updated columns,
	   relative the the bottom of each updated column.
	   ----------------------------------------------------- */
	ldindx_(&jlen, &lindx[jxpnt], indmap);

	/* -----------------------------------------
	   for every supernode ksup in row(jsup) ...
	   ----------------------------------------- */
	ksup = link[jsup];
L300:
	if (ksup > 0) {
	    nxksup = link[ksup];

	    /* -------------------------------------------------------
	       get info about the cmod(jsup,ksup) update.

	       fkcol  ...  first column of supernode ksup.
	       nkcols ...  number of columns in supernode ksup.
	       klen   ...  length of active portion of column fkcol.
	       kxpnt  ...  pointer to index of first nonzero in active
			   portion of column fjcol.
	       ------------------------------------------------------- */
	    fkcol = xsuper[ksup];
	    nkcols = xsuper[ksup + 1] - fkcol;
	    klen = length[ksup];
	    kxpnt = xlindx[ksup + 1] - klen;

	    /* -------------------------------------------
	       perform cmod(jsup,ksup), with special cases
	       handled differently.
	       ------------------------------------------- */

	    if (klen != jlen) {
		/* -------------------------------------------
		   SPARSE CMOD(JSUP,KSUP).

		   NCOLUP ... NUMBER OF COLUMNS TO BE UPDATED.
		   ------------------------------------------- */

		for (i = 0; i < klen; ++i) {
		    nxtcol = lindx[kxpnt + i];
		    if (nxtcol > ljcol) {
			goto L500;
		    }
		}
		i = klen;
L500:
		ncolup = i;

		if (nkcols == 1) {

		    /* ----------------------------------------------
		       UPDATING TARGET SUPERNODE BY TRIVIAL
		       SUPERNODE (WITH ONE COLUMN).

		       KLPNT  ...  POINTER TO FIRST NONZERO IN ACTIVE
				   PORTION OF COLUMN FKCOL.
		       ---------------------------------------------- */
		    klpnt = xlnz[fkcol + 1] - klen;
		    mmpyi_(&klen, &ncolup, &lindx[kxpnt], &lnz[klpnt],
			   &xlnz[1], &lnz[1], indmap);

		} else {

		    /* --------------------------------------------
		       KFIRST ...  FIRST INDEX OF ACTIVE PORTION OF
				   SUPERNODE KSUP (FIRST COLUMN TO
				   BE UPDATED).
		       KLAST  ...  LAST INDEX OF ACTIVE PORTION OF
				   SUPERNODE KSUP.
		       -------------------------------------------- */

		    kfirst = lindx[kxpnt];
		    klast = lindx[kxpnt + klen - 1];
		    inddif = indmap[kfirst -1] - indmap[klast -1];

		    if (inddif < klen) {

			/* ---------------------------------------
			   DENSE CMOD(JSUP,KSUP).

			   ILPNT  ...  POINTER TO FIRST NONZERO IN
				       COLUMN KFIRST.
			   ILEN	  ...  LENGTH OF COLUMN KFIRST.
			   --------------------------------------- */
			ilpnt = xlnz[kfirst];
			ilen = xlnz[kfirst + 1] - ilpnt;
			mmpy_(&klen, &nkcols, &ncolup, &split[fkcol],
			      &xlnz[fkcol], &lnz[1], &lnz[ilpnt], &ilen,
			      (U_fp) mmpyn);

		    } else {

			/* -------------------------------
			   GENERAL SPARSE CMOD(JSUP,KSUP).
			   COMPUTE CMOD(JSUP,KSUP) UPDATE
			   IN WORK STORAGE.
			   ------------------------------- */
			store = klen * ncolup - ncolup * (ncolup - 1) / 2;
			if (store > *tmpsiz) {
			    *iflag = -2; return;
			}
			mmpy_(&klen, &nkcols, &ncolup, &split[fkcol],
			      &xlnz[fkcol], &lnz[1], tmpvec, &klen,
			      (U_fp) mmpyn);

			/* ----------------------------------------
			   GATHER INDICES OF KSUP RELATIVE TO JSUP.
			   ---------------------------------------- */
			igathr_(&klen, &lindx[kxpnt], indmap, relind);
			/* --------------------------------------
			   INCORPORATE THE CMOD(JSUP,KSUP) BLOCK
			   UPDATE INTO THE TO APPROPRIATE COLUMNS
			   OF L.
			   -------------------------------------- */
			assmb_(&klen, &ncolup, tmpvec, relind,
			       &xlnz[fjcol], &lnz[1], &jlen);
		    }

		}

	    } else {

		/* ----------------------------------------------
		   DENSE CMOD(JSUP,KSUP).
		   JSUP AND KSUP HAVE IDENTICAL STRUCTURE.

		   JLPNT  ...  POINTER TO FIRST NONZERO IN COLUMN
			       FJCOL.
		   ---------------------------------------------- */
		jlpnt = xlnz[fjcol];
		mmpy_(&klen, &nkcols, &njcols, &split[fkcol], &xlnz[fkcol],
		      &lnz[1], &lnz[jlpnt], &jlen, (U_fp)mmpyn);
		ncolup = njcols;
		if (klen > njcols) {
		    nxtcol = lindx[jxpnt + njcols];
		}

	    }

	    /* ------------------------------------------------
	       LINK KSUP INTO LINKED LIST OF THE NEXT SUPERNODE
	       IT WILL UPDATE AND DECREMENT KSUP'S ACTIVE
	       LENGTH.
	       ------------------------------------------------ */
	    if (klen > ncolup) {
		nxtsup = snode[nxtcol];
		link[ksup] = link[nxtsup];
		link[nxtsup] = ksup;
		length[ksup] = klen - ncolup;
	    } else {
		length[ksup] = 0;
	    }

	    /* -------------------------------
	       NEXT UPDATING SUPERNODE (KSUP).
	       ------------------------------- */
	    ksup = nxksup;
	    goto L300;

	}

	/* ----------------------------------------------
	   APPLY PARTIAL CHOLESKY TO THE COLUMNS OF JSUP.
	   ---------------------------------------------- */
	chlsup(jlen, njcols, &split[fjcol], &xlnz[fjcol], &lnz[1],
	       mxdiag, &ntiny, iflag, (U_fp)mmpyn, (U_fp)smxpy);

	if (*iflag != 0) { *iflag = -1; return; }

	/* -----------------------------------------------
	   INSERT JSUP INTO LINKED LIST OF FIRST SUPERNODE
	   IT WILL UPDATE.
	   ----------------------------------------------- */
	if (jlen > njcols) {
	    nxtcol = lindx[jxpnt + njcols];
	    nxtsup = snode[nxtcol];
	    link[jsup] = link[nxtsup];
	    link[nxtsup] = jsup;
	    length[jsup] = jlen - njcols;
	} else {
	    length[jsup] = 0;
	}

    } /* end {for } */

    if (ntiny != 0) {
#ifdef DEBUG_quantreg
	REprintf("* blkfc2(): Replaced %d tiny (<= mxdiag * 1e-30, mxdiag= %g)"
		 " diagonals with 'Inf'\n",
		 ntiny, mxdiag);
#endif
	/* set iflag to -17   to indicate presence of tiny diagonals */
	*iflag = -17; /* was -1 -- but this confounds with '-1' above ! */
    }
    return;
} /* blkfc2 */

/************************************************************************
 ***********************************************************************
 */
int
F77_SUB(blkfct)(int *neqns,
		int *nsuper, int *xsuper, int *snode, int *split,
		int *xlindx, int *lindx, int *xlnz, double *lnz,
		int *iwsiz, int *iwork,
		int *tmpsiz, double *tmpvec, int *iflag,
		U_fp mmpyn, U_fp smxpy)
{
/*
   Version:	   0.4
   Last modified:  March 6, 1995
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 *********     BLKFCT .....  BLOCK GENERAL SPARSE CHOLESKY     *********
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       THIS SUBROUTINE CALLS THE BLOCK GENERAL SPARSE CHOLESKY ROUTINE,
       BLKFC2.

   INPUT PARAMETERS:
       NSUPER	       -   NUMBER OF SUPERNODES.
       XSUPER	       -   SUPERNODE PARTITION.
       SNODE	       -   MAPS EACH COLUMN TO THE SUPERNODE CONTAINING
			   IT.
       SPLIT	       -   SPLITTING OF SUPERNODES SO THAT THEY FIT
			   INTO CACHE.
       (XLINDX,LINDX)  -   ROW INDICES FOR EACH SUPERNODE (INCLUDING
			   THE DIAGONAL ELEMENTS).
       (XLNZ,LNZ)      -   ON INPUT, CONTAINS MATRIX TO BE FACTORED.
       IWSIZ	       -   SIZE OF INTEGER WORKING STORAGE
       TMPSIZ	       -   SIZE OF FLOATING POINT WORKING STORAGE.
       MMPYN	       -   EXTERNAL ROUTINE: MATRIX-MATRIX MULTIPLY.
       SMXPY	       -   EXTERNAL ROUTINE: MATRIX-VECTOR MULTIPLY.

   OUTPUT PARAMETERS:
       LNZ	       -   ON OUTPUT, CONTAINS CHOLESKY FACTOR.
       IFLAG	       -   ERROR FLAG.
			       0: SUCCESSFUL FACTORIZATION.
			      -1: NONPOSITIVE DIAGONAL ENCOUNTERED,
				  MATRIX IS NOT POSITIVE DEFINITE.
			      -2: INSUFFICIENT WORKING STORAGE
				  [TMPVEC(*)].
			      -3: INSUFFICIENT WORKING STORAGE
				  [IWORK(*)].

   WORKING PARAMETERS:
       IWORK	       -   INTEGER WORKING STORAGE OF LENGTH
			   2*NEQNS + 2*NSUPER.
       TMPVEC	       -   DOUBLE PRECISION WORKING STORAGE OF LENGTH
			   NEQNS.

 ************************************************************************/

    /* Function Body */
    *iflag = 0;
    if (*iwsiz < (*neqns << 1) + (*nsuper << 1)) {
	*iflag = -3;
	return 0;
    }
    F77_CALL(blkfc2)(nsuper, xsuper, snode, split, xlindx, lindx, xlnz, lnz,
		     iwork, &iwork[*nsuper], &iwork[(*nsuper << 1)],
		     &iwork[(*nsuper << 1) + *neqns],
		     tmpsiz, tmpvec, iflag, (U_fp)mmpyn, (U_fp)smxpy);
    return 0;
} /* blkfct_ */

/***********************************************************************
 ************************************************************************/

#ifdef _NOT_EVER_USED_
static int
blkslb_(int *nsuper, int *xsuper,
	    int *xlindx, int *lindx, int *xlnz, double *lnz,
	    double *rhs)
{
/*
   Written:	   October 6, 1996 by SJW. Based on routine BLKSLV of
		   Esmond G. Ng and Barry W. Peyton.

   Modified:	   Sept 30, 1999 to improve efficiency in the case
		   in which the right-hand side and solution are both
		   expected to be sparse. Happens a lot in "dense"
		   column handling.

 ***********************************************************************
 ***********************************************************************
 *********     BLKSLB ... BACK TRIANGULAR SUBSTITUTION	      **********
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       GIVEN THE CHOLESKY FACTORIZATION OF A SPARSE SYMMETRIC
       POSITIVE DEFINITE MATRIX, THIS SUBROUTINE PERFORMS THE
       BACKWARD TRIANGULAR SUBSTITUTION.  IT USES OUTPUT FROM BLKFCT.

   INPUT PARAMETERS:
       NSUPER	       -   NUMBER OF SUPERNODES.
       XSUPER	       -   SUPERNODE PARTITION.
       (XLINDX,LINDX)  -   ROW INDICES FOR EACH SUPERNODE.
       (XLNZ,LNZ)      -   CHOLESKY FACTOR.

   UPDATED PARAMETERS:
       RHS	       -   ON INPUT, CONTAINS THE RIGHT HAND SIDE.  ON
			   OUTPUT, CONTAINS THE SOLUTION.

 ***********************************************************************
*/

    /* Local variables */
    static int i;
    static double t;
    static int ix, jcol, ipnt, jpnt, jsup, fjcol, ljcol, ixstop, ixstrt;


/* ***********************************************************************


 ***********************************************************************


 ***********************************************************************

     Parameter adjustments */
    --rhs;
    --lnz;
    --xlnz;
    --lindx;
    --xlindx;
    --xsuper;

    /* Function Body */
    if (*nsuper <= 0) {
	return 0;
    }
    /* -------------------------
       BACKWARD SUBSTITUTION ...
       ------------------------- */
    ljcol = xsuper[*nsuper + 1] - 1;
    for (jsup = *nsuper; jsup >= 1; --jsup) {
	fjcol = xsuper[jsup];
	ixstop = xlnz[ljcol + 1] - 1;
	jpnt = xlindx[jsup] + (ljcol - fjcol);
	for (jcol = ljcol; jcol >= fjcol; --jcol) {
	    ixstrt = xlnz[jcol];
	    ipnt = jpnt + 1;
	    t = rhs[jcol];
/* DIR$		  IVDEP */
	    for (ix = ixstrt + 1; ix <= ixstop; ++ix) {
		i = lindx[ipnt];
		if (rhs[i] != 0.) {
		    t -= lnz[ix] * rhs[i];
		}
		++ipnt;
	    }
	    if (t != 0.) {
		rhs[jcol] = t / lnz[ixstrt];
	    } else {
		rhs[jcol] = 0.;
	    }
	    ixstop = ixstrt - 1;
	    --jpnt;
	}
	ljcol = fjcol - 1;
    }

    return 0;
} /* blkslb_

 ***********************************************************************
 ***********************************************************************
 */
static int
blkslf_(int *nsuper, int *xsuper,
	    int *xlindx, int *lindx, int *xlnz, double *lnz,
	    double *rhs)
{
/*
   Written:	   October 6, 1996 by SJW. Based on routine BLKSLV of
		   Esmond G. Ng and Barry W. Peyton.

   Modified:	   Sept 30, 1999 to improve efficiency in the case
		   in which the right-hand side and solution are both
		   expected to be sparse. Happens a lot in "dense"
		   column handling.

 ***********************************************************************
 ***********************************************************************
 *********     BLKSLF ... FORWARD TRIANGULAR SUBSTITUTION     **********
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       GIVEN THE CHOLESKY FACTORIZATION OF A SPARSE SYMMETRIC
       POSITIVE DEFINITE MATRIX, THIS SUBROUTINE PERFORMS THE
       FORWARD TRIANGULAR SUBSTITUTIOn.	 IT USES OUTPUT FROM BLKFCT.

   INPUT PARAMETERS:
       NSUPER	       -   NUMBER OF SUPERNODES.
       XSUPER	       -   SUPERNODE PARTITION.
       (XLINDX,LINDX)  -   ROW INDICES FOR EACH SUPERNODE.
       (XLNZ,LNZ)      -   CHOLESKY FACTOR.

   UPDATED PARAMETERS:
       RHS	       -   ON INPUT, CONTAINS THE RIGHT HAND SIDE.  ON
			   OUTPUT, CONTAINS THE SOLUTION.

 ***********************************************************************
*/
    /* Local variables */
    static int i;
    static double t;
    static int ix, jcol, ipnt, jpnt, jsup, fjcol, ljcol, ixstop, ixstrt;


/* ***********************************************************************


 ***********************************************************************

     Parameter adjustments */
    --rhs;
    --lnz;
    --xlnz;
    --lindx;
    --xlindx;
    --xsuper;

    /* Function Body */
    if (*nsuper <= 0) {
	return 0;
    }

    /* ------------------------
       FORWARD SUBSTITUTION ...
       ------------------------ */
    fjcol = xsuper[1];
    for (jsup = 1; jsup <= *nsuper; ++jsup) {
	ljcol = xsuper[jsup + 1] - 1;
	ixstrt = xlnz[fjcol];
	jpnt = xlindx[jsup];
	for (jcol = fjcol; jcol <= ljcol; ++jcol) {
	    ixstop = xlnz[jcol + 1] - 1;
	    if (rhs[jcol] != 0.) {
		t = rhs[jcol] / lnz[ixstrt];
		rhs[jcol] = t;
		ipnt = jpnt + 1;
/* DIR$		  IVDEP */
		for (ix = ixstrt + 1; ix <= ixstop; ++ix) {
		    i = lindx[ipnt];
		    rhs[i] -= t * lnz[ix];
		    ++ipnt;
		}
	    }
	    ixstrt = ixstop + 1;
	    ++jpnt;
	}
	fjcol = ljcol + 1;
    }

    return 0;
} /* blkslf_ */

#endif
/* _NOT_EVER_USED_ */

/***********************************************************************
 ***********************************************************************/

int
F77_SUB(blkslv)(int *nsuper, int *xsuper, int *xlindx, int *lindx,
		int *xlnz, double *lnz, double *rhs)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

   Modified:	   Sept 30, 1999 to improve efficiency in the case
		   in which the right-hand side and solution are both
		   expected to be sparse. Happens a lot in "dense"
		   column handling.

 ***********************************************************************
 ***********************************************************************
 *********     BLKSLV ... BLOCK TRIANGULAR SOLUTIONS	      **********
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       GIVEN THE CHOLESKY FACTORIZATION OF A SPARSE SYMMETRIC
       POSITIVE DEFINITE MATRIX, THIS SUBROUTINE PERFORMS THE
       TRIANGULAR SOLUTION.  IT USES OUTPUT FROM BLKFCT.

   INPUT PARAMETERS:
       NSUPER	       -   NUMBER OF SUPERNODES.
       XSUPER	       -   SUPERNODE PARTITION.
       (XLINDX,LINDX)  -   ROW INDICES FOR EACH SUPERNODE.
       (XLNZ,LNZ)      -   CHOLESKY FACTOR.

   UPDATED PARAMETERS:
       RHS	       -   ON INPUT, CONTAINS THE RIGHT HAND SIDE.  ON
			   OUTPUT, CONTAINS THE SOLUTION.

 ***********************************************************************
 */
    /* Local variables */
    static int i;
    static double t;
    static int ix, jcol, ipnt, jpnt, jsup, fjcol, ljcol, ixstop, ixstrt;


/* ***********************************************************************


 ***********************************************************************

     Parameter adjustments */
    --rhs;
    --lnz;
    --xlnz;
    --lindx;
    --xlindx;
    --xsuper;

    /* Function Body */
    if (*nsuper <= 0) {
	return 0;
    }

    /* ------------------------
       FORWARD SUBSTITUTION ...
       ------------------------ */
    fjcol = xsuper[1];
    for (jsup = 1; jsup <= *nsuper; ++jsup) {
	ljcol = xsuper[jsup + 1] - 1;
	ixstrt = xlnz[fjcol];
	jpnt = xlindx[jsup];
	for (jcol = fjcol; jcol <= ljcol; ++jcol) {
	    ixstop = xlnz[jcol + 1] - 1;
	    if (rhs[jcol] != 0.) {
		t = rhs[jcol] / lnz[ixstrt];
		rhs[jcol] = t;
		ipnt = jpnt + 1;
/* DIR$		  IVDEP */
		for (ix = ixstrt + 1; ix <= ixstop; ++ix) {
		    i = lindx[ipnt];
		    rhs[i] -= t * lnz[ix];
		    ++ipnt;
		}
	    }
	    ixstrt = ixstop + 1;
	    ++jpnt;
	}
	fjcol = ljcol + 1;
    }

    /* -------------------------
       BACKWARD SUBSTITUTION ...
       ------------------------- */
    ljcol = xsuper[*nsuper + 1] - 1;
    for (jsup = *nsuper; jsup >= 1; --jsup) {
	fjcol = xsuper[jsup];
	ixstop = xlnz[ljcol + 1] - 1;
	jpnt = xlindx[jsup] + (ljcol - fjcol);
	for (jcol = ljcol; jcol >= fjcol; --jcol) {
	    ixstrt = xlnz[jcol];
	    ipnt = jpnt + 1;
	    t = rhs[jcol];
/* DIR$		  IVDEP */
	    for (ix = ixstrt + 1; ix <= ixstop; ++ix) {
		i = lindx[ipnt];
		if (rhs[i] != 0.) {
		    t -= lnz[ix] * rhs[i];
		}
		++ipnt;
	    }
	    if (t != 0.) {
		rhs[jcol] = t / lnz[ixstrt];
	    } else {
		rhs[jcol] = 0.;
	    }
	    ixstop = ixstrt - 1;
	    --jpnt;
	}
	ljcol = fjcol - 1;
    }

    return 0;
} /* blkslv_

 ***********************************************************************
 ***********************************************************************
 */
static int
btree2_(int *neqns, int *parent, int *colcnt,
	int *fson, int *brothr, int *lson)
{
/*
   Version:	   0.4
   Last modified:  January 12, 1995
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ******	    BTREE2 ..... Binary TREE representation of ETREE	 *******
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       To determine a binary tree representation of the elimination
       tree, for which every "last child" has the maximum possible
       column nonzero count in the factor.  the returned representation
       will be given by the first-son and brother vectors.  the root of
       the binary tree is always neqns.

   INPUT parameters:
       neqns	       -   number of equations.
       parent	       -   the parent vector of the elimination tree.
			   it is assumed that parent(i) > i except of
			   the roots.
       colcnt	       -   column nonzero counts of the factor.

   OUTPUT parameters:
       fson	       -   the first son vector.
       brothr	       -   the brother vector.

   Working parameters:
       lson	       -   last son vector.

 ***********************************************************************
 */

    int node, ndpar, lroot, ndlson;

    /* Parameter adjustments */
    --lson;
    --brothr;
    --fson;
    --colcnt;
    --parent;

    /* Function Body */
    if (*neqns <= 0) {
	return 0;
    }

    for (node = 1; node <= *neqns; ++node) {
	fson[node] = 0;
	brothr[node] = 0;
	lson[node] = 0;
    }
    lroot = *neqns;
    /* ------------------------------------------------------------
       FOR EACH NODE := NEQNS-1 STEP -1 DOWNTO 1, DO THE FOLLOWING.
       ------------------------------------------------------------ */
    if (*neqns <= 1) {
	return 0;
    }
    for (node = *neqns - 1; node >= 1; --node) {
	ndpar = parent[node];
	if (ndpar <= 0 || ndpar == node) {
	    /* -------------------------------------------------
	       NODE HAS NO PARENT.  GIVEN STRUCTURE IS A FOREST.
	       SET NODE TO BE ONE OF THE ROOTS OF THE TREES.
	       ------------------------------------------------- */
	    brothr[lroot] = node;
	    lroot = node;
	} else {
	    /* -------------------------------------------
	       OTHERWISE, BECOMES FIRST SON OF ITS PARENT.
	       ------------------------------------------- */
	    ndlson = lson[ndpar];
	    if (ndlson != 0) {
		if (colcnt[node] >= colcnt[ndlson]) {
		    brothr[node] = fson[ndpar];
		    fson[ndpar] = node;
		} else {
		    brothr[ndlson] = node;
		    lson[ndpar] = node;
		}
	    } else {
		fson[ndpar] = node;
		lson[ndpar] = node;
	    }
	}
    }
    brothr[lroot] = 0;

    return 0;
} /* btree2_ */

/***********************************************************************
 ***********************************************************************/

static void
chlsup(int m, int n, int *split, int *xpnt, double *x,
       double mxdiag, int *ntiny, int *iflag,
       S_fp mmpyn, U_fp smxpy)
{
/*
   Version:	   0.3
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratoy

 ***********************************************************************
 ***********************************************************************
 ******	    chlsup .... dense cholesky within supernode	  **************
 ***********************************************************************
 ***********************************************************************

     PURPOSE - This routine performs cholesky
	       factorization on the columns of a supernode
	       that have received all updates from columns
	       external to the supernode.

     INPUT parameters -

	m      - number of rows (length of the first column).
	n      - number of columns in the supernode.
	xpnt   - xpnt(j+1) points one location beyond the end
		 of the j-th column of the supernode.
	x(*)   - contains the columns of of the supernode to
		 be factored.
	smxpy  - external routine: matrix-vector multiply.

     OUTPUT parameters -

	x(*)   - on output, contains the factored columns of
		 the supernode.
	iflag  - unchanged if there is no error.
		 =1 if nonpositive diagonal entry is encountered.

 ***********************************************************************
*/
    int q, mm, nn, jblk, jpnt, fstcol, nxtcol;

    /* Parameter adjustments */
    --xpnt;
    --split;

    jblk = 0;
    fstcol = 1;
    mm = m;
    jpnt = xpnt[fstcol];

    /* ----------------------------------------
       For each block jblk in the supernode ...
       ---------------------------------------- */
    fstcol = 1;
    while (fstcol <= n) {
	++jblk;
	nn = split[jblk];

	/* ------------------------------------------
	   ... Perform partial cholesky factorization on the block.
	       ------------------------------------------*/

	pchol(mm, nn, &xpnt[fstcol], x, mxdiag, ntiny, iflag, (U_fp) smxpy);

	if (*iflag == 1) {
	    return;
	}

	/* ----------------------------------------------
	   ... Apply the columns in jblk to any columns
	       of the supernode remaining to be computed.
	   ---------------------------------------------- */
	nxtcol = fstcol + nn;
	q = n - nxtcol + 1;
	mm -= nn;
	jpnt = xpnt[nxtcol];
	if (q > 0) {
	    (*mmpyn)(&mm, &nn, &q, &xpnt[fstcol], x, &x[jpnt -1], &mm);
	}
	fstcol = nxtcol;
    }

    return;
} /* chlsup */

/***********************************************************************
 ***********************************************************************
 */
static int
chordr_(int *neqns, int *xadj, int *adjncy,
	int *perm, int *invp, int *colcnt, int *parent,
	int *fson, int *brothr, int *invpos)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 **********	chordr ..... child reordering		     ***********
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       Rearrange the children of each vertex so that the last one
       maximizes (among the children) the number of nonzeros in the
       corresponding column of L.  also determine an new postordering
       based on the structure of the modified elimination tree.

   INPUT parameters:
       neqns	       -   number of equations.
       (xadj,adjncy)   -   the adjacency structure.

   UPDATED parameters:
       (perm,invp)     -   on input, the given perm and inverse perm
			   vectors.  on output, the new perm and
			   inverse perm vectors of the new
			   postordering.
       colcnt	       -   column counts in L under initial ordering;
			   modified to reflect the new ordering.

   OUTPUT parameters:
       parent	       -   the parent vector of the elimination tree
			   associated with the new ordering.

   Working parameters:
       fson	       -   the first son vector.
       brothr	       -   the brother vector.
       invpos	       -   the inverse perm vector for the postordering.
 ***********************************************************************
 */
    extern int
	btree2_(int *, int *, int *, int *, int *, int *);

    /*----------------------------------------------------------
      Compute a binary representation of the elimination tree,
      so that each "last child" maximizes among its siblings the
      number of nonzeros in the corresponding columns of L.
      ----------------------------------------------------------*/

    btree2_(neqns, parent, colcnt, fson, brothr, invpos);

    /* ----------------------------------------------------
       postorder the elimination tree (using the new binary
       representation.
       ---------------------------------------------------- */
    epost2_(neqns, fson, brothr, invpos, parent, colcnt, perm);

    /* --------------------------------------------------------
       compose the original ordering with the new postordering.
       -------------------------------------------------------- */
    invinv_(neqns, invp, invpos, perm);

    return 0;
} /* chordr_ */

/************************************************************************
 ***********************************************************************/

static void
dscal1_(int n, double a, double *x)
{
    int i;
    for (i = 0; i < n; ++i)
	x[i] *= a;

    return;
}

/************************************************************************
 ************************************************************************/

static int
epost2_(int *root, int *fson, int *brothr,
	    int *invpos, int *parent, int *colcnt, int *stack)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ***************     EPOST2 ..... Etree POSTordering #2	 ***************
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       Based on the binary representation (first-son,brother) of the
       elimination tree, a postordering is determined. the
       corresponding parent and colcnt vectors are also modified to
       reflect the reordering.

   INPUT parameters:
       root	       -   root of the elimination tree (usually it
			   is neqns).
       fson	       -   the first son vector.
       brothr	       -   the brothr vector.

   UPDATED parameters:
       parent	       -   the parent vector.
       colcnt	       -   column nonzero counts of the factor.

   OUTPUT parameters:
       invpos	       -   inverse permutation for the postordering.

   Working parameters:
       stack	       -   the stack for postorder traversal of the tree.

 ***********************************************************************
 */

    int num, node, itop, ndpar, nunode;

    /* Parameter adjustments */
    --stack;
    --colcnt;
    --parent;
    --invpos;
    --brothr;
    --fson;

    /* Function Body */
    num = 0;
    itop = 0;
    node = *root;
    /* -------------------------------------------------------------
       TRAVERSE ALONG THE FIRST SONS POINTER AND PUSH THE TREE NODES
       ALONG THE TRAVERSAL INTO THE STACK.
       ------------------------------------------------------------- */
L100:
    do {
	++itop;
	stack[itop] = node;
	node = fson[node];
    } while (node > 0);

    /* ----------------------------------------------------------
	   IF POSSIBLE, POP A TREE NODE FROM THE STACK AND NUMBER IT.
	   ---------------------------------------------------------- */
    do {
	if (itop <= 0) {
	    goto L300;
	}
	node = stack[itop];
	--itop;
	++num;
	invpos[node] = num;
	/* ----------------------------------------------------
		 THEN, TRAVERSE TO ITS YOUNGER BROTHER IF IT HAS ONE.
		 ---------------------------------------------------- */
	node = brothr[node];
    } while (node <= 0);

    goto L100;

L300:
    /* ------------------------------------------------------------
       DETERMINE THE NEW PARENT VECTOR OF THE POSTORDERING.  BROTHR
       IS USED TEMPORARILY FOR THE NEW PARENT VECTOR.
       ------------------------------------------------------------ */
    for (node = 1; node <= num; ++node) {
	nunode = invpos[node];
	ndpar = parent[node];
	if (ndpar > 0) {
	    ndpar = invpos[ndpar];
	}
	brothr[nunode] = ndpar;
    }

    for (nunode = 1; nunode <= num; ++nunode) {
	parent[nunode] = brothr[nunode];
    }

    /* ----------------------------------------------
       PERMUTE COLCNT(*) TO REFLECT THE NEW ORDERING.
       ---------------------------------------------- */
    for (node = 1; node <= num; ++node) {
	nunode = invpos[node];
	stack[nunode] = colcnt[node];
    }

    for (node = 1; node <= num; ++node) {
	colcnt[node] = stack[node];
    }

    return 0;
} /* epost2_ */

/***********************************************************************
 ***********************************************************************
*/
static void
etordr_(int *neqns, int *xadj, int *adjncy, int *perm, int *invp,
	int *parent, int *fson, int *brothr, int *invpos)
{
/* Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Joseph W.H. Liu

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 **********	ETORDR ..... ELIMINATION TREE REORDERING     ***********
 ***********************************************************************
 ***********************************************************************

   Written by Joseph Liu (Jul 17, 1985)

   PURPOSE:
       to determine an equivalent reordering based on the structure of
       the elimination tree.  a postordering of the given elimination
       tree is returned.

   INPUT parameters:
       neqns	       -   number of equations.
       (xadj,adjncy)   -   the adjacency structure.

   UPDATED parameters:
       (perm,invp)     -   on input, the given perm and inverse perm
			   vectors.  on output, the new perm and
			   inverse perm vectors of the equivalent ordering.

   OUTPUT parameters:
       parent	       -   the parent vector of the elimination tree
			   associated with the new ordering.

   Working parameters:
       fson	       -   the first son vector.
       brothr	       -   the brother vector.
       invpos	       -   the inverse perm vector for the postordering.

   Program subroutines:
       betree, etpost, etree , invinv.

***********************************************************************/

    /*-----------------------------
      Compute the elimination tree.
      ----------------------------- */

    etree_(neqns, xadj, adjncy, perm, invp, parent, invpos);

    /* --------------------------------------------------------
       Compute a binary representation of the elimination tree.
       -------------------------------------------------------- */
    betree_(neqns, parent, fson, brothr);

    /* -------------------------------
       Postorder the elimination tree.
       ------------------------------- */
    etpost_(neqns, fson, brothr, invpos, parent, perm);

    /* --------------------------------------------------------
       Compose the original ordering with the new postordering.
       -------------------------------------------------------- */
    invinv_(neqns, invp, invpos, perm);

    return;
} /* etordr_ */

/* *********************************************************************** */

static int
etpost_(int *root, int *fson, int *brothr,
	int *invpos, int *parent, int *stack)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Joseph W.H. Liu

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ***************     etpost ..... ETree POSTordering	 ***************
 ***********************************************************************
 ***********************************************************************

   Written by Joseph Liu (Sept 17, 1986)

   PURPOSE:
       Based on the binary representation (first-son,brother) of
       the elimination tree, a postordering is determined. the
       corresponding parent vector is also modified to reflect
       the reordering.

   INPUT parameters:
       root	       -   root of the elimination tree (usually it is neqns).
       fson	       -   the first son vector.
       brothr	       -   the brothr vector.

   UPDATED parameters:
       parent	       -   the parent vector.

   OUTPUT parameters:
       invpos	       -   inverse permutation for the postordering.

   Working parameters:
       stack	       -   the stack for postorder traversal of the tree.

 ***********************************************************************
*/
    int num, node, itop, ndpar, nunode;

    /* Parameter adjustments */
    --stack;
    --parent;
    --invpos;
    --brothr;
    --fson;

    /* Function Body */
    num = 0;
    itop = 0;
    node = *root;
    /* -------------------------------------------------------------
       TRAVERSE ALONG THE FIRST SONS POINTER AND PUSH THE TREE NODES
       ALONG THE TRAVERSAL INTO THE STACK.
       ------------------------------------------------------------- */

L100:
    do {
	++itop;
	stack[itop] = node;
	node = fson[node];
    } while (node > 0);

    /* ----------------------------------------------------------
	   IF POSSIBLE, POP A TREE NODE FROM THE STACK AND NUMBER IT.
	   ---------------------------------------------------------- */

    do { /* L200: */
	if (itop <= 0) {
	    goto L300;
	}
	node = stack[itop];
	--itop;
	++num;
	invpos[node] = num;
	/* ----------------------------------------------------
	   THEN, TRAVERSE TO ITS YOUNGER BROTHER IF IT HAS ONE.
	   ---------------------------------------------------- */
	node = brothr[node];
    } while (node <= 0);

    goto L100;

L300:
    /* ------------------------------------------------------------
       DETERMINE THE NEW PARENT VECTOR OF THE POSTORDERING.  BROTHR
       IS USED TEMPORARILY FOR THE NEW PARENT VECTOR.
       ------------------------------------------------------------ */
    for (node = 1; node <= num; ++node) {
	nunode = invpos[node];
	ndpar = parent[node];
	if (ndpar > 0) {
	    ndpar = invpos[ndpar];
	}
	brothr[nunode] = ndpar;
    }

    for (nunode = 1; nunode <= num; ++nunode) {
	parent[nunode] = brothr[nunode];
    }

    return 0;
} /* etpost_ */

/************************************************************************
 *********************************************************************** */

static int
etree_(int *neqns, int *xadj, int *adjncy,
       int *perm, int *invp, int *parent, int *ancstr)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Joseph W.H. Liu

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ****************     ETREE ..... ELIMINATION TREE     *****************
 ***********************************************************************
 ***********************************************************************

   WRITTEN BY JOSEPH LIU (JUL 17, 1985)

   PURPOSE:
       TO DETERMINE THE ELIMINATION TREE FROM A GIVEN ORDERING AND
       THE ADJACENCY STRUCTURE.	 THE PARENT VECTOR IS RETURNED.

   INPUT PARAMETERS:
       NEQNS	       -   NUMBER OF EQUATIONS.
       (XADJ,ADJNCY)   -   THE ADJACENCY STRUCTURE.
       (PERM,INVP)     -   PERMUTATION AND INVERSE PERMUTATION VECTORS

   OUTPUT PARAMETERS:
       PARENT	       -   THE PARENT VECTOR OF THE ELIMINATION TREE.

   WORKING PARAMETERS:
       ANCSTR	       -   THE ANCESTOR VECTOR.

 ***********************************************************************
*/
  /* Local variables */
    static int i, j, nbr, node, next, jstop, jstrt;


/* ***********************************************************************



 ***********************************************************************


 ***********************************************************************

     Parameter adjustments */
    --ancstr;
    --parent;
    --invp;
    --perm;
    --adjncy;
    --xadj;

    /* Function Body */
    if (*neqns <= 0) {
	return 0;
    }

    for (i = 1; i <= *neqns; ++i) {
	parent[i] = 0;
	ancstr[i] = 0;
	node = perm[i];

	jstrt = xadj[node];
	jstop = xadj[node + 1] - 1;
	if (jstrt <= jstop) {
	    for (j = jstrt; j <= jstop; ++j) {
		nbr = adjncy[j];
		nbr = invp[nbr];
		if (nbr < i) {
		    /* -------------------------------------------
		       FOR EACH NBR, FIND THE ROOT OF ITS CURRENT
		       ELIMINATION TREE.  PERFORM PATH COMPRESSION
		       AS THE SUBTREE IS TRAVERSED.
		       ------------------------------------------- */
L100:
		    if (ancstr[nbr] == i) {
			goto L300;
		    }
		    if (ancstr[nbr] > 0) {
			next = ancstr[nbr];
			ancstr[nbr] = i;
			nbr = next;
			goto L100;
		    }
		    /* --------------------------------------------
		       NOW, NBR IS THE ROOT OF THE SUBTREE.  MAKE I
		       THE PARENT NODE OF THIS ROOT.
		       -------------------------------------------- */
		    parent[nbr] = i;
		    ancstr[nbr] = i;
		}
L300:
		;
	    }
	}
    }

    return 0;
} /* etree_

 ***********************************************************************
 ***********************************************************************
 */
static int
fcnthn_(int *neqns, int *adjlen, int *xadj,
	    int *adjncy, int *perm, int *invp, int *etpar,
	    int *rowcnt, int *colcnt, int *nlnz, int *set,
	    int *prvlf, int *level, int *weight, int *fdesc,
	    int *nchild, int *prvnbr)
{
/*
   Version:	   0.4
   Last modified:  January 12, 1995
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 **************	    FCNTHN  ..... FIND NONZERO COUNTS	 ***************
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       THIS SUBROUTINE DETERMINES THE ROW COUNTS AND COLUMN COUNTS IN
       THE CHOLESKY FACTOR.  IT USES A DISJOINT SET UNION ALGORITHM.

       TECHNIQUES:
       1) SUPERNODE DETECTION.
       2) PATH HALVING.
       3) NO UNION BY RANK.

   NOTES:
       1) ASSUMES A POSTORDERING OF THE ELIMINATION TREE.

   INPUT PARAMETERS:
       (I) NEQNS       -   NUMBER OF EQUATIONS.
       (I) ADJLEN      -   LENGTH OF ADJACENCY STRUCTURE.
       (I) XADJ(*)     -   ARRAY OF LENGTH NEQNS+1, CONTAINING POINTERS
			   TO THE ADJACENCY STRUCTURE.
       (I) ADJNCY(*)   -   ARRAY OF LENGTH XADJ(NEQNS+1)-1, CONTAINING
			   THE ADJACENCY STRUCTURE.
       (I) PERM(*)     -   ARRAY OF LENGTH NEQNS, CONTAINING THE
			   POSTORDERING.
       (I) INVP(*)     -   ARRAY OF LENGTH NEQNS, CONTAINING THE
			   INVERSE OF THE POSTORDERING.
       (I) ETPAR(*)    -   ARRAY OF LENGTH NEQNS, CONTAINING THE
			   ELIMINATION TREE OF THE POSTORDERED MATRIX.

   OUTPUT PARAMETERS:
       (I) ROWCNT(*)   -   ARRAY OF LENGTH NEQNS, CONTAINING THE NUMBER
			   OF NONZEROS IN EACH ROW OF THE FACTOR,
			   INCLUDING THE DIAGONAL ENTRY.
       (I) COLCNT(*)   -   ARRAY OF LENGTH NEQNS, CONTAINING THE NUMBER
			   OF NONZEROS IN EACH COLUMN OF THE FACTOR,
			   INCLUDING THE DIAGONAL ENTRY.
       (I) NLNZ	       -   NUMBER OF NONZEROS IN THE FACTOR, INCLUDING
			   THE DIAGONAL ENTRIES.

   WORK PARAMETERS:
       (I) SET(*)      -   ARRAY OF LENGTH NEQNS USED TO MAINTAIN THE
			   DISJOINT SETS (I.E., SUBTREES).
       (I) PRVLF(*)    -   ARRAY OF LENGTH NEQNS USED TO RECORD THE
			   PREVIOUS LEAF OF EACH ROW SUBTREE.
       (I) LEVEL(*)    -   ARRAY OF LENGTH NEQNS+1 CONTAINING THE LEVEL
			   (DISTANCE FROM THE ROOT).
       (I) WEIGHT(*)   -   ARRAY OF LENGTH NEQNS+1 CONTAINING WEIGHTS
			   USED TO COMPUTE COLUMN COUNTS.
       (I) FDESC(*)    -   ARRAY OF LENGTH NEQNS+1 CONTAINING THE
			   FIRST (I.E., LOWEST-NUMBERED) DESCENDANT.
       (I) NCHILD(*)   -   ARRAY OF LENGTH NEQNS+1 CONTAINING THE
			   NUMBER OF CHILDREN.
       (I) PRVNBR(*)   -   ARRAY OF LENGTH NEQNS USED TO RECORD THE
			   PREVIOUS ``LOWER NEIGHBOR'' OF EACH NODE.

   FIRST CREATED ON    APRIL 12, 1990.
   LAST UPDATED ON     JANUARY 12, 1995.

 ***********************************************************************
 */
    /* Local variables */
    static int j, k, lca, temp, xsup, last1, last2, lflag, pleaf, hinbr,

	    jstop, jstrt, ifdesc, oldnbr, parent, lownbr;


    /* -----------
       PARAMETERS.
       -----------

       ----------------
       LOCAL VARIABLES.
       ----------------

 ***********************************************************************

       --------------------------------------------------
       COMPUTE LEVEL(*), FDESC(*), NCHILD(*).
       INITIALIZE XSUP, ROWCNT(*), COLCNT(*),
		  SET(*), PRVLF(*), WEIGHT(*), PRVNBR(*).
       --------------------------------------------------
     Parameter adjustments */
    --prvnbr;
    --prvlf;
    --set;
    --colcnt;
    --rowcnt;
    --etpar;
    --invp;
    --perm;
    --adjncy;
    --xadj;

    /* Function Body */
    xsup = 1;
    level[0] = 0;
    for (k = *neqns; k >= 1; --k) {
	rowcnt[k] = 1;
	colcnt[k] = 0;
	set[k] = k;
	prvlf[k] = 0;
	level[k] = level[etpar[k]] + 1;
	weight[k] = 1;
	fdesc[k] = k;
	nchild[k] = 0;
	prvnbr[k] = 0;
    }
    nchild[0] = 0;
    fdesc[0] = 0;
    for (k = 1; k <= *neqns; ++k) {
	parent = etpar[k];
	weight[parent] = 0;
	++nchild[parent];
	ifdesc = fdesc[k];
	if (ifdesc < fdesc[parent]) {
	    fdesc[parent] = ifdesc;
	}
    }
    /* ------------------------------------
       FOR EACH ``LOW NEIGHBOR'' LOWNBR ...
       ------------------------------------ */
    for (lownbr = 1; lownbr <= *neqns; ++lownbr) {
	lflag = 0;
	ifdesc = fdesc[lownbr];
	oldnbr = perm[lownbr];
	jstrt = xadj[oldnbr];
	jstop = xadj[oldnbr + 1] - 1;
	/* -----------------------------------------------
	   FOR EACH ``HIGH NEIGHBOR'', HINBR OF LOWNBR ...
	   ----------------------------------------------- */
	for (j = jstrt; j <= jstop; ++j) {
	    hinbr = invp[adjncy[j]];
	    if (hinbr > lownbr) {
		if (ifdesc > prvnbr[hinbr]) {
		    /* -------------------------
		       INCREMENT WEIGHT(LOWNBR).
		       ------------------------- */
		    ++weight[lownbr];
		    pleaf = prvlf[hinbr];
		    /* -----------------------------------------
		       IF HINBR HAS NO PREVIOUS ``LOW NEIGHBOR''
		       THEN ...
		       ----------------------------------------- */
		    if (pleaf == 0) {
			/* -----------------------------------------
			   ... ACCUMULATE LOWNBR-->HINBR PATH LENGTH
			       IN ROWCNT(HINBR).
			   ----------------------------------------- */
			rowcnt[hinbr] = rowcnt[hinbr] + level[lownbr] - level[
				hinbr];
		    } else {
			/* -----------------------------------------
			   ... OTHERWISE, LCA <-- FIND(PLEAF), WHICH
			       IS THE LEAST COMMON ANCESTOR OF PLEAF
			       AND LOWNBR.
			       (PATH HALVING.)
			   ----------------------------------------- */
			last1 = pleaf;
			last2 = set[last1];
			lca = set[last2];
L300:
			if (lca != last2) {
			    set[last1] = lca;
			    last1 = lca;
			    last2 = set[last1];
			    lca = set[last2];
			    goto L300;
			}
			/* -------------------------------------
			   ACCUMULATE PLEAF-->LCA PATH LENGTH IN
			   ROWCNT(HINBR).
			   DECREMENT WEIGHT(LCA).
			   ------------------------------------- */
			rowcnt[hinbr] = rowcnt[hinbr] + level[lownbr] - level[
				lca];
			--weight[lca];
		    }
		    /* ----------------------------------------------
		       LOWNBR NOW BECOMES ``PREVIOUS LEAF'' OF HINBR.
		       ---------------------------------------------- */
		    prvlf[hinbr] = lownbr;
		    lflag = 1;
		}
		/* --------------------------------------------------
		   LOWNBR NOW BECOMES ``PREVIOUS NEIGHBOR'' OF HINBR.
		   -------------------------------------------------- */
		prvnbr[hinbr] = lownbr;
	    }
	}
	/* ----------------------------------------------------
	   DECREMENT WEIGHT ( PARENT(LOWNBR) ).
	   SET ( P(LOWNBR) ) <-- SET ( P(LOWNBR) ) + SET(XSUP).
	   ---------------------------------------------------- */
	parent = etpar[lownbr];
	--weight[parent];
	if (lflag == 1 || nchild[lownbr] >= 2) {
	    xsup = lownbr;
	}
	set[xsup] = parent;
    }
    /* ---------------------------------------------------------
       USE WEIGHTS TO COMPUTE COLUMN (AND TOTAL) NONZERO COUNTS.
       --------------------------------------------------------- */
    *nlnz = 0;
    for (k = 1; k <= *neqns; ++k) {
	temp = colcnt[k] + weight[k];
	colcnt[k] = temp;
	*nlnz += temp;
	parent = etpar[k];
	if (parent != 0) {
	    colcnt[parent] += temp;
	}
    }

    return 0;
} /* fcnthn_

 ***********************************************************************
 ***********************************************************************
 */
static int
fnsplt_(int *neqns, int *nsuper, int *xsuper,
	int *xlindx, int *cachsz, int *split)
{
/*
   Version:	   0.4
   Last modified:  May 26, 1995
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ****	  FNSPLT ..... COMPUTE FINE PARTITIONING OF SUPERNODES	   *****
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       this subroutine determines a fine partitioning of supernodes
       when there is a cache available on the machine.	the fine
       partitioning is chosen so that data re-use is maximized.

   INPUT parameters:
       neqns	       -   number of equations.
       nsuper	       -   number of supernodes.
       xsuper	       -   integer array of size (nsuper+1) containing
			   the supernode partitioning.
       xlindx	       -   integer array of size (nsuper+1) containing
			   pointers in the supernode indices.
       cachsz	       -   cache size in kilo bytes.
			   if there is no cache, set cachsz = 0.

   OUTPUT parameters:
       split	       -   integer array of size neqns containing the
			   fine partitioning.

 ***********************************************************************
*/
    int kcol, used, ksup, cache, ncols, width, height, curcol,
	    fstcol, lstcol, nxtblk;

    /* Parameter adjustments */
    --split;
    --xlindx;
    --xsuper;

    /*--------------------------------------------
       COMPUTE THE NUMBER OF 8-BYTE WORDS IN CACHE.
       --------------------------------------------*/
    if (*cachsz <= 0) {
	cache = 2000000000;
    } else {
	cache = (float) (*cachsz) * 1024.f / 8.f * .9f;
    }

    /* ---------------
       INITIALIZATION.
       --------------- */
    for (kcol = 1; kcol <= *neqns; ++kcol) {
	split[kcol] = 0;
    }

    /* ---------------------------
       FOR EACH SUPERNODE KSUP ...
       --------------------------- */
    for (ksup = 1; ksup <= *nsuper; ++ksup) {
	/* -----------------------
	   ... GET SUPERNODE INFO.
	   ----------------------- */
	height = xlindx[ksup + 1] - xlindx[ksup];
	fstcol = xsuper[ksup];
	lstcol = xsuper[ksup + 1] - 1;
	width = lstcol - fstcol + 1;
	nxtblk = fstcol;
	/* --------------------------------------
	   ... UNTIL ALL COLUMNS OF THE SUPERNODE
	       HAVE BEEN PROCESSED ...
	   -------------------------------------- */
	curcol = fstcol - 1;

	do { /* L200: */
	    /* -------------------------------------------
	       ... PLACE THE FIRST COLUMN(S) IN THE CACHE.
	       ------------------------------------------- */
	    ++curcol;
	    if (curcol < lstcol) {
		++curcol;
		ncols = 2;
		used = (height << 2) - 1;
		height += -2;
	    } else {
		ncols = 1;
		used = height * 3;
		--height;
	    }

	    /* --------------------------------------
	       ... WHILE THE CACHE IS NOT FILLED AND
	       THERE ARE COLUMNS OF THE SUPERNODE
	       REMAINING TO BE PROCESSED ...
	       --------------------------------------  L300: */
	    while (used + height < cache && curcol < lstcol) {
		/* --------------------------------
		   ... add another column to cache.
		   -------------------------------- */
		++curcol;
		++ncols;
		used += height;
		--height;
	    }
	    /* -------------------------------------
	       ... record the number of columns that filled the cache.
	       ------------------------------------- */
	    split[nxtblk] = ncols;
	    ++nxtblk;
	    /* --------------------------
	       ... GO PROCESS NEXT BLOCK.
	       -------------------------- */
	} while (curcol < lstcol);
    }

    return 0;
} /* fnsplt_ */

/***********************************************************************
 ***********************************************************************
 */

static int
fntsiz_(int *nsuper, int *xsuper, int *snode,
	int *xlindx, int *lindx, int *tmpsiz)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ******	    FNTSIZ ..... COMPUTE WORK STORAGE SIZE FOR BLKFCT	  ******
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       This subroutine determines the size of the working storage
       required by blkfct().

   INPUT parameters:
       nsuper	       -   number of supernodes.
       xsuper	       -   integer array of size (nsuper+1) containing
			   the supernode partitioning.
       snode	       -   supernode membership.
       (xlindx,lindx)  -   arrays describing the supernodal structure.

   OUTPUT parameters:
       tmpsiz	       -   size of working storage required by blkfct.

 ***********************************************************************
*/
    /* Local variables */
    int i, iend, clen, ksup, bound, ncols, width, tsize, ibegin,
	length, cursup, nxtsup;

    /* Parameter adjustments */
    --lindx;
    --xlindx;
    --snode;
    --xsuper;

    /* returns size of temp array used by blkfct factorization routine.
     * note that the value returned is an estimate, though it is usually
     * tight. */

    /* ----------------------------------------
       compute size of temporary storage vector
       needed by blkfct.
       ---------------------------------------- */
    *tmpsiz = 0;
    for (ksup = *nsuper; ksup >= 1; --ksup) {
	ncols = xsuper[ksup + 1] - xsuper[ksup];
	ibegin = xlindx[ksup] + ncols;
	iend = xlindx[ksup + 1] - 1;
	length = iend - ibegin + 1;
	bound = length * (length + 1) / 2;
	if (bound > *tmpsiz) {
	    cursup = snode[lindx[ibegin]];
	    clen = xlindx[cursup + 1] - xlindx[cursup];
	    width = 0;
	    for (i = ibegin; i <= iend; ++i) {
		nxtsup = snode[lindx[i]];
		if (nxtsup == cursup) {
		    ++width;
		    if (i == iend) {
			if (clen > length) {
			    tsize = length * width - (width - 1) * width / 2;
			    if(*tmpsiz < tsize) *tmpsiz = tsize;
			}
		    }
		} else {
		    if (clen > length) {
			tsize = length * width - (width - 1) * width / 2;
			if(*tmpsiz < tsize) *tmpsiz = tsize;
		    }
		    length -= width;
		    bound = length * (length + 1) / 2;
		    if (bound <= *tmpsiz) {
			goto L500;
		    }
		    width = 1;
		    cursup = nxtsup;
		    clen = xlindx[cursup + 1] - xlindx[cursup];
		}
	    }
	}
L500:
	;
    }

    return 0;
} /* fntsiz_ */

/***********************************************************************
 ***********************************************************************
 */

static int
fsup1_(int *neqns, int *etpar, int *colcnt,
       int *nofsub, int *nsuper, int *snode)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ****************    FSUP1 ..... Find SUPernodes #1    *****************
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       This subroutine is the first of two routines for finding a
       maximal supernode partition.  it returns only the number of
       supernodes nsuper and the supernode membership vector snode(*),
       which is of length neqns.  the vectors of length nsuper are
       computed subsequently by the companion routine fsup2.

   Method and assumptions:
       This routine uses the elimination tree and the factor column
       counts to compute the supernode partition; it also assumes a
       postordering of the elimination tree.

   INPUT parameters:
       (i) neqns       -   number of equations.
       (i) etpar(*)    -   array of length neqns, containing the
			   elimination tree of the postordered matrix.
       (i) colcnt(*)   -   array of length neqns, containing the
			   factor column counts: i.e., the number of
			   nonzero entries in each column of l
			   (including the diagonal entry).

   OUTPUT parameters:
       (i) nofsub      -   number of subscripts.
       (i) nsuper      -   number of supernodes (<= neqns).
       (i) snode(*)    -   array of length neqns for recording
			   supernode membership.

   First created on    January 18, 1992.
   Last updated on     November 11, 1994.

 ***********************************************************************/

    int kcol;

    /* Parameter adjustments */
    --snode;
    --colcnt;
    --etpar;

    /*--------------------------------------------
       Compute the fundamental supernode partition.
       --------------------------------------------*/
    *nsuper = 1;
    snode[1] = 1;
    *nofsub = colcnt[1];
    for (kcol = 2; kcol <= *neqns; ++kcol) {
	if (etpar[kcol - 1] == kcol) {
	    if (colcnt[kcol - 1] == colcnt[kcol] + 1) {
		snode[kcol] = *nsuper;
		continue;
	    }
	}
	++(*nsuper);
	snode[kcol] = *nsuper;
	*nofsub += colcnt[kcol];
    }

    return 0;
} /* fsup1_ */

/************************************************************************/

static int
fsup2_(int *neqns, int *nsuper, int *etpar, int *snode, int *xsuper)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ****************    FSUP2  ..... Find SUPernodes #2   *****************
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       This subroutine is the second of two routines for finding a
       maximal supernode partition.  it's sole purpose is to
       construct the needed vector of length nsuper: xsuper(*).	 the
       first routine fsup1 computes the number of supernodes and the
       supernode membership vector snode(*), which is of length neqns.

   Assumptions:
       this routine assumes a postordering of the elimination tree.  it
       also assumes that the output from fsup1 is available.

   INPUT parameters:
       (i) neqns       -   number of equations.
       (i) nsuper      -   number of supernodes (<= neqns).
       (i) etpar(*)    - _UNUSED_ array of length neqns, containing the
			   elimination tree of the postordered matrix.
       (i) snode(*)    -   array of length neqns for recording
			   supernode membership.

   OUTPUT parameters:
       (i) xsuper(*)   -   array of length nsuper+1, containing the
			   supernode partitioning.

   First created on    January 18, 1992.
   Last updated on     November 22, 1994.

 ***********************************************************************
*/
    int kcol, ksup, lstsup;

    /* Parameter adjustments */
    --xsuper;
    --snode;

    /*-------------------------------------------------
      COMPUTE THE SUPERNODE PARTITION VECTOR XSUPER(*).
      -------------------------------------------------*/
    lstsup = *nsuper + 1;
    for (kcol = *neqns; kcol >= 1; --kcol) {
	ksup = snode[kcol];
	if (ksup != lstsup) {
	    xsuper[lstsup] = kcol + 1;
	    lstsup = ksup;
	}
    }
    xsuper[1] = 1;

    return 0;
} /* fsup2_ */

/************************************************************************/

static int
genmmd_(int *neqns, int *xadj, int *adjncy,
	int *invp, int *perm, int *delta, int *dhead, int *qsize,
	int *llist, int *marker, int *maxint, int *nofsub)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Joseph W.H. Liu

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 --- SPARSPAK-A (ANSI FORTRAN) RELEASE III --- NAME = GENMMD
  (C)  UNIVERSITY OF WATERLOO	JANUARY 1984
 ***********************************************************************
 ***********************************************************************
 ****	  genmmd ..... Multiple Minimum external Degree	    ************
 ***********************************************************************
 ***********************************************************************

     PURPOSE - This routine implements the minimum degree
	algorithm.  it makes use of the implicit representation
	of elimination graphs by quotient graphs, and the
	notion of indistinguishable nodes.  it also implements
	the modifications by multiple elimination and minimum
	external degree.
	---------------------------------------------
	caution - the adjacency vector adjncy will be
	destroyed.
	---------------------------------------------

     INPUT parameters -
	neqns  - number of equations.
	(xadj,adjncy) - the adjacency structure.
	delta  - tolerance value for multiple elimination.
	maxint - maximum machine representable (short) integer
		 (any smaller estimate will do) for marking
		 nodes.

     OUTPUT parameters -
	perm   - the minimum degree ordering.
	invp   - the inverse of perm.
	nofsub - an upper bound on the number of nonzero
		 subscripts for the compressed storage scheme.

     Working parameters -
	dhead  - vector for head of degree lists.
	invp   - used temporarily for degree forward link.
	perm   - used temporarily for degree backward link.
	qsize  - vector for size of supernodes.
	llist  - vector for temporary linked lists.
	marker - a temporary marker vector.

     Program subroutines -
	mmdelm, mmdint, mmdnum, mmdupd.

 ***********************************************************************
*/

    int i, tag, num, mdeg, ehead, mdlmt, mdnode, nextmd;

    /* Parameter adjustments */
    --marker;
    --llist;
    --qsize;
    --dhead;

    if (*neqns <= 0) {
	return 0;
    }

    /* ------------------------------------------------
	INITIALIZATION FOR THE MINIMUM DEGREE ALGORITHM.
	------------------------------------------------ */
    *nofsub = 0;
    mmdint_(neqns, xadj, adjncy, &dhead[1], invp, perm,
	    &qsize[1], &llist[1], &marker[1]);

    /* ----------------------------------------------
	NUM COUNTS THE NUMBER OF ORDERED NODES PLUS 1.
	---------------------------------------------- */
    num = 1;

    /* -----------------------------
	ELIMINATE ALL ISOLATED NODES.
	----------------------------- */
    nextmd = dhead[1];

    while(nextmd > 0) {
	mdnode = nextmd;
	nextmd = invp[mdnode +1];
	marker[mdnode] = *maxint;
	invp[mdnode +1] = -num;
	++num;
    }

    /* L200:
     * ----------------------------------------
	SEARCH FOR NODE OF THE MINIMUM DEGREE.
	MDEG IS THE CURRENT MINIMUM DEGREE;
	TAG IS USED TO FACILITATE MARKING NODES.
	---------------------------------------- */
    if (num > *neqns) {
	goto L1000;
    }
    tag = 1;
    dhead[1] = 0;
    mdeg = 2;

/*  `Outer Loop' : */
L300:
    while (dhead[mdeg] <= 0)
	mdeg++;

    /* -------------------------------------------------
	    USE VALUE OF DELTA TO SET UP MDLMT, WHICH GOVERNS
	    WHEN A DEGREE UPDATE IS TO BE PERFORMED.
	    ------------------------------------------------- */
    mdlmt = mdeg + *delta;
    ehead = 0;

/* `Inner Loop' : */
L500:
    while((mdnode = dhead[mdeg]) <= 0) {
	++mdeg;
	if (mdeg > mdlmt)
	    goto L900;
    }

    /* ----------------------------------------
		REMOVE MDNODE FROM THE DEGREE STRUCTURE.
		---------------------------------------- */
    nextmd = invp[mdnode -1];
    dhead[mdeg] = nextmd;
    if (nextmd > 0) {
	perm[nextmd -1] = -mdeg;
    }
    invp[mdnode -1] = -num;
    *nofsub = *nofsub + mdeg + qsize[mdnode] - 2;
    if (num + qsize[mdnode] > *neqns) {
	goto L1000;
    }
    /* ----------------------------------------------
		ELIMINATE MDNODE AND PERFORM QUOTIENT GRAPH
		TRANSFORMATION.	 RESET TAG VALUE IF NECESSARY.
		---------------------------------------------- */
    ++tag;
    if (tag >= *maxint) {
	tag = 1;
	for (i = 1; i <= *neqns; ++i) {
	    if (marker[i] < *maxint)
		marker[i] = 0;
	}
    }
    mmdelm_(&mdnode, xadj, adjncy, &dhead[1], invp, perm,
	    &qsize[1], &llist[1], &marker[1], maxint, &tag);
    num += qsize[mdnode];
    llist[mdnode] = ehead;
    ehead = mdnode;
    if (*delta >= 0) {
	goto L500;
    }

L900:
    /* -------------------------------------------
	    UPDATE DEGREES OF THE NODES INVOLVED IN THE
	    MINIMUM DEGREE NODES ELIMINATION.
	    ------------------------------------------- */
    if (num > *neqns) {
	goto L1000;
    }
    mmdupd_(&ehead, neqns, xadj, adjncy, delta, &mdeg, &dhead[1], invp,
	    perm, &qsize[1], &llist[1], &marker[1], maxint, &tag);
    goto L300;

L1000:
    mmdnum_(neqns, perm, invp, &qsize[1]);
    return 0;

} /* genmmd_ */

/*************************************************************************/

double F77_SUB(gtimer)(void)
{
/* Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory
*/
  extern double F77_CALL(extetime) (float *);

    static float vec[2];

    /* --------------------------
       FOR IBM RS/6000 ...
       INTEGER	   MCLOCK
       GTIMER = MCLOCK()/100.0
       --------------------------
       FOR MOST BERKELEY UNIX ... */

    return  F77_CALL(extetime) (vec);
    /* --------------------------
       FOR CRAY ...
       REAL	   SECOND
       GTIMER = SECOND()
       -------------------------- */

} /* gtimer_

 ***********************************************************************
 ***********************************************************************
 */
static int
igathr_(int *klen, int *lindx, int *indmap, int *relind)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ******		IGATHR .... INTEGER GATHER OPERATION	  **************
 ***********************************************************************
 ***********************************************************************

     PURPOSE - THIS ROUTINE PERFORMS A STANDARD INTEGER GATHER
	       OPERATION.

     INPUT PARAMETERS -
	KLEN   - LENGTH OF THE LIST OF GLOBAL INDICES.
	LINDX  - LIST OF GLOBAL INDICES.
	INDMAP - INDEXED BY GLOBAL INDICES, IT CONTAINS THE
		 REQUIRED RELATIVE INDICES.

     OUTPUT PARAMETERS -
	RELIND - LIST RELATIVE INDICES.

 ***********************************************************************
 */
    int i;

/* ***********************************************************************

 DIR$ IVDEP
     Parameter adjustments */
    --indmap;

    for (i = 0; i < *klen; ++i) {
	relind[i] = indmap[lindx[i]];
    }
    return 0;
} /* igathr_

 ***********************************************************************
 ***********************************************************************
 */
int
F77_SUB(inpnv)(int *neqns, int *xadjf, int *adjf,
	       double *anzf, int *perm, int *invp, int *nsuper,
	       int *xsuper, int *xlindx, int *lindx, int *xlnz,
	       double *lnz, int *offset)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************

     ------------------------------------------------------
     INPUT NUMERICAL VALUES INTO SPARSE DATA STRUCTURES ...
     ------------------------------------------------------
  */
    /* Local variables */
    static int i, j, ii, jlen, oldj, last, jsuper;

    /* Parameter adjustments */
    --offset;
    --lnz;
    --xlnz;
    --lindx;
    --xlindx;
    --xsuper;
    --invp;
    --perm;
    --anzf;
    --adjf;
    --xadjf;

    /* Function Body */
    for (jsuper = 1; jsuper <= *nsuper; ++jsuper) {

	/* ----------------------------------------
	   FOR EACH SUPERNODE, DO THE FOLLOWING ...
	   ----------------------------------------

	   -----------------------------------------------
	   FIRST GET OFFSET TO FACILITATE NUMERICAL INPUT.
	   ----------------------------------------------- */
	jlen = xlindx[jsuper + 1] - xlindx[jsuper];
	for (ii = xlindx[jsuper]; ii < xlindx[jsuper + 1]; ++ii) {
	    i = lindx[ii];
	    --jlen;
	    offset[i] = jlen;
	}

	for (j = xsuper[jsuper]; j < xsuper[jsuper + 1]; ++j) {
	    /* -----------------------------------------
	       FOR EACH COLUMN IN THE CURRENT SUPERNODE,
	       FIRST INITIALIZE THE DATA STRUCTURE.
	       ----------------------------------------- */
	    for (ii = xlnz[j]; ii < xlnz[j + 1]; ++ii) {
		lnz[ii] = 0.f;
	    }

	    /* -----------------------------------
	       NEXT INPUT THE INDIVIDUAL NONZEROS.
	       ----------------------------------- */
	    oldj = perm[j];
	    last = xlnz[j + 1] - 1;
	    for (ii = xadjf[oldj]; ii < xadjf[oldj + 1]; ++ii) {
		i = invp[adjf[ii]];
		if (i >= j) {
		    lnz[last - offset[i]] = anzf[ii];
		}
	    }
	}

    }
    return 0;
} /* inpnv_

 ***********************************************************************
 ***********************************************************************
 */
static int
invinv_(int *neqns, int *invp, int *invp2, int *perm)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Joseph W.H. Liu

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ***********	 INVINV ..... CONCATENATION OF TWO INVP	    ************
 ***********************************************************************
 ***********************************************************************

   WRITTEN BY JOSEPH LIU (JUL 17, 1985)

   PURPOSE:
       TO PERFORM THE MAPPING OF
	   ORIGINAL-INVP --> INTERMEDIATE-INVP --> NEW INVP
       AND THE RESULTING ORDERING REPLACES INVP.  THE NEW PERMUTATION
       VECTOR PERM IS ALSO COMPUTED.

   INPUT PARAMETERS:
       NEQNS	       -   NUMBER OF EQUATIONS.
       INVP2	       -   THE SECOND INVERSE PERMUTATION VECTOR.

   UPDATED PARAMETERS:
       INVP	       -   THE FIRST INVERSE PERMUTATION VECTOR.  ON
			   OUTPUT, IT CONTAINS THE NEW INVERSE
			   PERMUTATION.

   OUTPUT PARAMETER:
       PERM	       -   NEW PERMUTATION VECTOR (CAN BE THE SAME AS
			   INVP2).

 ***********************************************************************
 */
    /* Local variables */
    static int i, node, interm;


/* ***********************************************************************

     Parameter adjustments */
    --perm;
    --invp2;
    --invp;

    /* Function Body */
    for (i = 1; i <= *neqns; ++i) {
	interm = invp[i];
	invp[i] = invp2[interm];
    }

    for (i = 1; i <= *neqns; ++i) {
	node = invp[i];
	perm[node] = i;
    }

    return 0;
} /* invinv_

 ***********************************************************************
 ***********************************************************************
 */
static int
ldindx_(int *jlen, int *lindx, int *indmap)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ******		LDINDX .... LOAD INDEX VECTOR		  **************
 ***********************************************************************
 ***********************************************************************

     PURPOSE - THIS ROUTINE COMPUTES THE SECOND INDEX VECTOR
	       USED TO IMPLEMENT THE DOUBLY-INDIRECT SAXPY-LIKE
	       LOOPS THAT ALLOW US TO ACCUMULATE UPDATE
	       COLUMNS DIRECTLY INTO FACTOR STORAGE.

     INPUT PARAMETERS -
	JLEN   - LENGTH OF THE FIRST COLUMN OF THE SUPERNODE,
		 INCLUDING THE DIAGONAL ENTRY.
	LINDX  - THE OFF-DIAGONAL ROW INDICES OF THE SUPERNODE,
		 I.E., THE ROW INDICES OF THE NONZERO ENTRIES
		 LYING BELOW THE DIAGONAL ENTRY OF THE FIRST
		 COLUMN OF THE SUPERNODE.

     OUTPUT PARAMETERS -
	INDMAP - THIS INDEX VECTOR MAPS EVERY GLOBAL ROW INDEX
		 OF NONZERO ENTRIES IN THE FIRST COLUMN OF THE
		 SUPERNODE TO ITS POSITION IN THE INDEX LIST
		 RELATIVE TO THE LAST INDEX IN THE LIST.  MORE
		 PRECISELY, IT GIVES THE DISTANCE OF EACH INDEX
		 FROM THE LAST INDEX IN THE LIST.

 ***********************************************************************
 */
    /* Local variables */
    static int j, jsub, curlen;


/* ***********************************************************************

     -----------
     PARAMETERS.
     -----------

     ----------------
     LOCAL VARIABLES.
     ----------------

 ***********************************************************************

     Parameter adjustments */
    --indmap;
    --lindx;

    /* Function Body */
    curlen = *jlen;
    for (j = 1; j <= *jlen; ++j) {
	jsub = lindx[j];
	--curlen;
	indmap[jsub] = curlen;
    }
    return 0;
} /* ldindx_

 ***********************************************************************
 ***********************************************************************

/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************

     -----------------------------------------
     GATHER STATISTICS ABOUT FACTORIZATION ...
     -----------------------------------------

/*  Subroutine *\/ int lstats_(int *nsuper, int *xsuper, int * */
/*	xlindx, int *lindx, int *xlnz, int *tmpsiz, int * */
/*	outunt) */

/* --- omitted after  f2c --- on purpose -- */


/***********************************************************************
 ***********************************************************************
 */
static int
mmdelm_(int *mdnode, int *xadj, int *adjncy,
	    int *dhead, int *dforw, int *dbakw, int *qsize,
	    int *llist, int *marker, int *maxint, int *tag)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Joseph W.H. Liu

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 --- SPARSPAK-A (ANSI FORTRAN) RELEASE III --- NAME = MMDELM
  (C)  UNIVERSITY OF WATERLOO	JANUARY 1984
 ***********************************************************************
 ***********************************************************************
 **	MMDELM ..... MULTIPLE MINIMUM DEGREE ELIMINATION     ***********
 ***********************************************************************
 ***********************************************************************

     PURPOSE - THIS ROUTINE ELIMINATES THE NODE MDNODE OF
	MINIMUM DEGREE FROM THE ADJACENCY STRUCTURE, WHICH
	IS STORED IN THE QUOTIENT GRAPH FORMAT.	 IT ALSO
	TRANSFORMS THE QUOTIENT GRAPH REPRESENTATION OF THE
	ELIMINATION GRAPH.

     INPUT PARAMETERS -
	MDNODE - NODE OF MINIMUM DEGREE.
	MAXINT - ESTIMATE OF MAXIMUM REPRESENTABLE (SHORT)
		 INTEGER.
	TAG    - TAG VALUE.

     UPDATED PARAMETERS -
	(XADJ,ADJNCY) - UPDATED ADJACENCY STRUCTURE.
	(DHEAD,DFORW,DBAKW) - DEGREE DOUBLY LINKED STRUCTURE.
	QSIZE  - SIZE OF SUPERNODE.
	MARKER - MARKER VECTOR.
	LLIST  - TEMPORARY LINKED LIST OF ELIMINATED NABORS.

 ***********************************************************************
 */
    /* Local variables */
    static int i, j, npv, node, link, rloc, rlmt, nabor, rnode, elmnt,
	    xqnbr, istop, jstop, istrt, jstrt, nxnode, pvnode, nqnbrs;


/* ***********************************************************************


 ***********************************************************************

	-----------------------------------------------
	FIND REACHABLE SET AND PLACE IN DATA STRUCTURE.
	-----------------------------------------------
     Parameter adjustments */
    --marker;
    --llist;
    --qsize;
    --dbakw;
    --dforw;
    --dhead;
    --adjncy;
    --xadj;

    /* Function Body */
    marker[*mdnode] = *tag;
    istrt = xadj[*mdnode];
    istop = xadj[*mdnode + 1] - 1;
    /* -------------------------------------------------------
	ELMNT POINTS TO THE BEGINNING OF THE LIST OF ELIMINATED
	NABORS OF MDNODE, AND RLOC GIVES THE STORAGE LOCATION
	FOR THE NEXT REACHABLE NODE.
	------------------------------------------------------- */
    elmnt = 0;
    rloc = istrt;
    rlmt = istop;
    for (i = istrt; i <= istop; ++i) {
	nabor = adjncy[i];
	if (nabor == 0) {
	    goto L300;
	}
	if (marker[nabor] >= *tag) {
	    goto L200;
	}
	marker[nabor] = *tag;
	if (dforw[nabor] < 0) {
	    goto L100;
	}
	adjncy[rloc] = nabor;
	++rloc;
	goto L200;
L100:
	llist[nabor] = elmnt;
	elmnt = nabor;
L200:
	;
    }
L300:
    /* -----------------------------------------------------
	    MERGE WITH REACHABLE NODES FROM GENERALIZED ELEMENTS.
	    ----------------------------------------------------- */
    if (elmnt <= 0) {
	goto L1000;
    }
    adjncy[rlmt] = -elmnt;
    link = elmnt;
L400:
    jstrt = xadj[link];
    jstop = xadj[link + 1] - 1;
    for (j = jstrt; j <= jstop; ++j) {
	node = adjncy[j];
	link = -node;
	if (node < 0) {
	    goto L400;
	} else if (node == 0) {
	    goto L900;
	} else {
	    goto L500;
	}
L500:
	if (marker[node] >= *tag || dforw[node] < 0) {
	    goto L800;
	}
	marker[node] = *tag;
	/* ---------------------------------
			    USE STORAGE FROM ELIMINATED NODES
			    IF NECESSARY.
			    --------------------------------- */
L600:
	if (rloc < rlmt) {
	    goto L700;
	}
	link = -adjncy[rlmt];
	rloc = xadj[link];
	rlmt = xadj[link + 1] - 1;
	goto L600;
L700:
	adjncy[rloc] = node;
	++rloc;
L800:
	;
    }
L900:
    elmnt = llist[elmnt];
    goto L300;
L1000:
    if (rloc <= rlmt) {
	adjncy[rloc] = 0;
    }
    /* --------------------------------------------------------
	FOR EACH NODE IN THE REACHABLE SET, DO THE FOLLOWING ...
	-------------------------------------------------------- */
    link = *mdnode;
L1100:
    istrt = xadj[link];
    istop = xadj[link + 1] - 1;
    for (i = istrt; i <= istop; ++i) {
	rnode = adjncy[i];
	link = -rnode;
	if (rnode < 0) {
	    goto L1100;
	} else if (rnode == 0) {
	    goto L1800;
	} else {
	    goto L1200;
	}
L1200:
	/* --------------------------------------------
		IF RNODE IS IN THE DEGREE LIST STRUCTURE ...
		-------------------------------------------- */
	pvnode = dbakw[rnode];
	if (pvnode == 0 || pvnode == -(*maxint)) {
	    goto L1300;
	}
	/* -------------------------------------
		    THEN REMOVE RNODE FROM THE STRUCTURE.
		    ------------------------------------- */
	nxnode = dforw[rnode];
	if (nxnode > 0) {
	    dbakw[nxnode] = pvnode;
	}
	if (pvnode > 0) {
	    dforw[pvnode] = nxnode;
	}
	npv = -pvnode;
	if (pvnode < 0) {
	    dhead[npv] = nxnode;
	}
L1300:
	/* ----------------------------------------
		PURGE INACTIVE QUOTIENT NABORS OF RNODE.
		---------------------------------------- */
	jstrt = xadj[rnode];
	jstop = xadj[rnode + 1] - 1;
	xqnbr = jstrt;
	for (j = jstrt; j <= jstop; ++j) {
	    nabor = adjncy[j];
	    if (nabor == 0) {
		goto L1500;
	    }
	    if (marker[nabor] >= *tag) {
		goto L1400;
	    }
	    adjncy[xqnbr] = nabor;
	    ++xqnbr;
L1400:
	    ;
	}
L1500:
	/* ----------------------------------------
		IF NO ACTIVE NABOR AFTER THE PURGING ...
		---------------------------------------- */
	nqnbrs = xqnbr - jstrt;
	if (nqnbrs > 0) {
	    goto L1600;
	}
	/* -----------------------------
		    THEN MERGE RNODE WITH MDNODE.
		    ----------------------------- */
	qsize[*mdnode] += qsize[rnode];
	qsize[rnode] = 0;
	marker[rnode] = *maxint;
	dforw[rnode] = -(*mdnode);
	dbakw[rnode] = -(*maxint);
	goto L1700;
L1600:
	/* --------------------------------------
		ELSE FLAG RNODE FOR DEGREE UPDATE, AND
		ADD MDNODE AS A NABOR OF RNODE.
		-------------------------------------- */
	dforw[rnode] = nqnbrs + 1;
	dbakw[rnode] = 0;
	adjncy[xqnbr] = *mdnode;
	++xqnbr;
	if (xqnbr <= jstop) {
	    adjncy[xqnbr] = 0;
	}

L1700:
	;
    }
L1800:
    return 0;

} /* mmdelm_

 ***********************************************************************
 ***********************************************************************
 */
static int
mmdint_(int *neqns, int *xadj, int *adjncy,
	    int *dhead, int *dforw, int *dbakw, int *qsize,
	    int *llist, int *marker)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Joseph W.H. Liu

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 --- SPARSPAK-A (ANSI FORTRAN) RELEASE III --- NAME = MMDINT
  (C)  UNIVERSITY OF WATERLOO	JANUARY 1984
 ***********************************************************************
 ***********************************************************************
 ***	 MMDINT ..... MULT MINIMUM DEGREE INITIALIZATION     ***********
 ***********************************************************************
 ***********************************************************************

     PURPOSE - THIS ROUTINE PERFORMS INITIALIZATION FOR THE
	MULTIPLE ELIMINATION VERSION OF THE MINIMUM DEGREE
	ALGORITHM.

     INPUT PARAMETERS -
	NEQNS  - NUMBER OF EQUATIONS.
	(XADJ,ADJNCY) - ADJACENCY STRUCTURE.

     OUTPUT PARAMETERS -
	(DHEAD,DFORW,DBAKW) - DEGREE DOUBLY LINKED STRUCTURE.
	QSIZE  - SIZE OF SUPERNODE (INITIALIZED TO ONE).
	LLIST  - LINKED LIST.
	MARKER - MARKER VECTOR.

 ***********************************************************************
 */
    /* Local variables */
    static int ndeg, node, fnode;


/* ***********************************************************************


 ***********************************************************************

     Parameter adjustments */
    --marker;
    --llist;
    --qsize;
    --dbakw;
    --dforw;
    --dhead;
    --adjncy;
    --xadj;

    /* Function Body */
    for (node = 1; node <= *neqns; ++node) {
	dhead[node] = 0;
	qsize[node] = 1;
	marker[node] = 0;
	llist[node] = 0;
    }
    /* ------------------------------------------
	INITIALIZE THE DEGREE DOUBLY LINKED LISTS.
	------------------------------------------ */
    for (node = 1; node <= *neqns; ++node) {
	ndeg = xadj[node + 1] - xadj[node] + 1;
	fnode = dhead[ndeg];
	dforw[node] = fnode;
	dhead[ndeg] = node;
	if (fnode > 0) {
	    dbakw[fnode] = node;
	}
	dbakw[node] = -ndeg;
    }
    return 0;

} /* mmdint_

 ***********************************************************************
 ***********************************************************************
 */
static int
mmdnum_(int *neqns, int *perm, int *invp, int *qsize)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Joseph W.H. Liu

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 --- SPARSPAK-A (ANSI FORTRAN) RELEASE III --- NAME = MMDNUM
  (C)  UNIVERSITY OF WATERLOO	JANUARY 1984
 ***********************************************************************
 ***********************************************************************
 *****	   MMDNUM ..... MULTI MINIMUM DEGREE NUMBERING	   *************
 ***********************************************************************
 ***********************************************************************

     PURPOSE - THIS ROUTINE PERFORMS THE FINAL STEP IN
	PRODUCING THE PERMUTATION AND INVERSE PERMUTATION
	VECTORS IN THE MULTIPLE ELIMINATION VERSION OF THE
	MINIMUM DEGREE ORDERING ALGORITHM.

     INPUT PARAMETERS -
	NEQNS  - NUMBER OF EQUATIONS.
	QSIZE  - SIZE OF SUPERNODES AT ELIMINATION.

     UPDATED PARAMETERS -
	INVP   - INVERSE PERMUTATION VECTOR.  ON INPUT,
		 IF QSIZE(NODE)=0, THEN NODE HAS BEEN MERGED
		 INTO THE NODE -INVP(NODE); OTHERWISE,
		 -INVP(NODE) IS ITS INVERSE LABELLING.

     OUTPUT PARAMETERS -
	PERM   - THE PERMUTATION VECTOR.

 ***********************************************************************
 */
    /* Local variables */
    static int num, node, root, nextf, father, nqsize;


/* ***********************************************************************

     Parameter adjustments */
    --qsize;
    --invp;
    --perm;

    /* Function Body */
    for (node = 1; node <= *neqns; ++node) {
	nqsize = qsize[node];
	if (nqsize <= 0) {
	    perm[node] = invp[node];
	}
	if (nqsize > 0) {
	    perm[node] = -invp[node];
	}
    }
    /* ------------------------------------------------------
	FOR EACH NODE WHICH HAS BEEN MERGED, DO THE FOLLOWING.
	------------------------------------------------------ */
    for (node = 1; node <= *neqns; ++node) {
	if (perm[node] > 0) {
	    goto L500;
	}
	/* -----------------------------------------
		TRACE THE MERGED TREE UNTIL ONE WHICH HAS
		NOT BEEN MERGED, CALL IT ROOT.
		----------------------------------------- */
	father = node;
L200:
	if (perm[father] > 0) {
	    goto L300;
	}
	father = -perm[father];
	goto L200;
L300:
	/* -----------------------
		NUMBER NODE AFTER ROOT.
		----------------------- */
	root = father;
	num = perm[root] + 1;
	invp[node] = -num;
	perm[root] = num;
	/* ------------------------
		SHORTEN THE MERGED TREE.
		------------------------ */
	father = node;
L400:
	nextf = -perm[father];
	if (nextf <= 0) {
	    goto L500;
	}
	perm[father] = -root;
	father = nextf;
	goto L400;
L500:
	;
    }
    /* ----------------------
	READY TO COMPUTE PERM.
	---------------------- */
    for (node = 1; node <= *neqns; ++node) {
	num = -invp[node];
	invp[node] = num;
	perm[num] = node;
    }
    return 0;

} /* mmdnum_

 ***********************************************************************
 ***********************************************************************
 */
static int
mmdupd_(int *ehead, int *neqns, int *xadj,
	    int *adjncy, int *delta, int *mdeg, int *dhead,
	    int *dforw, int *dbakw, int *qsize, int *llist,
	    int *marker, int *maxint, int *tag)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Joseph W.H. Liu

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 --- SPARSPAK-A (ANSI FORTRAN) RELEASE III --- NAME = MMDUPD
  (C)  UNIVERSITY OF WATERLOO	JANUARY 1984
 ***********************************************************************
 ***********************************************************************
 *****	   MMDUPD ..... MULTIPLE MINIMUM DEGREE UPDATE	   *************
 ***********************************************************************
 ***********************************************************************

     PURPOSE - THIS ROUTINE UPDATES THE DEGREES OF NODES
	AFTER A MULTIPLE ELIMINATION STEP.

     INPUT PARAMETERS -
	EHEAD  - THE BEGINNING OF THE LIST OF ELIMINATED
		 NODES (I.E., NEWLY FORMED ELEMENTS).
	NEQNS  - NUMBER OF EQUATIONS.
	(XADJ,ADJNCY) - ADJACENCY STRUCTURE.
	DELTA  - TOLERANCE VALUE FOR MULTIPLE ELIMINATION.
	MAXINT - MAXIMUM MACHINE REPRESENTABLE (SHORT)
		 INTEGER.

     UPDATED PARAMETERS -
	MDEG   - NEW MINIMUM DEGREE AFTER DEGREE UPDATE.
	(DHEAD,DFORW,DBAKW) - DEGREE DOUBLY LINKED STRUCTURE.
	QSIZE  - SIZE OF SUPERNODE.
	LLIST  - WORKING LINKED LIST.
	MARKER - MARKER VECTOR FOR DEGREE UPDATE.
	TAG    - TAG VALUE.

 ***********************************************************************
 */
    /* Local variables */
    static int i, j, iq2, deg, deg0, node, mtag, link, mdeg0, enode,

	    fnode, nabor, elmnt, istop, jstop, q2head, istrt, jstrt, qxhead;


/* ***********************************************************************


 ***********************************************************************

     Parameter adjustments */
    --marker;
    --llist;
    --qsize;
    --dbakw;
    --dforw;
    --dhead;
    --adjncy;
    --xadj;

    /* Function Body */
    mdeg0 = *mdeg + *delta;
    elmnt = *ehead;
L100:
    /* -------------------------------------------------------
	    FOR EACH OF THE NEWLY FORMED ELEMENT, DO THE FOLLOWING.
	    (RESET TAG VALUE IF NECESSARY.)
	    ------------------------------------------------------- */
    if (elmnt <= 0) {
	return 0;
    }
    mtag = *tag + mdeg0;
    if (mtag < *maxint) {
	goto L300;
    }
    *tag = 1;
    for (i = 1; i <= *neqns; ++i) {
	if (marker[i] < *maxint) {
	    marker[i] = 0;
	}
    }
    mtag = *tag + mdeg0;
L300:
    /* ---------------------------------------------
	    CREATE TWO LINKED LISTS FROM NODES ASSOCIATED
	    WITH ELMNT: ONE WITH TWO NABORS (Q2HEAD) IN
	    ADJACENCY STRUCTURE, AND THE OTHER WITH MORE
	    THAN TWO NABORS (QXHEAD).  ALSO COMPUTE DEG0,
	    NUMBER OF NODES IN THIS ELEMENT.
	    --------------------------------------------- */
    q2head = 0;
    qxhead = 0;
    deg0 = 0;
    link = elmnt;
L400:
    istrt = xadj[link];
    istop = xadj[link + 1] - 1;
    for (i = istrt; i <= istop; ++i) {
	enode = adjncy[i];
	link = -enode;
	if (enode < 0) {
	    goto L400;
	} else if (enode == 0) {
	    goto L800;
	} else {
	    goto L500;
	}

L500:
	if (qsize[enode] == 0) {
	    goto L700;
	}
	deg0 += qsize[enode];
	marker[enode] = mtag;
	/* ----------------------------------
			IF ENODE REQUIRES A DEGREE UPDATE,
			THEN DO THE FOLLOWING.
			---------------------------------- */
	if (dbakw[enode] != 0) {
	    goto L700;
	}
	/* ---------------------------------------
			    PLACE EITHER IN QXHEAD OR Q2HEAD LISTS.
			    --------------------------------------- */
	if (dforw[enode] == 2) {
	    goto L600;
	}
	llist[enode] = qxhead;
	qxhead = enode;
	goto L700;
L600:
	llist[enode] = q2head;
	q2head = enode;
L700:
	;
    }
L800:
    /* --------------------------------------------
	    FOR EACH ENODE IN Q2 LIST, DO THE FOLLOWING.
	    -------------------------------------------- */
    enode = q2head;
    iq2 = 1;
L900:
    if (enode <= 0) {
	goto L1500;
    }
    if (dbakw[enode] != 0) {
	goto L2200;
    }
    ++(*tag);
    deg = deg0;
    /* ------------------------------------------
		    IDENTIFY THE OTHER ADJACENT ELEMENT NABOR.
		    ------------------------------------------ */
    istrt = xadj[enode];
    nabor = adjncy[istrt];
    if (nabor == elmnt) {
	nabor = adjncy[istrt + 1];
    }
    /* ------------------------------------------------
		    IF NABOR IS UNELIMINATED, INCREASE DEGREE COUNT.
		    ------------------------------------------------ */
    link = nabor;
    if (dforw[nabor] < 0) {
	goto L1000;
    }
    deg += qsize[nabor];
    goto L2100;
L1000:
    /* --------------------------------------------
			OTHERWISE, FOR EACH NODE IN THE 2ND ELEMENT,
			DO THE FOLLOWING.
			-------------------------------------------- */
    istrt = xadj[link];
    istop = xadj[link + 1] - 1;
    for (i = istrt; i <= istop; ++i) {
	node = adjncy[i];
	link = -node;
	if (node == enode) {
	    goto L1400;
	}
	if (node < 0) {
	    goto L1000;
	} else if (node == 0) {
	    goto L2100;
	} else {
	    goto L1100;
	}

L1100:
	if (qsize[node] == 0) {
	    goto L1400;
	}
	if (marker[node] >= *tag) {
	    goto L1200;
	}
	/* -------------------------------------
				CASE WHEN NODE IS NOT YET CONSIDERED.
				------------------------------------- */
	marker[node] = *tag;
	deg += qsize[node];
	goto L1400;
L1200:
	/* ----------------------------------------
			    CASE WHEN NODE IS INDISTINGUISHABLE FROM
			    ENODE.  MERGE THEM INTO A NEW SUPERNODE.
			    ---------------------------------------- */
	if (dbakw[node] != 0) {
	    goto L1400;
	}
	if (dforw[node] != 2) {
	    goto L1300;
	}
	qsize[enode] += qsize[node];
	qsize[node] = 0;
	marker[node] = *maxint;
	dforw[node] = -enode;
	dbakw[node] = -(*maxint);
	goto L1400;
L1300:
	/* --------------------------------------
			    CASE WHEN NODE IS OUTMATCHED BY ENODE.
			    -------------------------------------- */
	if (dbakw[node] == 0) {
	    dbakw[node] = -(*maxint);
	}
L1400:
	;
    }
    goto L2100;
L1500:
    /* ------------------------------------------------
		FOR EACH ENODE IN THE QX LIST, DO THE FOLLOWING.
		------------------------------------------------ */
    enode = qxhead;
    iq2 = 0;
L1600:
    if (enode <= 0) {
	goto L2300;
    }
    if (dbakw[enode] != 0) {
	goto L2200;
    }
    ++(*tag);
    deg = deg0;
    /* ---------------------------------
			FOR EACH UNMARKED NABOR OF ENODE,
			DO THE FOLLOWING.
			--------------------------------- */
    istrt = xadj[enode];
    istop = xadj[enode + 1] - 1;
    for (i = istrt; i <= istop; ++i) {
	nabor = adjncy[i];
	if (nabor == 0) {
	    goto L2100;
	}
	if (marker[nabor] >= *tag) {
	    goto L2000;
	}
	marker[nabor] = *tag;
	link = nabor;
	/* ------------------------------
				IF UNELIMINATED, INCLUDE IT IN
				DEG COUNT.
				------------------------------ */
	if (dforw[nabor] < 0) {
	    goto L1700;
	}
	deg += qsize[nabor];
	goto L2000;
L1700:
	/* -------------------------------
				    IF ELIMINATED, INCLUDE UNMARKED
				    NODES IN THIS ELEMENT INTO THE
				    DEGREE COUNT.
				    ------------------------------- */
	jstrt = xadj[link];
	jstop = xadj[link + 1] - 1;
	for (j = jstrt; j <= jstop; ++j) {
	    node = adjncy[j];
	    link = -node;
	    if (node < 0) {
		goto L1700;
	    } else if (node == 0) {
		goto L2000;
	    } else {
		goto L1800;
	    }

L1800:
	    if (marker[node] >= *tag) {
		goto L1900;
	    }
	    marker[node] = *tag;
	    deg += qsize[node];
L1900:
	    ;
	}
L2000:
	;
    }
L2100:
    /* -------------------------------------------
		    UPDATE EXTERNAL DEGREE OF ENODE IN DEGREE
		    STRUCTURE, AND MDEG (MIN DEG) IF NECESSARY.
		    ------------------------------------------- */
    deg = deg - qsize[enode] + 1;
    fnode = dhead[deg];
    dforw[enode] = fnode;
    dbakw[enode] = -deg;
    if (fnode > 0) {
	dbakw[fnode] = enode;
    }
    dhead[deg] = enode;
    if (deg < *mdeg) {
	*mdeg = deg;
    }
L2200:
    /* ----------------------------------
		    GET NEXT ENODE IN CURRENT ELEMENT.
		    ---------------------------------- */
    enode = llist[enode];
    if (iq2 == 1) {
	goto L900;
    }
    goto L1600;
L2300:
    /* -----------------------------
	    GET NEXT ELEMENT IN THE LIST.
	    ----------------------------- */
    *tag = mtag;
    elmnt = llist[elmnt];
    goto L100;

} /* mmdupd_

 ***********************************************************************
 ***********************************************************************
 */

static int
mmpy_(int *m, int *n, int *q, int *split,
      int *xpnt, double *x, double *y, int *ldy, S_fp mmpyn)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 **************	    MMpy  .... MATRIX-MATRIX Multiply	  **************
 ***********************************************************************
 ***********************************************************************

   PURPOSE -
       This routine performs a matrix-matrix multiply, y = y + xa,
       assuming data structures used in some of our sparse cholesky
       codes.

   INPUT parameters -
       m	       -   number of rows in x and in y.
       n	       -   number of columns in x and number of rows
			   in a.
       q	       -   number of columns in a and y.
       split(*)	       -   block partitioning of x.
       xpnt(*)	       -   xpnt(j+1) points one location beyond the
			   end of the j-th column of x.	 xpnt is also
			   used to access the rows of a.
       x(*)	       -   contains the columns of x and the rows of a.
       ldy	       -   length of first column of y.
       mmpyn	       -   external routine: matrix-matrix multiply,
			   with level n loop unrolling.

   UPDATED parameters -
       y(*)	       -   on output, y = y + ax.

 ***********************************************************************
 */
    int blk, fstcol;

    for(fstcol = 0, blk = 0; fstcol < *n; blk++) {
	int nn = split[blk];
	(*mmpyn)(m, &nn, q, &xpnt[fstcol], x, y, ldy);
	fstcol += nn;
    }
    return 0;

} /* mmpy_ */

/***********************************************************************
 ***********************************************************************
 */
int
F77_SUB(mmpy1)(int *m, int *n, int *q, int *xpnt,
	       double *x, double *y, int *ldy)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 *************	   MMPY1  .... MATRIX-MATRIX MULTIPLY	  **************
 ***********************************************************************
 ***********************************************************************

   PURPOSE -
       THIS ROUTINE PERFORMS A MATRIX-MATRIX MULTIPLY, Y = Y + XA,
       ASSUMING DATA STRUCTURES USED IN SOME OF OUR SPARSE CHOLESKY
       CODES.

       LOOP UNROLLING: LEVEL 1

   INPUT PARAMETERS -
       M	       -   NUMBER OF ROWS IN X AND IN Y.
       N	       -   NUMBER OF COLUMNS IN X AND NUMBER OF ROWS
			   IN A.
       Q	       -   NUMBER OF COLUMNS IN A AND Y.
       XPNT(*)	       -   XPNT(J+1) POINTS ONE LOCATION BEYOND THE
			   END OF THE J-TH COLUMN OF X.	 XPNT IS ALSO
			   USED TO ACCESS THE ROWS OF A.
       X(*)	       -   CONTAINS THE COLUMNS OF X AND THE ROWS OF A.
       LDY	       -   LENGTH OF FIRST COLUMN OF Y.

   UPDATED PARAMETERS -
       Y(*)	       -   ON OUTPUT, Y = Y + AX.

 ***********************************************************************
 */
    /* Local variables */
    int mm, ycol, leny, iylast;

    /* Parameter adjustments */
    --x;

    mm = *m;
    iylast = 0;
    leny = *ldy;
    /* ------------------------------------
       to compute each column ycol of y ...
       ------------------------------------ */
    for (ycol = 1; ycol <= *q; ++ycol) {
	int iystrt = iylast, xcol;
	int iystop = iystrt + mm;
	iylast += leny;
	/* --------------------------------------------------
	   ... perform the approprate matrix vector multiply: x * a(*,ycol).
	   -------------------------------------------------- */
	for (xcol = 0; xcol < *n; xcol++) {
	    int iy, i1 = xpnt[xcol + 1] - mm;
	    double a1 = -x[i1];
	    for (iy = iystrt; iy < iystop; ++iy) {
		y[iy] += a1 * x[i1];
		++i1;
	    }
	}
	--mm;
	--leny;
    }

    return 0;
} /* mmpy1 */

/* ***********************************************************************
 */
int
F77_SUB(mmpy2)(int *m, int *n, int *q, int *xpnt,
	       double *x, double *y, int *ldy)
{
/*
   Version:	   0.4
   Last modified:  May 26, 1995
   Authors:	   Esmond G. Ng, Barry W. Peyton, and Guodong Zhang

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 *************	   MMPY2  .... MATRIX-MATRIX MULTIPLY	  **************
 ***********************************************************************
 ***********************************************************************

   PURPOSE -
       THIS ROUTINE PERFORMS A MATRIX-MATRIX MULTIPLY, Y = Y + XA,
       ASSUMING DATA STRUCTURES USED IN SOME OF OUR SPARSE CHOLESKY
       CODES.

       LOOP UNROLLING: LEVEL 2 UPDATING TWO COLUMNS AT A TIME

   INPUT PARAMETERS -
       M	       -   NUMBER OF ROWS IN X AND IN Y.
       N	       -   NUMBER OF COLUMNS IN X AND NUMBER OF ROWS
			   IN A.
       Q	       -   NUMBER OF COLUMNS IN A AND Y.
       XPNT(*)	       -   XPNT(J+1) POINTS ONE LOCATION BEYOND THE
			   END OF THE J-TH COLUMN OF X.	 XPNT IS ALSO
			   USED TO ACCESS THE ROWS OF A.
       X(*)	       -   CONTAINS THE COLUMNS OF X AND THE ROWS OF A.
       LDY	       -   LENGTH OF FIRST COLUMN OF Y.

   UPDATED PARAMETERS -
       Y(*)	       -   ON OUTPUT, Y = Y + AX.

 ***********************************************************************
 */
    /* Local variables */
    static int i, j, k;
    static double a1, a2, b1, b2;
    static int i1, i2;
    static double a9, y1, y2, a10;
    static int mm, qq, leny, iybeg, iybeg1, iybeg2;


/* ***********************************************************************

       ----------------------------------------------------
       COMPUTE EACH DIAGONAL ENTRY OF THE ODD COLUMNS OF Y.
       ----------------------------------------------------

     Parameter adjustments */
    --y;
    --x;
    --xpnt;

    /* Function Body */
    mm = *m;
    qq = min(*m,*q);
    iybeg = 1;
    leny = *ldy - 1;
    for (j = 1; j < qq; j += 2) {
/* DIR$	  IVDEP */
	for (i = 1; i <= *n; ++i) {
	    i1 = xpnt[i + 1] - mm;
	    a1 = x[i1];
	    y[iybeg] -= a1 * a1;
	}
	iybeg = iybeg + (leny << 1) + 1;
	leny += -2;
	mm += -2;
    }

    /* -------------------------------------------------------
       UPDATE TWO COLUMNS OF Y AT A TIME,  EXCEPT THE DIAGONAL
       ELEMENT.
       NOTE: THE DIAGONAL ELEMENT OF THE ODD COLUMN HAS
	     BEEN COMPUTED, SO WE COMPUTE THE SAME NUMBER OF
	     ELEMENTS FOR THE TWO COLUMNS.
       ------------------------------------------------------- */

    mm = *m;
    iybeg = 1;
    leny = *ldy - 1;

    for (j = 1; j < qq; j += 2) {

	iybeg1 = iybeg;
	iybeg2 = iybeg + leny;

	for (k = 1; k < *n; k += 2) {

	    /* ---------------------------------
	       TWO COLUMNS UPDATING TWO COLUMNS.
	       --------------------------------- */

	    i1 = xpnt[k + 1] - mm;
	    i2 = xpnt[k + 2] - mm;
	    a1 = x[i1];
	    a2 = x[i2];
	    a9 = x[i1 + 1];
	    a10 = x[i2 + 1];

	    y[iybeg1 + 1] += - a1 * a9 - a2 * a10;
	    y[iybeg2 + 1] += - a9 * a9 - a10 * a10;

	    for (i = 2; i < mm; ++i) {
		y1 = y[iybeg1 + i];	b1 = x[i1 + i];
		y1 -= b1 * a1;
		y2 = y[iybeg2 + i];	b2 = x[i2 + i];
		y2 -= b1 * a9;
		y1 -= b2 * a2;	y[iybeg1 + i] = y1;
		y2 -= b2 * a10; y[iybeg2 + i] = y2;
	    }

	}

	/* -----------------------------
	   BOUNDARY CODE FOR THE K LOOP.
	   ----------------------------- */

	if (k == *n) {

	    /* --------------------------------
	       ONE COLUMN UPDATING TWO COLUMNS.
	       -------------------------------- */

	    i1 = xpnt[k + 1] - mm;
	    a1 = x[i1];
	    a9 = x[i1 + 1];

	    y[iybeg1 + 1] -= a1 * a9;
	    y[iybeg2 + 1] -= a9 * a9;

	    for (i = 2; i < mm; ++i) {
		b1 = x[i1 + i];
		y[iybeg2 + i] -= b1 * a9;
		y[iybeg1 + i] -= b1 * a1;
	    }

	}

	/* -----------------------------------------------
	   PREPARE FOR NEXT PAIR OF COLUMNS TO BE UPDATED.
	   ----------------------------------------------- */

	mm += -2;
	iybeg = iybeg2 + leny + 1;
	leny += -2;

    }

    /* ------------------------------------------------------
       BOUNDARY CODE FOR J LOOP:  EXECUTED WHENEVER Q IS ODD.
       ------------------------------------------------------ */

    if (j == qq) {
	smxpy2_(&mm, n, &y[iybeg], &xpnt[1], &x[1]);
    }

    return 0;
} /* mmpy2_

 ***********************************************************************
 ***********************************************************************
 */
int
F77_SUB(mmpy4)(int *m, int *n, int *q, int *xpnt,
	       double *x, double *y, int *ldy)
{
/*
   Version:	   0.4
   Last modified:  May 26, 1995
   Authors:	   Esmond G. Ng, Barry W. Peyton, and Guodong Zhang

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 *************	   MMPY4  .... MATRIX-MATRIX MULTIPLY	  **************
 ***********************************************************************
 ***********************************************************************

   PURPOSE -
       THIS ROUTINE PERFORMS A MATRIX-MATRIX MULTIPLY, Y = Y + XA,
       ASSUMING DATA STRUCTURES USED IN SOME OF OUR SPARSE CHOLESKY
       CODES.

       LOOP UNROLLING: LEVEL 4 UPDATING TWO COLUMNS AT A TIME

   INPUT PARAMETERS -
       M	       -   NUMBER OF ROWS IN X AND IN Y.
       N	       -   NUMBER OF COLUMNS IN X AND NUMBER OF ROWS
			   IN A.
       Q	       -   NUMBER OF COLUMNS IN A AND Y.
       XPNT(*)	       -   XPNT(J+1) POINTS ONE LOCATION BEYOND THE
			   END OF THE J-TH COLUMN OF X.	 XPNT IS ALSO
			   USED TO ACCESS THE ROWS OF A.
       X(*)	       -   CONTAINS THE COLUMNS OF X AND THE ROWS OF A.
       LDY	       -   LENGTH OF FIRST COLUMN OF Y.

   UPDATED PARAMETERS -
       Y(*)	       -   ON OUTPUT, Y = Y + AX.

 ***********************************************************************
 */
    /* Local variables */
    static int i, j, k;
    static double a1, a2, a3, a4, b1, b2, b3, b4;
    static int i1, i2, i3, i4;
    static double a9, y1, y2, a10, a11, a12;
    static int mm, qq, leny, iybeg, iybeg1, iybeg2;

/* ***********************************************************************

       -----------
       PARAMETERS.
       -----------


       ----------------
       LOCAL VARIABLES.
       ----------------


 ***********************************************************************

       ----------------------------------------------------
       COMPUTE EACH DIAGONAL ENTRY OF THE ODD COLUMNS OF Y.
       ----------------------------------------------------

     Parameter adjustments */
    --y;
    --x;
    --xpnt;

    /* Function Body */
    mm = *m;
    qq = min(*m,*q);
    iybeg = 1;
    leny = *ldy - 1;
    for (j = 1; j < qq; j += 2) {
/* DIR$	  IVDEP */
	for (i = 1; i <= *n; ++i) {
	    i1 = xpnt[i + 1] - mm;
	    a1 = x[i1];
	    y[iybeg] -= a1 * a1;
	}
	iybeg = iybeg + (leny << 1) + 1;
	leny += -2;
	mm += -2;
    }

    /* -------------------------------------------------------
       UPDATE TWO COLUMNS OF Y AT A TIME,  EXCEPT THE DIAGONAL
       ELEMENT.
       NOTE: THE DIAGONAL ELEMENT OF THE ODD COLUMN HAS
	     BEEN COMPUTED, SO WE COMPUTE THE SAME NUMBER OF
	     ELEMENTS FOR THE TWO COLUMNS.
       ------------------------------------------------------- */

    mm = *m;
    iybeg = 1;
    leny = *ldy - 1;

    for (j = 1; j < qq; j += 2) {

	iybeg1 = iybeg;
	iybeg2 = iybeg + leny;

	for (k = 1; k <= (*n - 3); k += 4) {

	    /* ----------------------------------
	       FOUR COLUMNS UPDATING TWO COLUMNS.
	       ---------------------------------- */

	    i1 = xpnt[k + 1] - mm;
	    i2 = xpnt[k + 2] - mm;
	    i3 = xpnt[k + 3] - mm;
	    i4 = xpnt[k + 4] - mm;
	    a1 = x[i1];	a9  = x[i1 + 1];
	    a2 = x[i2];	a10 = x[i2 + 1];
	    a3 = x[i3];	a11 = x[i3 + 1];
	    a4 = x[i4];	a12 = x[i4 + 1];

	    y[iybeg1 + 1] -= (a1 * a9 + a2 * a10 + a3 * a11 + a4 * a12);
	    y[iybeg2 + 1] -= (a9 * a9 + a10 * a10 + a11 * a11 + a12 * a12);

	    for (i = 2; i < mm; ++i) {
		y1 = y[iybeg1 + i];	b1 = x[i1 + i];
		y1 -= b1 * a1;
		y2 = y[iybeg2 + i];	b2 = x[i2 + i];
		y2 -= b1 * a9;
		y1 -= b2 * a2;		b3 = x[i3 + i];
		y2 -= b2 * a10;
		y1 -= b3 * a3;		b4 = x[i4 + i];
		y2 -= b3 * a11;
		y1 -= b4 * a4;
		y[iybeg1 + i] = y1;
		y2 -= b4 * a12;
		y[iybeg2 + i] = y2;
	    }

	}

	/* -----------------------------
	   BOUNDARY CODE FOR THE K LOOP.
	   ----------------------------- */

	switch (*n - k + 2) {
	    case 1:  goto L1100;
	    case 2:  goto L900;
	    case 3:  goto L700;
	    case 4:  goto L500;
	}

L500:

	/* -----------------------------------
	       THREE COLUMNS UPDATING TWO COLUMNS.
	       ----------------------------------- */

	i1 = xpnt[k + 1] - mm;
	i2 = xpnt[k + 2] - mm;
	i3 = xpnt[k + 3] - mm;
	a1 = x[i1];	a9  = x[i1 + 1];
	a2 = x[i2];	a10 = x[i2 + 1];
	a3 = x[i3];	a11 = x[i3 + 1];

	y[iybeg1 + 1] -= (a1 * a9 +  a2 * a10 +	 a3 * a11);
	y[iybeg2 + 1] -= (a9 * a9 + a10 * a10 + a11 * a11);

	for (i = 2; i < mm; ++i) {
	    y1 = y[iybeg1 + i];	    b1 = x[i1 + i];
	    y1 -= b1 * a1;
	    y2 = y[iybeg2 + i];	    b2 = x[i2 + i];
	    y2 -= b1 * a9;
	    y1 -= b2 * a2;	    b3 = x[i3 + i];
	    y2 -= b2 * a10;
	    y1 -= b3 * a3;
	    y[iybeg1 + i] = y1;
	    y2 -= b3 * a11;
	    y[iybeg2 + i] = y2;
	}

	goto L1100;

L700:

	/* ---------------------------------
	       TWO COLUMNS UPDATING TWO COLUMNS.
	       --------------------------------- */

	i1 = xpnt[k + 1] - mm;
	i2 = xpnt[k + 2] - mm;
	a1 = x[i1];
	a2 = x[i2];
	a9 = x[i1 + 1];
	a10 = x[i2 + 1];
	y[iybeg1 + 1] -= (a1 * a9 +  a2 * a10);
	y[iybeg2 + 1] -= (a9 * a9 + a10 * a10);
	for (i = 2; i < mm; ++i) {
	    y1 = y[iybeg1 + i];	    b1 = x[i1 + i];
	    y1 -= b1 * a1;
	    y2 = y[iybeg2 + i];	    b2 = x[i2 + i];
	    y2 -= b1 * a9;
	    y1 -= b2 * a2;
	    y[iybeg1 + i] = y1;
	    y2 -= b2 * a10;
	    y[iybeg2 + i] = y2;
	}

	goto L1100;

L900:

	/* --------------------------------
	       ONE COLUMN UPDATING TWO COLUMNS.
	       -------------------------------- */

	i1 = xpnt[k + 1] - mm;
	a1 = x[i1];	a9 = x[i1 + 1];

	y[iybeg1 + 1] -= a1 * a9;
	y[iybeg2 + 1] -= a9 * a9;

	for (i = 2; i < mm; ++i) {
	    b1 = x[i1 + i];
	    y[iybeg1 + i] -= b1 * a1;
	    y[iybeg2 + i] -= b1 * a9;
	}

	goto L1100;

	/* -----------------------------------------------
	   PREPARE FOR NEXT PAIR OF COLUMNS TO BE UPDATED.
	   ----------------------------------------------- */

L1100:
	mm += -2;
	iybeg = iybeg2 + leny + 1;
	leny += -2;

    }

    /* ------------------------------------------------------
       BOUNDARY CODE FOR J LOOP:  EXECUTED WHENEVER Q IS ODD.
       ------------------------------------------------------ */

    if (j == qq) {
	smxpy4_(&mm, n, &y[iybeg], &xpnt[1], &x[1]);
    }

    return 0;
} /* mmpy4_

 ***********************************************************************
 ***********************************************************************
 */
int
F77_SUB(mmpy8)(int *m, int *n, int *q, int *xpnt,
	       double *x, double *y, int *ldy)
{
/*
   Version:	   0.4
   Last modified:  May 26, 1995
   Authors:	   Esmond G. Ng, Barry W. Peyton, and Guodong Zhang

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 *************	   MMPY8  .... MATRIX-MATRIX MULTIPLY	  **************
 ***********************************************************************
 ***********************************************************************

   PURPOSE -
       THIS ROUTINE PERFORMS A MATRIX-MATRIX MULTIPLY, Y = Y + XA,
       ASSUMING DATA STRUCTURES USED IN SOME OF OUR SPARSE CHOLESKY
       CODES.

       LOOP UNROLLING: LEVEL 8 UPDATING TWO COLUMNS AT A TIME

   INPUT PARAMETERS -
       M	       -   NUMBER OF ROWS IN X AND IN Y.
       N	       -   NUMBER OF COLUMNS IN X AND NUMBER OF ROWS
			   IN A.
       Q	       -   NUMBER OF COLUMNS IN A AND Y.
       XPNT(*)	       -   XPNT(J+1) POINTS ONE LOCATION BEYOND THE
			   END OF THE J-TH COLUMN OF X.	 XPNT IS ALSO
			   USED TO ACCESS THE ROWS OF A.
       X(*)	       -   CONTAINS THE COLUMNS OF X AND THE ROWS OF A.
       LDY	       -   LENGTH OF FIRST COLUMN OF Y.

   UPDATED PARAMETERS -
       Y(*)	       -   ON OUTPUT, Y = Y + AX.

 ***********************************************************************
 */
    /* Local variables */
    int i, j, k, i1, i2, i3, i4, i5, i6, i7, i8;
    int mm, qq, leny, iybeg, iybeg1, iybeg2;
    double a1, a2, a3, a4, a5, a6, a7, a8, a9, a10,
	a11, a12, a13, a14, a15, a16,
	b1, b2, b3, b4, b5, b6, b7, b8,	 y1, y2;

/* ***********************************************************************/

    /* Parameter adjustments */
    --y;
    --x;
    --xpnt;

    /* ----------------------------------------------------
       COMPUTE EACH DIAGONAL ENTRY OF THE ODD COLUMNS OF Y.
       ----------------------------------------------------*/

    mm = *m;
    qq = min(*m,*q);
    iybeg = 1;
    leny = *ldy - 1;
    for (j = 1; j < qq; j += 2) {
/* DIR$	  IVDEP */
	for (i = 1; i <= *n; ++i) {
	    i1 = xpnt[i + 1] - mm;
	    a1 = x[i1];
	    y[iybeg] -= a1 * a1;
	}
	iybeg = iybeg + (leny << 1) + 1;
	leny += -2;
	mm += -2;
    }

    /* -------------------------------------------------------
       UPDATE TWO COLUMNS OF Y AT A TIME,  EXCEPT THE DIAGONAL
       ELEMENT.
       NOTE: THE DIAGONAL ELEMENT OF THE ODD COLUMN HAS
	     BEEN COMPUTED, SO WE COMPUTE THE SAME NUMBER OF
	     ELEMENTS FOR THE TWO COLUMNS.
       ------------------------------------------------------- */

    mm = *m;
    iybeg = 1;
    leny = *ldy - 1;

    for (j = 1; j < qq; j += 2) {

	iybeg1 = iybeg;
	iybeg2 = iybeg + leny;

	for (k = 1; k <= (*n - 7); k += 8) {

	    /* -----------------------------------
	       EIGHT COLUMNS UPDATING TWO COLUMNS.
	       ----------------------------------- */

	    i1 = xpnt[k + 1] - mm;	a1 = x[i1];	a9  = x[i1 + 1];
	    i2 = xpnt[k + 2] - mm;	a2 = x[i2];	a10 = x[i2 + 1];
	    i3 = xpnt[k + 3] - mm;	a3 = x[i3];	a11 = x[i3 + 1];
	    i4 = xpnt[k + 4] - mm;	a4 = x[i4];	a12 = x[i4 + 1];
	    i5 = xpnt[k + 5] - mm;	a5 = x[i5];	a13 = x[i5 + 1];
	    i6 = xpnt[k + 6] - mm;	a6 = x[i6];	a14 = x[i6 + 1];
	    i7 = xpnt[k + 7] - mm;	a7 = x[i7];	a15 = x[i7 + 1];
	    i8 = xpnt[k + 8] - mm;	a8 = x[i8];	a16 = x[i8 + 1];

	    y[iybeg1 + 1] += - a1 * a9 - a2 * a10 - a3 * a11 -
		a4 * a12 - a5 * a13 - a6 * a14 - a7 * a15 - a8 * a16;

	    y[iybeg2 + 1] += - a9 * a9 - a10 * a10 - a11 * a11 -
		a12 * a12 - a13 * a13 - a14 * a14 - a15 * a15 - a16 * a16;

	    for (i = 2; i < mm; ++i) {
		y1 = y[iybeg1 + i];	b1 = x[i1 + i];
		y1 -= b1 * a1;
		y2 = y[iybeg2 + i];	b2 = x[i2 + i];
		y2 -= b1 * a9;
		y1 -= b2 * a2;		b3 = x[i3 + i];
		y2 -= b2 * a10;
		y1 -= b3 * a3;		b4 = x[i4 + i];
		y2 -= b3 * a11;
		y1 -= b4 * a4;		b5 = x[i5 + i];
		y2 -= b4 * a12;
		y1 -= b5 * a5;		b6 = x[i6 + i];
		y2 -= b5 * a13;
		y1 -= b6 * a6;		b7 = x[i7 + i];
		y2 -= b6 * a14;
		y1 -= b7 * a7;		b8 = x[i8 + i];
		y2 -= b7 * a15;
		y1 -= b8 * a8;
		y[iybeg1 + i] = y1;
		y2 -= b8 * a16;
		y[iybeg2 + i] = y2;
	    }

	}

	/* -----------------------------
	   BOUNDARY CODE FOR THE K LOOP.
	   ----------------------------- */

	switch (*n - k + 2) {
	    case 1:  goto L2000;
	    case 2:  goto L1700;
	    case 3:  goto L1500;
	    case 4:  goto L1300;
	    case 5:  goto L1100;
	    case 6:  goto L900;
	    case 7:  goto L700;
	    case 8:  goto L500;
	}

L500:

	/* -----------------------------------
	   SEVEN COLUMNS UPDATING TWO COLUMNS.
	   ----------------------------------- */

	i1 = xpnt[k + 1] - mm;
	i2 = xpnt[k + 2] - mm;
	i3 = xpnt[k + 3] - mm;
	i4 = xpnt[k + 4] - mm;
	i5 = xpnt[k + 5] - mm;
	i6 = xpnt[k + 6] - mm;
	i7 = xpnt[k + 7] - mm;
	a1 = x[i1];	a9 = x[i1 + 1];
	a2 = x[i2];	a10 = x[i2 + 1];
	a3 = x[i3];	a11 = x[i3 + 1];
	a4 = x[i4];	a12 = x[i4 + 1];
	a5 = x[i5];	a13 = x[i5 + 1];
	a6 = x[i6];	a14 = x[i6 + 1];
	a7 = x[i7];	a15 = x[i7 + 1];

	y[iybeg1 + 1] -= (a1 * a9 +  a2 * a10 + a3 * a11 +  a4 * a12 +
			  a5 * a13 + a6 * a14 + a7 * a15);
	y[iybeg2 + 1] -= ( a9 * a9 +  a10 * a10 + a11 * a11 + a12 * a12 +
			  a13 * a13 + a14 * a14 + a15 * a15);

	for (i = 2; i < mm; ++i) {
	    y1 = y[iybeg1 + i];	    b1 = x[i1 + i];
	    y1 -= b1 * a1;
	    y2 = y[iybeg2 + i];	    b2 = x[i2 + i];
	    y2 -= b1 * a9;
	    y1 -= b2 * a2;	    b3 = x[i3 + i];
	    y2 -= b2 * a10;
	    y1 -= b3 * a3;	    b4 = x[i4 + i];
	    y2 -= b3 * a11;
	    y1 -= b4 * a4;	    b5 = x[i5 + i];
	    y2 -= b4 * a12;
	    y1 -= b5 * a5;	    b6 = x[i6 + i];
	    y2 -= b5 * a13;
	    y1 -= b6 * a6;	    b7 = x[i7 + i];
	    y2 -= b6 * a14;
	    y1 -= b7 * a7;
	    y2 -= b7 * a15;
	    y[iybeg1 + i] = y1;
	    y[iybeg2 + i] = y2;
	}

	goto L2000;

L700:

	/* ---------------------------------
	   SIX COLUMNS UPDATING TWO COLUMNS.
	   --------------------------------- */

	i1 = xpnt[k + 1] - mm;
	i2 = xpnt[k + 2] - mm;
	i3 = xpnt[k + 3] - mm;
	i4 = xpnt[k + 4] - mm;
	i5 = xpnt[k + 5] - mm;
	i6 = xpnt[k + 6] - mm;
	a1 = x[i1];	a9  = x[i1 + 1];
	a2 = x[i2];	a10 = x[i2 + 1];
	a3 = x[i3];	a11 = x[i3 + 1];
	a4 = x[i4];	a12 = x[i4 + 1];
	a5 = x[i5];	a13 = x[i5 + 1];
	a6 = x[i6];	a14 = x[i6 + 1];

	y[iybeg1 + 1] -= (a1 * a9 + a2 * a10 + a3 * a11 + a4 * a12 +
			  a5 * a13 + a6 * a14);
	y[iybeg2 + 1] -= (a9 * a9 + a10 * a10 + a11 * a11 + a12 * a12 +
			  a13 * a13 + a14 * a14);

	for (i = 2; i < mm; ++i) {
	    y1 = y[iybeg1 + i];	    b1 = x[i1 + i];
	    y1 -= b1 * a1;
	    y2 = y[iybeg2 + i];	    b2 = x[i2 + i];
	    y2 -= b1 * a9;
	    y1 -= b2 * a2;	    b3 = x[i3 + i];
	    y2 -= b2 * a10;
	    y1 -= b3 * a3;	    b4 = x[i4 + i];
	    y2 -= b3 * a11;
	    y1 -= b4 * a4;	    b5 = x[i5 + i];
	    y2 -= b4 * a12;
	    y1 -= b5 * a5;	    b6 = x[i6 + i];
	    y2 -= b5 * a13;
	    y1 -= b6 * a6;
	    y2 -= b6 * a14;
	    y[iybeg1 + i] = y1;
	    y[iybeg2 + i] = y2;
	}

	goto L2000;

L900:

	/* ----------------------------------
	   FIVE COLUMNS UPDATING TWO COLUMNS.
	   ---------------------------------- */

	i1 = xpnt[k + 1] - mm;
	i2 = xpnt[k + 2] - mm;
	i3 = xpnt[k + 3] - mm;
	i4 = xpnt[k + 4] - mm;
	i5 = xpnt[k + 5] - mm;
	a1 = x[i1];	a9  = x[i1 + 1];
	a2 = x[i2];	a10 = x[i2 + 1];
	a3 = x[i3];	a11 = x[i3 + 1];
	a4 = x[i4];	a12 = x[i4 + 1];
	a5 = x[i5];	a13 = x[i5 + 1];

	y[iybeg1 + 1] -= (a1* a9 +  a2* a10 +  a3* a11 +  a4* a12 +  a5* a13);
	y[iybeg2 + 1] -= (a9* a9 + a10* a10 + a11* a11 + a12* a12 + a13* a13);

	for (i = 2; i < mm; ++i) {
	    y1 = y[iybeg1 + i];	    b1 = x[i1 + i];
	    y1 -= b1 * a1;
	    y2 = y[iybeg2 + i];	    b2 = x[i2 + i];
	    y2 -= b1 * a9;
	    y1 -= b2 * a2;	    b3 = x[i3 + i];
	    y2 -= b2 * a10;
	    y1 -= b3 * a3;	    b4 = x[i4 + i];
	    y2 -= b3 * a11;
	    y1 -= b4 * a4;	    b5 = x[i5 + i];
	    y2 -= b4 * a12;
	    y1 -= b5 * a5;
	    y2 -= b5 * a13;
	    y[iybeg1 + i] = y1;
	    y[iybeg2 + i] = y2;
	}

	goto L2000;

L1100:

	/* ----------------------------------
	   FOUR COLUMNS UPDATING TWO COLUMNS.
	   ---------------------------------- */

	i1 = xpnt[k + 1] - mm;
	i2 = xpnt[k + 2] - mm;
	i3 = xpnt[k + 3] - mm;
	i4 = xpnt[k + 4] - mm;
	a1 = x[i1];	a9 =  x[i1 + 1];
	a2 = x[i2];	a10 = x[i2 + 1];
	a3 = x[i3];	a11 = x[i3 + 1];
	a4 = x[i4];	a12 = x[i4 + 1];

	y[iybeg1 + 1] -= (a1 * a9 -  a2 * a10 -	 a3 * a11 -  a4 * a12);
	y[iybeg2 + 1] -= (a9 * a9 - a10 * a10 - a11 * a11 - a12 * a12);

	for (i = 2; i < mm; ++i) {
	    y1 = y[iybeg1 + i];	    b1 = x[i1 + i];
	    y1 -= b1 * a1;
	    y2 = y[iybeg2 + i];	    b2 = x[i2 + i];
	    y2 -= b1 * a9;
	    y1 -= b2 * a2;	    b3 = x[i3 + i];
	    y2 -= b2 * a10;
	    y1 -= b3 * a3;	    b4 = x[i4 + i];
	    y2 -= b3 * a11;
	    y1 -= b4 * a4;
	    y2 -= b4 * a12;
	    y[iybeg1 + i] = y1;
	    y[iybeg2 + i] = y2;
	}

	goto L2000;

L1300:

	/* -----------------------------------
	       THREE COLUMNS UPDATING TWO COLUMNS.
	       ----------------------------------- */

	i1 = xpnt[k + 1] - mm;
	i2 = xpnt[k + 2] - mm;
	i3 = xpnt[k + 3] - mm;
	a1 = x[i1];	a9 =  x[i1 + 1];
	a2 = x[i2];	a10 = x[i2 + 1];
	a3 = x[i3];	a11 = x[i3 + 1];

	y[iybeg1 + 1] -= (a1 * a9 +  a2 * a10 +	 a3 * a11);
	y[iybeg2 + 1] -= (a9 * a9 + a10 * a10 + a11 * a11);

	for (i = 2; i < mm; ++i) {
	    y1 = y[iybeg1 + i];	    b1 = x[i1 + i];
	    y1 -= b1 * a1;
	    y2 = y[iybeg2 + i];	    b2 = x[i2 + i];
	    y2 -= b1 * a9;
	    y1 -= b2 * a2;	    b3 = x[i3 + i];
	    y2 -= b2 * a10;
	    y1 -= b3 * a3;
	    y2 -= b3 * a11;
	    y[iybeg1 + i] = y1;
	    y[iybeg2 + i] = y2;
	}

	goto L2000;

L1500:

	/* ---------------------------------
	       TWO COLUMNS UPDATING TWO COLUMNS.
	       --------------------------------- */

	i1 = xpnt[k + 1] - mm;
	i2 = xpnt[k + 2] - mm;
	a1 = x[i1];	a9  = x[i1 + 1];
	a2 = x[i2];	a10 = x[i2 + 1];

	y[iybeg1 + 1] -= (a1 * a9 +  a2 * a10);
	y[iybeg2 + 1] -= (a9 * a9 + a10 * a10);

	for (i = 2; i < mm; ++i) {
	    y1 = y[iybeg1 + i];	    b1 = x[i1 + i];
	    y1 -= b1 * a1;
	    y2 = y[iybeg2 + i];	    b2 = x[i2 + i];
	    y2 -= b1 * a9;
	    y1 -= b2 * a2;
	    y2 -= b2 * a10;
	    y[iybeg1 + i] = y1;
	    y[iybeg2 + i] = y2;
	}

	goto L2000;

L1700:

       /* --------------------------------
	  ONE COLUMN UPDATING TWO COLUMNS.
	  -------------------------------- */

	i1 = xpnt[k + 1] - mm;
	a1 = x[i1];
	a9 = x[i1 + 1];

	y[iybeg1 + 1] -= a1 * a9;
	y[iybeg2 + 1] -= a9 * a9;

	for (i = 2; i < mm; ++i) {
	    b1 = x[i1 + i];
	    y[iybeg1 + i] -= b1 * a1;
	    y[iybeg2 + i] -= b1 * a9;
	}

	goto L2000;

	/* -----------------------------------------------
	   PREPARE FOR NEXT PAIR OF COLUMNS TO BE UPDATED.
	   ----------------------------------------------- */

L2000:
	mm += -2;
	iybeg = iybeg2 + leny + 1;
	leny += -2;

    }

    /* -----------------------------------------------------
       BOUNDARY CODE FOR J LOOP:  EXECUTED WHENVER Q IS ODD.
       ----------------------------------------------------- */

    if (j == qq) {
	smxpy8_(&mm, n, &y[iybeg], &xpnt[1], &x[1]);
    }

    return 0;
} /* mmpy8_

 ***********************************************************************
 ***********************************************************************
 */

static int
mmpyi_(int *m, int *q, int *xpnt, double *x,
	   int *iy, double *y, int *relind)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 *************	   MMPYI  .... MATRIX-MATRIX MULTIPLY	  **************
 ***********************************************************************
 ***********************************************************************

   PURPOSE -
       THIS ROUTINE PERFORMS A MATRIX-MATRIX MULTIPLY, Y = Y + XA,
       ASSUMING DATA STRUCTURES USED IN SOME OF OUR SPARSE CHOLESKY
       CODES.

       MATRIX X HAS ONLY 1 COLUMN.

   INPUT PARAMETERS -
       M	       -   NUMBER OF ROWS IN X AND IN Y.
       Q	       -   NUMBER OF COLUMNS IN A AND Y.
       XPNT(*)	       -   XPNT(J+1) POINTS ONE LOCATION BEYOND THE
			   END OF THE J-TH COLUMN OF X.	 XPNT IS ALSO
			   USED TO ACCESS THE ROWS OF A.
       X(*)	       -   CONTAINS THE COLUMNS OF X AND THE ROWS OF A.
       IY(*)	       -   IY(COL) POINTS TO THE BEGINNING OF COLUMN
       RELIND(*)       -   RELATIVE INDICES.

   UPDATED PARAMETERS -
       Y(*)	       -   ON OUTPUT, Y = Y + AX.

 ***********************************************************************
 */
    /* Local variables */
    static double a;
    static int i, k, col, isub, ylast;


/* ***********************************************************************

       -----------
       PARAMETERS.
       -----------


       ----------------
       LOCAL VARIABLES.
       ----------------


 ***********************************************************************

     Parameter adjustments */
    --relind;
    --y;
    --iy;
    --x;
    --xpnt;

    /* Function Body */
    for (k = 1; k <= *q; ++k) {
	col = xpnt[k];
	ylast = iy[col + 1] - 1;
	a = -x[k];
/* DIR$	  IVDEP */
	for (i = k; i <= *m; ++i) {
	    isub = xpnt[i];
	    isub = ylast - relind[isub];
	    y[isub] += a * x[i];
	}
    }
    return 0;

} /* mmpyi_

 ***********************************************************************
 ***********************************************************************
 */
void
F77_SUB(ordmmd)(int *neqns, int *xadj, int *adjncy,
		int *invp, int *perm, int *iwsiz, int *iwork,
		int *nofsub, int *iflag)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ****	  ordmmd ..... Multiple Minimum external Degree	    ************
 ***********************************************************************
 ***********************************************************************

     Purpose - This routine calls liu's multiple minimum degree
	       routine.

     INPUT parameters -
	neqns  - number of equations.
	(xadj,adjncy) - the adjacency structure.
	iwsiz  - size of integer working storage.

     OUTPUT parameters -
	perm   - the minimum degree ordering.
	invp   - the inverse of perm.
	nofsub - an upper bound on the number of nonzero
		 subscripts for the compressed storage scheme.
	iflag  - error flag.
		   0: successful ordering
		  -1: insufficient working storage [iwork(*)].

     Working parameters -
	iwork  - integer workspace of length 4*neqns.

 ***********************************************************************
 */
    extern int
	genmmd_(int *neqns, int *xadj, int *adjncy,
		int *invp, int *perm, int *delta, int *dhead, int *qsize,
		int *llist, int *marker, int *maxint, int *nofsub);

    int delta = 0; /* delta  - tolerance value for multiple elimination.*/
    int maxint = 32767; /* maximum machine representable (short) integer
			   (any smaller estimate will do) for marking nodes. */

    if (*iwsiz < *neqns << 2) {
	*iflag = -1; return;
    } else *iflag = 0;

    genmmd_(neqns, xadj, adjncy, invp, perm, &delta,
	    iwork, &iwork[*neqns], &iwork[(*neqns << 1)], &iwork[*neqns * 3],
	    &maxint, nofsub);
    return;
} /* ordmmd_ */

/***********************************************************************
 ***********************************************************************/

static void
pchol(int m, int n, int *xpnt, double *x,
      double mxdiag, int *ntiny, int *iflag, S_fp smxpy)
{
/*
   Version:	   0.3
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratoy

 ***********************************************************************
 ***********************************************************************
 ******	    pchol .... dense Partial CHOLesky		  **************
 ***********************************************************************
 ***********************************************************************

     PURPOSE - This routine performs cholesky
	       factorization on the columns of a supernode
	       that have received all updates from columns
	       external to the supernode.

     INPUT parameters -
	m      - number of rows (length of the first column).
	n      - number of columns in the supernode.
	xpnt   - xpnt(j+1) points one location beyond the end
		 of the j-th column of the supernode.
	x(*)   - contains the columns of of the supernode to be factored.
	smxpy  - external routine: matrix-vector multiply.

     OUTPUT parameters -
	x(*)   - on output, contains the factored columns of the supernode.
	iflag  - unchanged if there is no error.
		 =1 if nonpositive diagonal entry is encountered.

 ***********************************************************************
*/
    int jcol, jpnt;
    double diag;

    /* Parameter adjustments */
    --x;

    jpnt = xpnt[0];
    /* ------------------------------------------
       For every column jcol in the supernode ...
       ------------------------------------------ */
    for (jcol = 1; jcol <= n; ++jcol) {
	/* ----------------------------------
	   Update jcol with previous columns.
	   ---------------------------------- */
	if (jcol > 1) {
	    int ii = jcol - 1;
	    (*smxpy)(&m, &ii, &x[jpnt], xpnt, &x[1]);
	}

	/* ---------------------------
	   Compute the diagonal entry.
	   --------------------------- */
	diag = x[jpnt];
	/* replace very small diag with "Inf" - and signal *ntiny : */
	if (diag <= mxdiag * 1e-30) {
	    diag = 1e128;
	    ++(*ntiny);
	}
	diag = sqrt(diag);
	x[jpnt] = diag;
	diag = 1. / diag;

	/* ----------------------------------------------------
	   Scale column jcol with reciprocal of diagonal entry.
	   ---------------------------------------------------- */
	--m;
	++jpnt;
	dscal1_(m, diag, &x[jpnt]);
	jpnt += m;
    }
    return;
} /* pchol */

/***********************************************************************
 *********************************************************************** */

void
F77_SUB(sfinit)(int *neqns, int *nnza, int *xadj,
		int *adjncy, int *perm, int *invp, int *colcnt,
		int *nnzl, int *nsub, int *nsuper, int *snode,
		int *xsuper, int *iwsiz, int *iwork, int *iflag)
{
/*
   Version:	   0.4
   Last modified:  January 12, 1995
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ************** sfinit	..... set up for Symbolic Factorization	 *******
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       This subroutine computes the storage requirements and sets up
       preliminary data structures for the symbolic factorization.

   Note:
       This version produces the maximal supernode partition (i.e.,
       the one with the fewest possible supernodes).

   INPUT parameters:
       neqns	   -   number of equations.
       nnza	   -   length of adjacency structure.
       xadj(*)	   -   array of length neqns+1, containing pointers
		       to the adjacency structure.
       adjncy(*)   -   array of length xadj(neqns+1)-1, containing
		       the adjacency structure.
       perm(*)	   -   array of length neqns, containing the
		       postordering.
       invp(*)	   -   array of length neqns, containing the
		       inverse of the postordering.
       iwsiz	   -   size of integer working storage.

   OUTPUT parameters:
       colcnt(*)   -   array of length neqns, containing the number
		       of nonzeros in each column of the factor,
		       including the diagonal entry.
       nnzl	   -   number of nonzeros in the factor, including
		       the diagonal entries.
       nsub	   -   number of subscripts.
       nsuper	   -   number of supernodes (<= neqns).
       snode(*)	   -   array of length neqns for recording
		       supernode membership.
       xsuper(*)   -   array of length neqns+1, containing the
		       supernode partitioning.
       iflag(*)	   -   error flag.
			  0: successful sf initialization.
			 -1: insufficent working storage [iwork(*)].

   Work parameters:
       iwork(*)	   -   integer work array of length 7*neqns+3.

   First created on    November 14, 1994.
   Last updated on     January 12, 1995.

 ***********************************************************************
 */
    extern void
	etordr_(int *, int *, int *, int *, int *, int *, int *, int *, int *);

    extern int
	fcnthn_(int *, int *, int *, int *, int *, int *, int *, int *,
		int *, int *, int *, int *, int *, int *, int *, int *, int *);

    extern int
	chordr_(int *, int *, int *, int *, int *, int *, int *, int *,
		int *, int *);

    extern int
	fsup1_(int *, int *, int *, int *, int *, int *);
    extern int
	fsup2_(int *, int *, int *, int *, int *);

    /*--------------------------------------------------------
       Return if there is insufficient integer working storage.
       --------------------------------------------------------*/
    *iflag = 0;
    if (*iwsiz < *neqns * 7 + 3) {
	*iflag = -1; return;
    }

    /* ------------------------------------------
       COMPUTE ELIMINATION TREE AND POSTORDERING.
       ------------------------------------------ */
    etordr_(neqns, xadj, adjncy, perm, invp, iwork,
	    &iwork[*neqns], &iwork[(*neqns << 1)], &iwork[*neqns * 3]);

    /* ---------------------------------------------
       COMPUTE ROW AND COLUMN FACTOR NONZERO COUNTS.
       --------------------------------------------- */
    fcnthn_(neqns, nnza, xadj, adjncy, perm, invp, iwork,
	    snode, colcnt, nnzl, &iwork[*neqns],
	    &iwork[(*neqns << 1)], xsuper,
	    &iwork[*neqns * 3], &iwork[(*neqns << 2) + 1],
	    &iwork[*neqns * 5 + 2], &iwork[*neqns * 6 + 3]);

    /* ---------------------------------------------------------
       REARRANGE CHILDREN SO THAT THE LAST CHILD HAS THE MAXIMUM
       NUMBER OF NONZEROS IN ITS COLUMN OF L.
       --------------------------------------------------------- */
    chordr_(neqns, xadj, adjncy, perm, invp, colcnt,
	    iwork, &iwork[*neqns],
	    &iwork[(*neqns << 1)], &iwork[*neqns * 3]);

    /* ----------------
       FIND SUPERNODES.
       ---------------- */
    fsup1_(neqns, iwork, colcnt, nsub, nsuper, snode);
    fsup2_(neqns, nsuper, iwork, snode, xsuper);

    return;
} /* sfinit_ */

/************************************************************************
 ************************************************************************/

int
F77_SUB(smxpy1)(int *m, int *n, double *y, int *apnt, double *a)
{
/*
  Version:	  0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ******	    SMXPY1 .... MATRIX-VECTOR MULTIPLY		  **************
 ***********************************************************************
 ***********************************************************************

     PURPOSE - THIS ROUTINE PERFORMS A MATRIX-VECTOR MULTIPLY,
	       Y = Y + AX, ASSUMING DATA STRUCTURES USED IN
	       RECENTLY DEVELOPED SPARSE CHOLESKY CODES.  THE
	       '1' SIGNIFIES NO LOOP UNROLLING, I.E.,
	       LOOP-UNROLLING TO LEVEL 1.

     INPUT PARAMETERS -
	M      - NUMBER OF ROWS.
	N      - NUMBER OF COLUMNS.
	Y      - M-VECTOR TO WHICH AX WILL BE ADDED.
	APNT   - INDEX VECTOR FOR A.  XA(I) POINTS TO THE
		 FIRST NONZERO IN COLUMN I OF A.
	Y      - ON OUTPUT, CONTAINS Y = Y + AX.

 ***********************************************************************
 */

    int j;

    --a; /* 1-based indexing */

    for (j = 0; j < *n; ++j) {
	int i, ii = apnt[j + 1] - *m;
	double amult = -a[ii];
	for (i = 0; i < *m; ++i) {
	    y[i] += amult * a[ii];
	    ++ii;
	}
    }
    return 0;
} /* smxpy1_ */

/*********************************************************************** */

int
F77_SUB(smxpy2)(int *m, int *n, double *y, int *apnt, double *a)
{
/*
  Version:	  0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ******	    SMXPY2 .... MATRIX-VECTOR MULTIPLY		  **************
 ***********************************************************************
 ***********************************************************************

     PURPOSE - This routine performs a matrix-vector multiply,
	       y = y + A X, assuming data structures used in
	       recently developed sparse cholesky codes.  the
	       '2' signifies level 2 loop unrolling.

     INPUT parameters -
	m      - number of rows.
	n      - number of columns.
	y      - m-vector to which ax will be added.
	apnt   - index vector for a.  xa(i) points to the
		 first nonzero in column i of a.
	y      - on output, contains y = y + A X.

 ***********************************************************************
*/
    /* Local variables */
    int i, j, i1, i2, remain;
    double a1, a2;

    --a; /* 1-based indexing */

    remain = *n % 2;

    switch (remain + 1) {
    case 1:  break;
    case 2:  /* L100: */
	i1 = apnt[1] - *m;
	a1 = -a[i1];
	for (i = 0; i < *m; ++i) {
	    y[i] += a1 * a[i1++];
	}
	break;
    }

/* L2000: */
    for (j = remain; j < *n; j += 2) {
	i1 = apnt[j + 1] - *m;
	i2 = apnt[j + 2] - *m;
	a1 = -a[i1];
	a2 = -a[i2];
	for (i = 0; i < *m; ++i) {
	    y[i] += a1 * a[i1++] + a2 * a[i2++];
	}
    }

    return 0;
} /* smxpy2_ */

/***********************************************************************/

int
F77_SUB(smxpy4)(int *m, int *n, double *y, int *apnt, double *a)
{
/*
   Version:	   0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ******	    SMXPY4 .... MATRIX-VECTOR MULTIPLY		  **************
 ***********************************************************************
 ***********************************************************************

     PURPOSE - This routine performs a matrix-vector multiply,
	       y = y + A X, assuming data structures used in
	       recently developed sparse cholesky codes.  the
	       '4' signifies level 4 loop unrolling.

     input parameters -
	m      - number of rows.
	n      - number of columns.
	y      - m-vector to which A X will be added.
	apnt   - index vector for a.  xa(i) points to the
		 first nonzero in column i of a.
	y      - on output, contains y = y + A X.

 ***********************************************************************
 */
    /* Local variables */
    int i, j, i1, i2, i3, i4, remain;
    double a1, a2, a3, a4;

    --a; /* 1-based indexing */

    remain = *n % 4;

    switch (remain + 1) {
    case 1:  break;

    case 2:  /* L100: */
	i1 = apnt[1] - *m;
	a1 = -a[i1];
	for (i = 0; i < *m; ++i) {
	    y[i] += a1 * a[i1++];
	}
	break;

    case 3:  /* L200: */
	i1 = apnt[1] - *m;
	i2 = apnt[2] - *m;
	a1 = -a[i1];
	a2 = -a[i2];
	for (i = 0; i < *m; ++i) {
	    y[i] += a1 * a[i1++] + a2 * a[i2++];
	}

	break;

    case 4: /* L300: */
	i1 = apnt[1] - *m;
	i2 = apnt[2] - *m;
	i3 = apnt[3] - *m;
	a1 = -a[i1];
	a2 = -a[i2];
	a3 = -a[i3];
	for (i = 0; i < *m; ++i) {
	    y[i] += a1 * a[i1++] + a2 * a[i2++] + a3 * a[i3++];
	}
	break;

    } /* end{ switch } */


    /* L2000: */
    for (j = remain; j < *n; j += 4) {
	i1 = apnt[j + 1] - *m;
	i2 = apnt[j + 2] - *m;
	i3 = apnt[j + 3] - *m;
	i4 = apnt[j + 4] - *m;
	a1 = -a[i1];
	a2 = -a[i2];
	a3 = -a[i3];
	a4 = -a[i4];
	for (i = 0; i < *m; ++i) {
	    y[i] += a1 * a[i1++] + a2 * a[i2++] + a3 * a[i3++] + a4 * a[i4++];
	}
    }

    return 0;
} /* smxpy4_ */

/************************************************************************/

int
F77_SUB(smxpy8)(int *m, int *n, double *y, int *apnt, double *a)
{
/*
  Version:	  0.4
   Last modified:  December 27, 1994
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 ******	    SMXPY8 .... MATRIX-VECTOR MULTIPLY		  **************
 ***********************************************************************
 ***********************************************************************

     PURPOSE - This routine performs a matrix-vector multiply,
	       y = y + A X, assuming data structures used in
	       recently developed sparse cholesky codes.  the
	       '8' signifies level 8 loop unrolling.

     INPUT parameters -
	m      - number of rows.
	n      - number of columns.
	y      - m-vector to which A X will be added.
	apnt   - index vector for a.  apnt(i) points to the
		 first nonzero in column i of a.
	y      - on output, contains y = y + A X.

 ***********************************************************************
*/
    int i, j, i1, i2, i3, i4, i5, i6, i7, i8, remain;
    double a1, a2, a3, a4, a5, a6, a7, a8;

    --a; /* 1-based indexing */

    remain = *n % 8;

    switch (remain) {
    case 0:  break;

    case 1: /* L100: */
	i1 = apnt[1] - *m;	a1 = -a[i1];
	for (i = 0; i < *m; ++i) {
	    y[i] += a1 * a[i1++];
	}
	break;

    case 2: /* L200: */
	i1 = apnt[1] - *m;	a1 = -a[i1];
	i2 = apnt[2] - *m;	a2 = -a[i2];

	for (i = 0; i < *m; ++i) {
	    y[i] += a1 * a[i1++] + a2 * a[i2++];
	}
	break;

    case 3: /* L300: */
	i1 = apnt[1] - *m;	a1 = -a[i1];
	i2 = apnt[2] - *m;	a2 = -a[i2];
	i3 = apnt[3] - *m;	a3 = -a[i3];

	for (i = 0; i < *m; ++i) {
	    y[i] += a1 * a[i1++] + a2 * a[i2++] + a3 * a[i3++];
	}
	break;

    case 4: /* L400: */
	i1 = apnt[1] - *m;	a1 = -a[i1];
	i2 = apnt[2] - *m;	a2 = -a[i2];
	i3 = apnt[3] - *m;	a3 = -a[i3];
	i4 = apnt[4] - *m;	a4 = -a[i4];

	for (i = 0; i < *m; ++i) {
	    y[i] += a1 * a[i1++] + a2 * a[i2++] + a3 * a[i3++] + a4 * a[i4++];
	}
	break;

    case 5: /* L500: */
	i1 = apnt[1] - *m;	a1 = -a[i1];
	i2 = apnt[2] - *m;	a2 = -a[i2];
	i3 = apnt[3] - *m;	a3 = -a[i3];
	i4 = apnt[4] - *m;	a4 = -a[i4];
	i5 = apnt[5] - *m;	a5 = -a[i5];

	for (i = 0; i < *m; ++i) {
	    y[i] += a1 * a[i1++] + a2 * a[i2++] + a3 * a[i3++] + a4 * a[i4++]
		+   a5 * a[i5++];
	}
	break;

    case 6:  /* L600: */
	i1 = apnt[1] - *m;	a1 = -a[i1];
	i2 = apnt[2] - *m;	a2 = -a[i2];
	i3 = apnt[3] - *m;	a3 = -a[i3];
	i4 = apnt[4] - *m;	a4 = -a[i4];
	i5 = apnt[5] - *m;	a5 = -a[i5];
	i6 = apnt[6] - *m;	a6 = -a[i6];

	for (i = 0; i < *m; ++i) {
	    y[i] += a1 * a[i1++] + a2 * a[i2++] + a3 * a[i3++] + a4 * a[i4++]
		+   a5 * a[i5++] + a6 * a[i6++];
	}
	break;

    case 7: /* L700: */
	i1 = apnt[1] - *m;	a1 = -a[i1];
	i2 = apnt[2] - *m;	a2 = -a[i2];
	i3 = apnt[3] - *m;	a3 = -a[i3];
	i4 = apnt[4] - *m;	a4 = -a[i4];
	i5 = apnt[5] - *m;	a5 = -a[i5];
	i6 = apnt[6] - *m;	a6 = -a[i6];
	i7 = apnt[7] - *m;	a7 = -a[i7];

	for (i = 0; i < *m; ++i) {
	    y[i] += a1 * a[i1++] + a2 * a[i2++] + a3 * a[i3++] + a4 * a[i4++]
		+   a5 * a[i5++] + a6 * a[i6++] + a7 * a[i7++];
	}
	break;

    } /* end { switch } */


/* L2000: */
    for (j = remain; j < *n; j += 8) {
	i1 = apnt[j + 1] - *m;	a1 = -a[i1];
	i2 = apnt[j + 2] - *m;	a2 = -a[i2];
	i3 = apnt[j + 3] - *m;	a3 = -a[i3];
	i4 = apnt[j + 4] - *m;	a4 = -a[i4];
	i5 = apnt[j + 5] - *m;	a5 = -a[i5];
	i6 = apnt[j + 6] - *m;	a6 = -a[i6];
	i7 = apnt[j + 7] - *m;	a7 = -a[i7];
	i8 = apnt[j + 8] - *m;	a8 = -a[i8];

	for (i = 0; i < *m; ++i) {
	    y[i] += a1 * a[i1++] + a2 * a[i2++] + a3 * a[i3++] + a4 * a[i4++]
		+   a5 * a[i5++] + a6 * a[i6++] + a7 * a[i7++] + a8 * a[i8++];
	}
    }

    return 0;
} /* smxpy8_ */

/************************************************************************
 *********************************************************************** */

void
F77_SUB(symfc2)(int *neqns, int *adjlen, int *xadj,
		int *adjncy, int *perm, int *invp, int *colcnt,
		int *nsuper, int *xsuper, int *snode, int *nofsub,
		int *xlindx, int *lindx, int *xlnz, int *mrglnk,
		int *rchlnk, int *marker, int *flag)
{
/*
   Version:	   0.4
   Last modified:  February 13, 1995
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 *************	   SYMFC2 ..... SYMbolic Factorization	  **************
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       This routine performs supernodal symbolic factorization on a
       reordered linear system.	 It assumes access to the columns
       counts, supernode partition, and supernodal elimination tree
       associated with the factor matrix L.

   -----------
   PARAMETERS.
   -----------

   INPUT parameters:
       (i) neqns       -   number of equations
       (i) adjlen      -   length of the adjacency list.
       (i) xadj(*)     -   array of length neqns+1 containing pointers
			   to the adjacency structure.
       (i) adjncy(*)   -   array of length xadj(neqns+1)-1 containing
			   the adjacency structure.
       (i) perm(*)     -   array of length neqns containing the
			   postordering.
       (i) invp(*)     -   array of length neqns containing the
			   inverse of the postordering.
       (i) colcnt(*)   -   array of length neqns, containing the number
			   of nonzeros in each column of the factor,
			   including the diagonal entry.
       (i) nsuper      -   number of supernodes.
       (i) xsuper(*)   -   array of length nsuper+1, containing the
			   first column of each supernode.
       (i) snode(*)    -   array of length neqns for recording
			   supernode membership.
       (i) nofsub      -   number of subscripts to be stored in
			   lindx(*).

   OUTPUT parameters:
       (i) xlindx      -   array of length neqns+1, containing pointers
			   into the subscript vector.
       (i) lindx       -   array of length maxsub, containing the
			   compressed subscripts.
       (i) xlnz	       -   column pointers for l.
       (i) flag	       -   error flag:
			       0 - no error.
			       1 - inconsistancy in the input.

   WORKING parameters:
       (i) mrglnk      -   array of length nsuper, containing the
			   children of each supernode as a linked list.
       (i) rchlnk      -   array of length neqns+1, containing the
			   current linked list of merged indices (the
			   "reach" set).
       (i) marker      -   array of length neqns used to mark indices
			   as they are introduced into each supernode's
			   index set.

 ***********************************************************************
*/
    /* Local variables */
    int i, knz, head, node, tail, pcol, newi, jptr, kptr, jsup,
	ksup, psup, nzbeg, nzend, width, nexti, point, jnzbeg, knzbeg,
	length, jnzend, jwidth, fstcol, knzend, lstcol;

/* ************************************************************************/

    /* Parameter adjustments */
    --marker;
    --xlnz;
    --snode;
    --colcnt;
    --invp;
    --perm;
    --xadj;
    --adjncy;
    --mrglnk;
    --xlindx;
    --xsuper;
    --lindx;

    *flag = 0;
    if (*neqns <= 0) {
	return;
    }

    /* ---------------------------------------------------
       INITIALIZATIONS ...
	   NZEND  : POINTS TO THE LAST USED SLOT IN LINDX.
	   TAIL	  : END OF LIST INDICATOR
		    (IN RCHLNK(*), NOT MRGLNK(*)).
	   MRGLNK : CREATE EMPTY LISTS.
	   MARKER : "UNMARK" THE INDICES.
       --------------------------------------------------- */
    nzend = 0;
    head = 0;
    tail = *neqns + 1;
    point = 1;
    for (i = 1; i <= *neqns; ++i) {
	marker[i] = 0;
	xlnz[i] = point;
	point += colcnt[i];
    }
    xlnz[*neqns + 1] = point;
    point = 1;
    for (ksup = 1; ksup <= *nsuper; ++ksup) {
	mrglnk[ksup] = 0;
	fstcol = xsuper[ksup];
	xlindx[ksup] = point;
	point += colcnt[fstcol];
    }
    xlindx[*nsuper + 1] = point;

    /* ---------------------------
       FOR EACH SUPERNODE KSUP ...
       --------------------------- */
    for (ksup = 1; ksup <= *nsuper; ++ksup) {

	/* ---------------------------------------------------------
	   INITIALIZATIONS ...
	       FSTCOL : FIRST COLUMN OF SUPERNODE KSUP.
	       LSTCOL : LAST COLUMN OF SUPERNODE KSUP.
	       KNZ    : WILL COUNT THE NONZEROS OF L IN COLUMN KCOL.
	       RCHLNK : INITIALIZE EMPTY INDEX LIST FOR KCOL.
	   --------------------------------------------------------- */
	fstcol = xsuper[ksup];
	lstcol = xsuper[ksup + 1] - 1;
	width = lstcol - fstcol + 1;
	length = colcnt[fstcol];
	knz = 0;
	rchlnk[head] = tail;
	jsup = mrglnk[ksup];

	/* -------------------------------------------------
	   IF KSUP HAS CHILDREN IN THE SUPERNODAL E-TREE ...
	   ------------------------------------------------- */
	if (jsup > 0) {
	    /* ---------------------------------------------
	       COPY THE INDICES OF THE FIRST CHILD JSUP INTO
	       THE LINKED LIST, AND MARK EACH WITH THE VALUE
	       KSUP.
	       --------------------------------------------- */
	    jwidth = xsuper[jsup + 1] - xsuper[jsup];
	    jnzbeg = xlindx[jsup] + jwidth;
	    jnzend = xlindx[jsup + 1] - 1;
	    for (jptr = jnzend; jptr >= jnzbeg; --jptr) {
		newi = lindx[jptr];
		++knz;
		marker[newi] = ksup;
		rchlnk[newi] = rchlnk[head];
		rchlnk[head] = newi;
	    }
	    /* ------------------------------------------
	       FOR EACH SUBSEQUENT CHILD JSUP OF KSUP ...
	       ------------------------------------------ */
	    jsup = mrglnk[jsup];
L300:
	    if (jsup != 0 && knz < length) {
		/* ----------------------------------------
		   MERGE THE INDICES OF JSUP INTO THE LIST,
		   AND MARK NEW INDICES WITH VALUE KSUP.
		   ---------------------------------------- */
		jwidth = xsuper[jsup + 1] - xsuper[jsup];
		jnzbeg = xlindx[jsup] + jwidth;
		jnzend = xlindx[jsup + 1] - 1;
		nexti = head;
		for (jptr = jnzbeg; jptr <= jnzend; ++jptr) {
		    newi = lindx[jptr];
L400:
		    i = nexti;
		    nexti = rchlnk[i];
		    if (newi > nexti) {
			goto L400;
		    }
		    if (newi < nexti) {
			++knz;
			rchlnk[i] = newi;
			rchlnk[newi] = nexti;
			marker[newi] = ksup;
			nexti = newi;
		    }
		}
		jsup = mrglnk[jsup];
		goto L300;
	    }
	}
	/* ---------------------------------------------------
	   STRUCTURE OF A(*,FSTCOL) HAS NOT BEEN EXAMINED YET.
	   "SORT" ITS STRUCTURE INTO THE LINKED LIST,
	   INSERTING ONLY THOSE INDICES NOT ALREADY IN THE
	   LIST.
	   --------------------------------------------------- */
	if (knz < length) {
	    node = perm[fstcol];
	    knzbeg = xadj[node];
	    knzend = xadj[node + 1] - 1;
	    for (kptr = knzbeg; kptr <= knzend; ++kptr) {
		newi = adjncy[kptr];
		newi = invp[newi];
		if (newi > fstcol && marker[newi] != ksup) {
		    /* --------------------------------
		       POSITION AND INSERT NEWI IN LIST
		       AND MARK IT WITH KCOL.
		       -------------------------------- */
		    nexti = head;
L600:
		    i = nexti;
		    nexti = rchlnk[i];
		    if (newi > nexti) {
			goto L600;
		    }
		    ++knz;
		    rchlnk[i] = newi;
		    rchlnk[newi] = nexti;
		    marker[newi] = ksup;
		}
	    }
	}
	/* ------------------------------------------------------------
	   IF KSUP HAS NO CHILDREN, INSERT FSTCOL INTO THE LINKED LIST.
	   ------------------------------------------------------------ */
	if (rchlnk[head] != fstcol) {
	    rchlnk[fstcol] = rchlnk[head];
	    rchlnk[head] = fstcol;
	    ++knz;
	}

	/* --------------------------------------------
	   COPY INDICES FROM LINKED LIST INTO LINDX(*).
	   -------------------------------------------- */
	nzbeg = nzend + 1;
	nzend += knz;
	if (nzend + 1 != xlindx[ksup + 1]) { /* L8000 : */
	    /* -----------------------------------------------
	       INCONSISTENCY IN DATA STRUCTURE WAS DISCOVERED.
	       ----------------------------------------------- */
	    *flag = -2;
	    return;
	}
	i = head;
	for (kptr = nzbeg; kptr <= nzend; ++kptr) {
	    i = rchlnk[i];
	    lindx[kptr] = i;
	}

	/* ---------------------------------------------------
	   IF KSUP HAS A PARENT, INSERT KSUP INTO ITS PARENT'S
	   "MERGE" LIST.
	   --------------------------------------------------- */
	if (length > width) {
	    pcol = lindx[xlindx[ksup] + width];
	    psup = snode[pcol];
	    mrglnk[ksup] = mrglnk[psup];
	    mrglnk[psup] = ksup;
	}

    }

    return;
} /* symfc2 */

/***********************************************************************
 *********************************************************************** */
int
F77_SUB(symfct)(int *neqns, int *adjlen, int *xadj,
		int *adjncy, int *perm, int *invp, int *colcnt,
		int *nsuper, int *xsuper, int *snode, int *nofsub,
		int *xlindx, int *lindx, int *xlnz, int *iwsiz,
		int *iwork, int *flag)
{
/*
   Version:	   0.4
   Last modified:  February 13, 1995
   Authors:	   Esmond G. Ng and Barry W. Peyton

   Mathematical Sciences Section, Oak Ridge National Laboratory

 ***********************************************************************
 ***********************************************************************
 *************	   SYMFCT ..... SYMBOLIC FACTORIZATION	  **************
 ***********************************************************************
 ***********************************************************************

   PURPOSE:
       This routine calls symfc2 which performs supernodal symbolic
       factorization on a reordered linear system.

       -----------
       PARAMETERS.
       -----------

   INPUT parameters:
       (i) neqns       -   number of equations
       (i) adjlen      -   length of the adjacency list.
       (i) xadj(*)     -   array of length neqns+1 containing pointers
			   to the adjacency structure.
       (i) adjncy(*)   -   array of length xadj(neqns+1)-1 containing
			   the adjacency structure.
       (i) perm(*)     -   array of length neqns containing the
			   postordering.
       (i) invp(*)     -   array of length neqns containing the
			   inverse of the postordering.
       (i) colcnt(*)   -   array of length neqns, containing the number
			   of nonzeros in each column of the factor,
			   including the diagonal entry.
       (i) nsuper      -   number of supernodes.
       (i) xsuper(*)   -   array of length nsuper+1, containing the
			   first column of each supernode.
       (i) snode(*)    -   array of length neqns for recording
			   supernode membership.
       (i) nofsub      -   number of subscripts to be stored in
			   lindx(*).
       (i) iwsiz       -   size of integer working storage.

   OUTPUT parameters:
       (i) xlindx      -   array of length neqns+1, containing pointers
			   into the subscript vector.
       (i) lindx       -   array of length maxsub, containing the
			   compressed subscripts.
       (i) xlnz	       -   column pointers for l.
       (i) flag	       -   error flag:
			       0 - no error.
			      -1 - insufficient integer working space.
			      -2 - inconsistancy in the input.

   working parameters:
       (i) iwork       -   working array of length nsuper+2*neqns.

 ***********************************************************************
*/
    *flag = 0;
    if (*iwsiz < *nsuper + (*neqns << 1) + 1) {
	*flag = -1; return 0;
    }
    F77_CALL(symfc2)(neqns, adjlen, xadj, adjncy, perm, invp,
		     colcnt, nsuper, xsuper, snode, nofsub,
		     xlindx, lindx, xlnz,
		     iwork, &iwork[*nsuper], &iwork[*nsuper + *neqns + 1],
		     flag);
    return 0;
} /* symfct_ */
