\name{predict.rq}
\alias{predict.rq}
\alias{predict.rqs}
\alias{predict.rq.process}
\title{Quantile Regression Prediction}
\description{
Prediction based on fitted quantile regression model
}
\usage{
\method{predict}{rq}(object, newdata, se.fit = FALSE, type = NULL, na.action = na.pass, ...)
\method{predict}{rqs}(object, newdata, se.fit = FALSE, type = NULL, na.action = na.pass, ...)
\method{predict}{rq.process}(object, newdata, se.fit = FALSE, type = NULL, na.action = na.pass, ...)
}
\arguments{
  \item{object}{ object of class rq produced by \code{rq} }
  \item{newdata}{An optional data frame in which to look for variables with
    which to predict.  If omitted, the fitted values are used.}
  \item{se.fit}{Flag indicating whether standard errors are
    desired, not yet implemented.}
  \item{type}{If equal to "stepfun"  return list of stepfunctions otherwise
    return matrix of predictions.}
  \item{na.action}{ function determining what should be done with missing values
    in 'newdata'.  The default is to predict 'NA'.}
  \item{\dots}{ Further arguments passed to or from other methods.}
}
\details{
     Produces predicted values, obtained by evaluating the quantile
     regression function in the frame 'newdata' (which defaults to
     'model.frame(object)'.  These predictions purport to estimate
    the conditional quantile function of the response variable of
    the fitted model evaluated at the covariate values specified
    in "newdata" and the quantile(s) specified by the "tau" argument.
}
\value{
     A matrix of predictions, unless type == "stepfun" in which case a
     \code{stepfun} object or a list of \code{stepfun} objects is produced.
     In the case that there are multiple taus in \code{object}
     the function \code{rearrange} can be used to monotonize these
     step-functions, if desired.
}
\references{ }
\author{R. Koenker}
\seealso{ \code{\link{rq}} \code{\link{rearrange}}}
\examples{
data(airquality)
airq <- airquality[143:145,]
f <- rq(Ozone ~ ., data=airquality)
predict(f,newdata=airq)
f <- rq(Ozone ~ ., data=airquality, tau=1:19/20)
fp <- predict(f, newdata=airq, type="stepfun")
fpr <- rearrange(fp)
  }
\keyword{regression}
