      SUBROUTINE qrcens(xx,y,yc,nx,nobs,beta,wa,nobs1,nx2,z,pr,prcens,
     &                  cens,varb,varn,toler,optimum,theta,eflag,wflag)
c
c     Algorithm BRCENS for Censored Quantile Regression
c     at quantile theta in (0,1)
c
c     Version: 12 / Februar / 97  Copyright: Bernd Fitzenberger
c
c     Required changes:
c     mnobs = Number of observations
c     mnx   = Maximum number of regressors
c
      IMPLICIT REAL*8 (a-h,o-z)
      INTEGER mnobs,mnx
c     Changes Required
      PARAMETER (mnobs=17787,mnx=30)
c     End of Changes Required
      INTEGER nobs,nx,in,out,prcens(nobs),nx1,nx2,nobs1,setuptable,
     & idgt,ier,upfreq,pklim,outsave,outmcr,varin
      REAL*8 zero,one,two,big,theta,omtheta,r,minsum,minmcr,mcrin
      PARAMETER (zero=0.d0,one=1.d0,two=2.d0,
     & big=1.d75,mnxsq=mnx*mnx,idgt=8,upfreq=400,pklim=500)
      INTEGER i,j,varb(nobs),varn(nx),kr,crun,var,cens(nobs),di,k,kl,
     & s,kount,pkount,l,i1,j1
      REAL*8 xx(nobs,nx),y(nobs),yc(nobs),beta(nx),wa(nobs1,nx2),sum,
     & pr(nobs),z(nobs),toler,d,mini,maxi,pivot,b1(mnobs),b2(mnobs),
     & wk(mnxsq),wa1(mnxsq),wa2(mnxsq),savest(mnx),objective
      LOGICAL coef,varcens,optimum,sit1b,sit2bc,intbcens
      INTEGER numout,varout(mnobs),insave,numkount,pn,eflag,wflag
      EXTERNAL mab8,tabcheck,r,objective

	pn = 7
c      EXTERNAL tabprint,setuptabl,mab8,tabcheck,r,objective
c     INITIALIZATION
      kr = 1
      setuptable = 1
c      setuptable = 1
      kount = 0
      numkount = 0
      pkount = 1
      nx1=nx+1
      minsum = big
c      write(pn,'(a,i10)') 'kount = ',kount
c      theta = 0.5d0
      omtheta=one-theta
c      write(pn,'(a,f5.2)') 'theta = ',theta
      optimum = .false.
	eflag = 0
	wflag = 0
c     Initialize z
      do 20 i = 1,nobs
      if (yc(i)-y(i).lt.toler) then
         z(i) = 0.d0
         if (cens(i).ne.1) then
	      eflag = 1
c            write(pn,'(a)') 'cens(.) incorrect'
            goto 1000
            endif
         else
         z(i) = yc(i) - y(i)
         if (cens(i).ne.0) then
	      eflag = 1
c            write(pn,'(a)') 'cens(.) incorrect'
            goto 1000
            endif
         endif
 20      continue
      kl = 1
      do 1040 i = 1,nobs
         wa(i,nx1) = y(i)
         varb(i) = i
 1040    continue
      do 1050 j = 1,nx
      do 1060 i = 1,nobs
         wa(i,j) = xx(i,j)
 1060    continue
      varn(j) = nobs+j
 1050    continue
c      write(pn,'(/,a,/)') 'Start Stage 1 '
 10   continue
c     Adjust Basis for negative variables
      do 1070 i = 1,nobs
      if (wa(i,nx1).lt.zero) then
         varb(i) = -varb(i)
         do 1080 j = 1,nx1
            wa(i,j) = -wa(i,j)
 1080          continue
         endif
 1070    continue
c     Put current values of coef's from into beta and calculate fit pr
      do 1090 j = 1,nx
      beta(j) = 0.d0
 1090    continue
      do 1100 i = 1,kl-1
         beta(abs(varb(i))-nobs) = dble(isign(1,varb(i)))*wa(i,nx1)
 1100    continue
c     Determine PRedicted values: pr
      call mab8(xx,nobs,nx,beta,nx,1,pr,eflag)
c      call dgemul(xx,nobs,'N',beta,nx,'N',pr,
c     &            nobs,nobs,nx,1)
c
c      do 1110 j = 1,nx   
c         write(pn,'(a,i3,a,f15.8)') 'beta(',j,') = ',beta(j)
c 1110    continue
c
c     Use current fit to determine if pr is censored 
c     and calculate wa(i,nx2) = sgn(y(i)-x(i)'beta)*(yc(i)-x(i)'beta)
c     prcens(i) = 0  if  x'b < yc
c                 1          =
c                 2          >
      do 1150 i = 1,nobs
      d = yc(i)-pr(i)
      if (d.gt.toler) then
         prcens(i) = 0
         else if (abs(d).le.toler) then
         prcens(i) = 1
         else
         prcens(i) = 2
         endif
 1150    continue
      sum = zero   
      do 25 i = kl,nobs
         var = abs(varb(i))
         d = yc(var)-pr(var)
         wa(i,nx2) = sign(1.d0,y(var)-pr(var))*d
         sum = sum + r(theta,y(var)-min(pr(var),yc(var)))
 25      continue
      wa(nobs1,nx1) = sum
c      write(pn,'(a,f15.8,/)') 'Value of Objective : ',wa(nobs1,nx1)
c     Control Print of Tableau
c      call tabprint(wa,varb,varn,pr,prcens,z,nobs1,nobs,nx,nx2,
c     &              pkount,kl,cens)
c      if (pkount.eq.pklim) goto 1000
c     Control Print of Tableau
c
c     Calculate Marginal Cost - Stage 1
c
 30   do 80 j = 1,nx
         var = abs(varn(j))
         if (var.le.nobs) goto 80
         crun = 0
 35      wa(nobs1,j) = zero
         do 40 i = kl,nobs
            if (prcens(abs(varb(i))).eq.2) goto 40
            var = varb(i)
            d = wa(i,j)
            if (prcens(abs(varb(i))).eq.0) goto 50
            if ((d.lt.-toler).and.(varb(i).gt.0)) then
               d = d*theta
               goto 60
               endif
            if ((d.gt.toler).and.(varb(i).lt.0)) goto 50
            goto 40
 50         if ((wa(i,nx1).lt.toler).and.(d.gt.zero)) then
               var = -var
               d = -d
               endif
            if (var.gt.0) then
               d = d*theta
               else
               d = d*omtheta
               endif
 60         wa(nobs1,j) = wa(nobs1,j) + d
c         write(pn,'(a,i7,a,i7,a,e16.9)') 
c     &        'MCR ohne nb: wa(',nobs1,',',j,') = ',wa(nobs1,j)
 40         continue
         if (crun.eq.1) goto 80
         crun = 1
         if (wa(nobs1,j).lt.toler) then
c        Change sign in column b/c MC < 0 and MC of 
c              -varn(j) could be positive
            varn(j) = -varn(j)
            do 1155 i = 1,nobs
 1155          wa(i,j) = -wa(i,j)
            goto 35
            endif
 80      continue
c     Determine the vector to enter the basis or if optimal 
c     solution found - Stage 1
 90   mcrin = -one
      do 100 j = 1,nx
c         write(pn,'(a,i7,a,i7,a,e16.9)') 
c     &        'MCR: wa(',nobs1,',',j,') = ',wa(nobs1,j)
         var = abs(varn(j))
         if (var.le.nobs) goto 100
         if (wa(nobs1,j).le.mcrin) goto 100
         mcrin = wa(nobs1,j)
         in = j
 100     continue
c     Control Print of Tableau
c      call tabprint(wa,varb,varn,pr,prcens,z,nobs1,nobs,nx,nx2,
c     &              pkount,kl,cens)
c      if (pkount.eq.pklim) goto 1000
c     Control Print of Tableau
      if (mcrin.le.toler) then
c       write(pn,'(/,a,f15.8)') 'Value of Objective : ',wa(nobs1,nx1)
c      do 1160 j = 1,nx
c         write(pn,'(a,i3,a,f15.8)') 'beta(',j,') = ',beta(j)
c 1160    continue
c        Go To State 2 and recalculate the Marginal Costs
c         write(pn,'(/,a,/)') 'Start Stage 2 '
         goto 230   
         endif
c *********
c      write(pn,'(2(a,i8,2x))') 'Iter:',kount,'Into Basis Var:',varn(in)
c *********
c     DETERMINE the vector to leave the basis
 110  k = 0
      do 115 i = kl,nobs
         d = wa(i,in)
         b1(i) = big
         b2(i) = big
         if (abs(d).le.toler) go to 115
         b1(i) = wa(i,nx1)/d
         b2(i) = wa(i,nx2)/d
 115     continue
      varin = abs(varn(in))
 120  mini = big   
      numout = 0
      do 130 i = kl,nobs
         if ((b1(i).ge.mini).or.(b1(i).lt.toler)) goto 130
         mini = b1(i)
c         out = i
 130     continue
      do 150 i = kl,nobs
         sit1b = abs(b1(i)-mini).le.toler
         sit2bc = (b2(i).le.mini+toler).and.(b2(i).gt.toler)
         if (.not.(sit1b.or.sit2bc)) go to 150
c        s = 0
         pivot = wa(i,in)
         if (sit1b) then
            numout = numout + 1
            varout(numout) = i
            b1(i) = big
            if (.not.(sit2bc)) then
c               mcrin = mcrin - two*pivot
               mcrin = mcrin - pivot
c              s = 1            
               else 
               b2(i) = big
c               mcrin = mcrin - pivot
               mcrin = mcrin - theta*pivot
c              s = 3 and s = 5
               endif
            else
            b2(i) = big
c            mcrin = mcrin + abs(pivot)
            mcrin = mcrin + omtheta*abs(pivot)
c           s = 2 and s = 4
            endif
 150     continue
c      pivot = wa(out,in)
c      write(pn,'(a,i7,3(/a,f8.3))')
c     & 'Check to leave Basis Var # : ',varb(out),' Pivot = ',pivot,
c     & ' b1(out) = ',wa(out,nx1)/pivot,
c     & ' b2(out) = ',wa(out,nx2)/pivot
      if (mcrin.gt.toler) then
c         write(pn,'(a,i7,a,i7,a,e16.9)') 
c     &        'MCR: wa(',nobs1,',',in,') = ',mcrin
         outsave = out
         goto 120
         endif
      if (numout.ge.1) out = varout(1)
c      write(pn,'(/,a,i7,a,i7,a,e16.9,/)') 
c     &        'MCR: wa(',nobs1,',',in,') = ',mcrin
      pivot = wa(out,in)
      insave = in
c Pivot on WA(out,in)         
c      write(pn,'(a,i6,a,i6,a,f8.3,2(/a,i7))') 'Pivot on WA(',
c     &          out,',',in,') = ',pivot,
c     &         'Out Var # ',varb(out),'In  Var # ',varn(in)
      do 170 j = kr,nx1
         if (j.eq.in) goto 170
         wa(out,j) = wa(out,j)/pivot
 170     continue
      do 190 i = 1,nobs
      if (i.eq.out) goto 190
      d = wa(i,in)
      do 180 j = kr,nx1
         if (j.eq.in) goto 180
         wa(i,j) = wa(i,j) - d*wa(out,j)
 180        continue
 190     continue   
      do 200 i = 1,nobs   
      if (i.eq.out) goto 200
      wa(i,in) = -wa(i,in)/pivot
 200     continue
      wa(out,in) = one/pivot
      di = varb(out)
      varb(out) = varn(in)
      varn(in) = di
      kount = kount + 1
c   end after pklim iter
      if ((kount-1).eq.pklim) then
	   wflag = 1
c         write(pn,'(a)') 'MAXITER reached !!!!!!!!'
c      write(pn,'(a)') 'Current NonBasis-Variables'
c         do 201 j1 = 1,nx 
c            write(pn,'(i3,a,i10)') j1,
c     &            'th-Interpolated Observation = ',varn(j1)
c 201        continue
         goto 1000
         endif
c   end after pklim iter
c     Interchange Rows in Stage 1
      do 1180 j = kr,nx2
      d = wa(out,j)
      wa(out,j) = wa(kl,j)
      wa(kl,j) = d
 1180    continue
      di = varb(out)
      varb(out) = varb(kl)
      varb(kl) = di
      kl = kl + 1
c      write(pn,'(2(a10,i6))') 'Kount = ',kount,' kl = ',kl
c     update if mod(kount,upfreq) = 0
      if (mod(kount,upfreq).eq.0) then
c      write(pn,'(/,a,/,a,i6,a)') 
c     &   '***************************************',
c     &   'Tableau Update after ',kount,' iterations '
cc      call setuptabl(wa,varn,varb,xx,y,yc,beta,pr,prcens,cens,
cc     &                     nobs,nx,nobs1,nx2,kl,toler)
c      write(pn,*) 'Setuptable '
      call tabcheck(xx,wa,varb,varn,nobs1,nobs,nx,nx2,toler,wflag)
c      do 1190 j1 = 1,nx   
c         write(pn,'(a,i3,a,f15.8)') 'beta(',j1,') = ',beta(j1)
c 1190       continue
c      write(pn,'(/,a,f15.8,/)') 'Value of Objective : ',wa(nobs1,nx1)
      wa(nobs1,nx1) = big
c      do 1200 j1 = 1,nx   
c         write(pn,'(i3,a,i10)') j1,
c     &            'th-Interpolated Observation = ',varn(j1)
c 1200       continue
c      write(pn,*) ' '
      endif
c     end of update if mod(kount,upfreq) = 0      
c     Control Print of Tableau
c      call tabprint(wa,varb,varn,pr,prcens,z,nobs1,nobs,nx,nx2,
c     &              pkount,kl,cens)
c      if (pkount.eq.pklim) goto 1000
c     Control Print of Tableau
      if (kl.le.nx) go to 10
c      
c     Start Stage 2
c
c      write(pn,'(/,a,/)') 'Start Stage 2 '
 205  continue
c     Adjust Basis for negative variables
      do 1210 i = 1,nobs
      if (wa(i,nx1).lt.zero) then
         varb(i) = -varb(i)
         do 1220 j = 1,nx1
            wa(i,j) = -wa(i,j)
 1220       continue
         endif
 1210    continue
c     Put current values of coef's from into beta and calculate fit pr
      do 1230 j = 1,nx
      beta(j) = zero
 1230 continue
      do 1240 i = 1,kl-1
         beta(abs(varb(i))-nobs) = dble(isign(1,varb(i)))*wa(i,nx1)
 1240    continue
c    Determine PRedicted values : pr
      call mab8(xx,nobs,nx,beta,nx,1,pr,eflag)
c      call dgemul(xx,nobs,'N',beta,nx,'N',pr,
c     &            nobs,nobs,nx,1)
c
c      do 1250 j = 1,nx   
c         write(pn,'(a,i3,a,f15.8)') 'beta(',j,') = ',beta(j)
c 1250    continue
c     Check for Update : if residual > toler
c      do 1260 j = 1,nx
c      var = abs(varn(j))
c      if (var.le.nobs) then
c         d = abs(y(var)-min(pr(var),yc(var)))
c         if (d.gt.10.d0*toler) then  
c            write(pn,'(/,a,/,a,i6,a)') 
c     &         '***************************************',
c     &         'Tableau Update after ',kount,' iterations - Res'
c            call setuptabl(wa,varn,varb,xx,y,yc,beta,pr,prcens,cens,
c     &                     nobs,nx,nobs1,nx2,kl,toler)
c      write(pn,*) 'Setuptable '
      call tabcheck(xx,wa,varb,varn,nobs1,nobs,nx,nx2,toler,wflag)
c      do 1270 j1 = 1,nx   
c         write(pn,'(a,i3,a,f15.8)') 'beta(',j1,') = ',beta(j1)
c 1270       continue
c      write(pn,'(/,a,f15.8,/)') 'Value of Objective : ',wa(nobs1,nx1)
c      wa(nobs1,nx1) = big
c      do 1280 j1 = 1,nx   
c         write(pn,'(i3,a,i10)') j1,
c     &            'th-Interpolated Observation = ',varn(j1)
c 1280       continue
c      write(pn,*) ' '
c            goto 205
c            endif
c         endif
c 1260 continue   
c     end of Check for Update : if residual > toler
c
c     Use current fit to determine if pr is censored 
c     and calculate wa(i,nx2) = sgn(y(i)-x(i)'beta)*(yc(i)-x(i)'beta)
c     prcens(i) = 0  if  x'b < yc
c                 1          =
c                 2          >
      do 1290 i = 1,nobs
         d = yc(i)-pr(i)
         if (d.gt.toler) then
            prcens(i) = 0
            else if (abs(d).le.toler) then
            prcens(i) = 1
            else
            prcens(i) = 2
            endif
 1290    continue
      sum = zero   
      do 215 i = kl,nobs
         var = abs(varb(i))
         d = yc(var)-pr(var)
         wa(i,nx2) = sign(1.d0,y(var)-pr(var))*d
         sum = sum + r(theta,y(var)-min(pr(var),yc(var)))
 215     continue
c      write(pn,'(a,f15.8,/)') 'Value of Objective : ',sum
c
c     Keep lowest value of objective reached
c
      if (sum.lt.(minsum-(toler/1.d1))) then
         do j1 = 1,nx
            savest(j1) = beta(j1)
            enddo
         minsum = sum
         optimum = .false.
c
c     Stop if iteration on same value of objective
c
      else if ( (setuptable.eq.1) .and.
     &   (abs(sum-minsum).lt.(toler/1.d1) ) ) then
         optimum = .true.
         goto 1000
         endif
c
c     Increase or No Change in Objective
c
      if (wa(nobs1,nx1)-sum.le.-toler) then
c         write(pn,'(3(/a40)/)')
c     &    '*************************************',
c     &    '******Increase in Objective**********',
c     &    '*************************************'
c         write(pn,'(/,a,f15.8,/)') 'Old Value of Objective : ',
c     &                             wa(nobs1,nx1)
c         write(pn,'(/,a,f15.8,/)') 'New Value of Objective : ',
c     &                             sum
c         do 1307 j1 = 1,nx   
c 1307       write(pn,'(a,i3,a,f15.8)') 'beta(',j1,') = ',beta(j1)
         if (setuptable.eq.0) then
c           write(pn,'(/,a,/,a,i6,a)') 
c     &      '***************************************',
c     &      'Tableau Update after ',kount,' iterations '
c            write(pn,'(/,a,/)') 'Before SETUPTABLE :'
c            do j = 1,nx
c               write(pn,'(a,i7,a,i7,a,e16.9)') 
c     &           'MCR: wa(',nobs1,',',j,') = ',wa(nobs1,j)
c               enddo
c            call setuptabl(wa,varn,varb,xx,y,yc,beta,pr,prcens,cens,
c     &                  nobs,nx,nobs1,nx2,kl,toler,theta)
            call tabcheck(xx,wa,varb,varn,nobs1,nobs,nx,nx2,toler,wflag)
c            write(pn,'(/,a,/)') 'After SETUPTABLE :'
c            do 1360 j1 = 1,nx   
c 1360          write(pn,'(a,i3,a,f15.8)') 'beta(',j1,') = ',beta(j1)
            setuptable = 1
            endif
      else if (wa(nobs1,nx1)-sum.le.toler) then
c         write(pn,'(3(/a40)/)')
c     &    '*************************************',
c     &    '******No Change in Objective*********',
c     &    '*************************************'
c         write(pn,'(/,a,f15.8,/)') 'Old Value of Objective : ',
c     &                             wa(nobs1,nx1)
c         write(pn,'(/,a,f15.8,/)') 'New Value of Objective : ',
c     &                             sum
         if (setuptable.eq.0) then
c            write(pn,'(/,a,/)') 'Before SETUPTABLE :'
c            do j = 1,nx
c               write(pn,'(a,i7,a,i7,a,e16.9)') 
c     &           'MCR: wa(',nobs1,',',j,') = ',wa(nobs1,j)
c               enddo
c            call setuptabl(wa,varn,varb,xx,y,yc,beta,pr,prcens,cens,
c     &                  nobs,nx,nobs1,nx2,kl,toler,theta)
            call tabcheck(xx,wa,varb,varn,nobs1,nobs,nx,nx2,toler,wflag)
c            write(pn,'(/,a,/)') 'After SETUPTABLE :'
c            do 1361 j1 = 1,nx   
c 1361          write(pn,'(a,i3,a,f15.8)') 'beta(',j1,') = ',beta(j1)
            setuptable = 1
            else if (optimum) then
            do 1300 j1 = 1,nx   
c               write(pn,'(a,i3,a,f15.8)') 'beta(',j1,') = ',beta(j1)
               beta(j1) = savest(j1)
 1300          continue
            goto 1000
            else
			 wflag = 2
c            write(pn,'(a)') 'No SETUPTABLE - No OPTIMUM'
c            write(pn,'(/,a,/)') 
c     &      'Optimal Solution which is probably NON-UNIQUE'
            endif
         endif
      wa(nobs1,nx1) = sum
c     Control Print of Tableau
c      call tabprint(wa,varb,varn,pr,prcens,z,nobs1,nobs,nx,nx2,
c     &              pkount,kl,cens)
c      if (pkount.eq.pklim) goto 1000
c     Control Print of Tableau
c
c     Calculate Marginal Cost - Stage 2
c
 230  do 280 j = 1,nx
         var = abs(varn(j))
         if (var.gt.nobs) then
            coef = .true.
            else 
            coef = .false.
            endif
         crun = 0
 235     wa(nobs1,j) = zero
         do 240 i = kl,nobs
            if (prcens(abs(varb(i))).eq.2) goto 240
            var = varb(i)
            d = wa(i,j)
            if (prcens(abs(varb(i))).eq.0) goto 250
            if ((d.lt.-toler).and.(varb(i).gt.0)) then
               d = d*theta
               goto 260
               endif
            if ((d.gt.toler).and.(varb(i).lt.0)) goto 250
            goto 240
 250        if ((wa(i,nx1).lt.toler).and.(d.gt.zero)) then
               var = -var
               d = -d
               endif
            if (var.gt.0) then
               d = d*theta
               else
               d = d*omtheta
               endif
 260        wa(nobs1,j) = wa(nobs1,j) + d
c         write(pn,'(a,i4,a,i2,a,f15.9)') 
c     &        'MCR ohne nb: wa(',nobs1,',',j,') = ',wa(nobs1,j)
 240        continue
      if (coef) goto 270
c     Next line for case when censored obs in nonbasis
      if ((cens(var).eq.1).and.(varn(j).lt.0)) goto 270
      if (varn(j).gt.0) then 
         wa(nobs1,j) = wa(nobs1,j) - theta
         else 
         wa(nobs1,j) = wa(nobs1,j) - omtheta
         endif
c         write(pn,'(a,i4,a,i2,a,f15.9)') 
c     &        'MCR: wa(',nobs1,',',j,') = ',wa(nobs1,j)
 270     if (crun.eq.1) goto 280
      crun = 1
c      if ( ((.not.coef).and.(wa(nobs1,j)+two.lt.toler)) .or.
c     &        ((     coef).and.(wa(nobs1,j)    .lt.toler)) ) then
      if ( ((.not.coef).and.(wa(nobs1,j)+one.lt.toler)) .or.
     &        ((     coef).and.(wa(nobs1,j)    .lt.toler)) ) then
c        Change sign in column b/c MC < 0 and MC of 
c              -varn(j) could be positive
         varn(j) = -varn(j)
         do 1310 i = 1,nobs
            wa(i,j) = -wa(i,j)
 1310       continue
         goto 235
         endif
 280     continue
c     Control Print of Tableau
c      call tabprint(wa,varb,varn,pr,prcens,z,nobs1,nobs,nx,nx2,
c     &              pkount,kl,cens)
c      if (pkount.eq.pklim) goto 1000
c     Control Print of Tableau
c     Determine the vector to enter the basis or if optimal 
c               solution found - Stage 2
 290  mcrin = -one
      do 1320 j = 1,nx
      if (wa(nobs1,j).gt.mcrin) then
         mcrin = wa(nobs1,j)
         in = j
         endif
 1320    continue
c     Control Print of Tableau
c      call tabprint(wa,varb,varn,pr,prcens,z,nobs1,nobs,nx,nx2,
c     &              pkount,kl,cens)
c      if (pkount.eq.pklim) goto 1000
c     Control Print of Tableau
c
c     Main Check for Optimum
c
      if (mcrin.le.toler) then
c         write(pn,'(3(/a40)/)')
c     &     '*************************************',
c     &     '******Optimal Solution found*********',
c     &     '*************************************'
c         write(pn,'(a)') 'Current NonBasis-Variables'
c         do 1321 j1 = 1,nx 
c            write(pn,'(i3,a,i10,a,e12.3)') j1,
c     &          'th-Interpolated Observation = ',varn(j1),
c     &          ' MCosts: ',wa(nobs1,j1)
c 1321       continue
         if ((numout.gt.1).and.(numkount.lt.5)) then
c            write(pn,'(a12,i6)') 'numout = ',numout
c            write(pn,'(a12,i6)') 'varout(1) = ',varout(1)
            numout = numout - 1
            do 1322 i = 1,numout
 1322          varout(i) = varout(i+1)
            out = varout(1)
            in = insave
            if (numout.eq.1) numkount = numkount + 1
            goto 365
            endif
c         if (mcrin.ge.-toler) then
c            write(pn,'(/,a,/)') 
c     &      'Optimal Solution which is probably NON-UNIQUE'
c            endif
c         do 1330 j = 1,nx
c 1330       write(pn,'(a,i3,a,f15.8)') 'beta(',j,') = ',beta(j)
c         write(pn,'(/,a,f15.8)') 'Value of Objective : ',minsum
         optimum = .true. 
         if (mcrin.lt.-toler) then
            do 1325 j1 = 1,nx   
 1325          beta(j1) = savest(j1) 
            goto 1000
            endif
         endif
c *********
c      write(pn,'(2(a,i8,2x))') 'Iter:',kount,'Into Basis Var:',varn(in)
c *********
c     DETERMINE the vector to leave the basis
 310  k = 0
      do 315 i = kl,nobs
         d = wa(i,in)
         b1(i) = big
         b2(i) = big
         if (abs(d).le.toler) go to 315
         b1(i) = wa(i,nx1)/d
         b2(i) = wa(i,nx2)/d
 315     continue
      varin = abs(varn(in))
      if ((varn(in).lt.0).and.(cens(varin).eq.0)) then
c        Case uncensored obs in nonbasis
         intbcens = .true.
         else
         intbcens = .false.
         endif
 320  mini = big   
      minmcr = big
      numout = 0
      out = 0
      do 330 i = kl,nobs
 330     if ((b1(i).lt.mini).and.(b1(i).ge.toler)) mini = b1(i)
      if (mini.gt.(big*toler)) then
         out = outmcr
         goto 365
         endif
c     Check if step such that censoring value reached for nonbasic var
c     to come into basis : IN
      if (intbcens) then
         if (mini.ge.z(varin)) then
            intbcens = .false.
            mcrin = mcrin + omtheta
            endif
         endif
c     Check, if there are more at mini
      do 350 i = kl,nobs
         sit1b = abs(b1(i)-mini).le.toler
         sit2bc = (b2(i).le.mini+toler).and.(b2(i).gt.toler)
         if (.not.(sit1b.or.sit2bc)) go to 350
c        s = 0
         pivot = wa(i,in)
         if (sit1b) then
            numout = numout + 1
            varout(numout) = i
            b1(i) = big
            if (.not.(sit2bc)) then
c               mcrin = mcrin - two*pivot
               mcrin = mcrin - pivot
c              s = 1            
               else 
               b2(i) = big
c               mcrin = mcrin - pivot
               mcrin = mcrin - theta*pivot
c              s = 3 and s = 5
               endif
            else
            b2(i) = big
c            mcrin = mcrin + abs(pivot)
            mcrin = mcrin + omtheta*abs(pivot)
c           s = 2 and s = 4
            endif
 350     continue
c      pivot = wa(out,in)
      if (numout.ge.1) out = varout(1)
      if (mcrin.lt.minmcr) then
         minmcr = mcrin
         outmcr = outsave
         endif
      if ((mcrin.gt.toler).and.(out.ne.0)) then
         outsave = out
         goto 320
         endif
      if (out.eq.0) then
         out = outsave
         endif
c      write(pn,'(a,i7,3(/a,f8.3))')
c     & 'Check to leave Basis Var # : ',varb(out),' Pivot = ',pivot,
c     & ' b1(out) = ',wa(out,nx1)/pivot,
c     & ' b2(out) = ',wa(out,nx2)/pivot
c
 365  insave = in
      pivot = wa(out,in)
c
c Pivot on WA(out,in)         
c      write(pn,'(a,i6,a,i6,a,f10.5,2(/a,i7))') 'Pivot on WA(',
c     &          out,',',in,') = ',pivot,
c     &         'Out Var # ',varb(out),'In  Var # ',varn(in)
      do 370 j = kr,nx1
         if (j.eq.in) goto 370
         wa(out,j) = wa(out,j)/pivot
 370     continue
      do 390 i = 1,nobs
         if (i.eq.out) goto 390
         d = wa(i,in)
         do 380 j = kr,nx1
            if (j.eq.in) goto 380
            wa(i,j) = wa(i,j) - d*wa(out,j)
 380        continue
 390     continue   
      do 400 i = 1,nobs   
         if (i.eq.out) goto 400
         wa(i,in) = -wa(i,in)/pivot
 400     continue
      wa(out,in) = one/pivot
      di = varb(out)
      varb(out) = varn(in)
      varn(in) = di
      kount = kount + 1
c   end after pklim iter
      if ((kount-1).eq.pklim) then
		 wflag = 1
c         write(pn,'(a)') 'MAXITER reached !!!!!!!!'
         goto 1000
         endif
c   end after pklim iter
c     Interchange Rows if out is a coef
      if (abs(varb(out)).gt.nobs) then
      do 1350 j = kr,nx2
         d = wa(out,j)
         wa(out,j) = wa(kl,j)
         wa(kl,j) = d
 1350       continue
      di = varb(out)
      varb(out) = varb(kl)
      varb(kl) = di
      kl = kl + 1
      endif
c      write(pn,'(2(a10,i6))') 'Kount = ',kount,' kl = ',kl
c     update if mod(kount,upfreq) = 0
      if (mod(kount,upfreq).eq.0) then
c      write(pn,'(/,a,/,a,i6,a)') 
c     &   '***************************************',
c     &   'Tableau Update after ',kount,' iterations '
c      call setuptabl(wa,varn,varb,xx,y,yc,beta,pr,prcens,cens,
c     &                     nobs,nx,nobs1,nx2,kl,toler)
c      call tabcheck(xx,wa,varb,varn,nobs1,nobs,nx,nx2,toler,wflag)
c      write(pn,*) 'Setuptable '
c      do 1360 j1 = 1,nx   
c         write(pn,'(a,i3,a,f15.8)') 'beta(',j1,') = ',beta(j1)
c 1360       continue
c      write(pn,'(/,a,f15.8,/)') 'Value of Objective : ',wa(nobs1,nx1)
      wa(nobs1,nx1) = big
c      do 1370 j1 = 1,nx   
c         write(pn,'(i3,a,i10)') j1,
c     &            'th-Interpolated Observation = ',varn(j1)
c 1370       continue
c      write(pn,*) ' '
      endif
c     end of update if mod(kount,upfreq) = 0      
c     Control Print of Tableau
c      call tabprint(wa,varb,varn,pr,prcens,z,nobs1,nobs,nx,nx2,
c     &              pkount,kl,cens)
c      if (pkount.eq.pklim) goto 1000
c     Control Print of Tableau
      go to 205
 1000 continue
      setuptable = 0
      RETURN
      END

      SUBROUTINE tabcheck(xx,wa,varb,varn,nobs1,nobs,nx,nx2,toler,wflag)
      IMPLICIT REAL*8 (a-h,o-z)
      INTEGER nobs,nobs1,nx,nx1,nx2,pn,wflag
      INTEGER i,j,varb(nobs),varn(nx),ii,jj,coefnum
      REAL*8 wa(nobs1,nx2),xx(nobs,nx2),lhs(30892),rhs(30892),
     & zero,one,factor,maxdiff,toler
      PARAMETER (zero=0.d0,one=1.d0)

	  pn = 7
c
c    Check if difference in lhs and rhs - lhs is vector associated with
c                                             nonbasis-variable or residuals
c                                         rhs is calculated vector from
c                                             basis-vectors and table entries
c      write(pn,'(a,e15.4)') 'T A B C H E C K  -  Toler = ',toler
      do 10 j = 1,nx
c determine lhs
         if (abs(varn(j)).le.nobs) then
            do 20 i = 1,nobs
               lhs(i) = zero
 20            continue
            lhs(abs(varn(j))) = sign(one,dble(varn(j)))
            else
              coefnum = abs(varn(j)) - nobs
            do 30 i = 1,nobs
               lhs(i) = sign(one,dble(varn(j)))*xx(i,coefnum)
 30            continue
            endif
c determine rhs
         do 40 i = 1,nobs
            rhs(i) = zero
 40         continue
         do 50 ii = 1,nobs
            factor = wa(ii,j)
            if (abs(varb(ii)).le.nobs) then
               rhs(abs(varb(ii))) = rhs(abs(varb(ii))) + 
     &                            sign(one,dble(varb(ii)))*factor
               else
               coefnum = abs(varb(ii)) - nobs
               do 60 i = 1,nobs
                  rhs(i) = rhs(i) + 
     &                   sign(one,dble(varb(ii)))*xx(i,coefnum)*factor
 60               continue
            endif                   
 50         continue
         maxdiff = zero
         do 70 i = 1,nobs         
            if (abs(rhs(i)-lhs(i)).gt.maxdiff) 
     &         maxdiff = abs(rhs(i)-lhs(i))
 70         continue
         if (maxdiff.ge.toler) then
c            write(pn,'(a,i5,a,e15.4)')
c     &      'Problem: Fuer VARN = ',varn(j),' Maxdiff = ',maxdiff
            wflag = 3
            endif
 10      continue
c     if (errorco.eq.0) write(pn,'(/,a,/)') 
c     &   'T A B C H E C K finished successfully '
c      if (wflag.eq.3)
c	  		eflag = 3
c	    write(pn,'(/,a,/)') 
c     &   'T A B C H E C K problem'
      RETURN
      END
      REAL*8 FUNCTION r(theta,err)
      REAL*8 theta,err
      if (err .ge. 0) r = err*theta
      if (err .lt. 0) r = err*(theta-1.d0)
      RETURN
      END
      REAL*8 FUNCTION objective(y,yc,x,beta,nobs,nx,theta)
      INTEGER i,nobs,nx,j
      REAL*8 y(nobs),yc(nobs),x(nobs,nx),beta(nx),
     & theta,r,ypred
      EXTERNAL r
      objective = 0.d0
      do 10 i = 1,nobs
         ypred = 0.d0
         do j = 1,nx
            ypred = ypred + x(i,j)*beta(j)
            enddo
         if (yc(i).gt.ypred) then 
            objective = objective
     &             + r(theta,y(i)-min(ypred,yc(i)))
            else
            objective = objective
     &             + (1.d0-theta)*(yc(i)-y(i))
            endif
 10      continue
      RETURN
      END

      SUBROUTINE MAB8(A,N1,N2,B,N3,N4,G,eflag)                           
      DOUBLE PRECISION A(N1,N2),B(N3,N4)                           
      DOUBLE PRECISION G(N1,N4)
	  INTEGER pn,eflag                                    
C THIS SUBROUTINE READS IN A MATRIX A AND A MATRIX B               
C BOTH IN DOUBLE PRECISION AND                                     
C THEN MULTIPLIES A WITH B AND                                     
C CREATES A MATRIX G IN DOUBLE PRECISION.                          
      
c	  eflag = 0
	  pn = 7
	  IF (N2.NE.N3) GO TO 900                                      
      DO 10 I=1,N1                                                 
      DO 10 J=1,N4                                                 
      G(I,J)=0.D0                                                  
  10  CONTINUE                                                     
      DO 50 I=1,N2  
      DO 30 K1=1,N1                                  
      DO 20 K2=1,N4                                  
      G(K1,K2)=G(K1,K2)+A(K1,I)*B(I,K2)              
  20  CONTINUE                                       
  30  CONTINUE                                       
  50  CONTINUE                                       
      RETURN                                         
 900  CONTINUE                                       
      eflag = 2
c      write(pn,995) N2,N3                             
c 995  FORMAT('0******ROUTINE MAB8 WRONG DIMENSIONS','  N2=',I4,   
c     &'  N3=',I4)                                                 
      RETURN                                                      
      END                                                         
