\name{plot}
\alias{plot.rqss}
\alias{plot.qss1}
\alias{plot.qss2}
\title{Plot Method for rqss() Objects}
\description{
Takes a fitted \code{rqss} object produced by \code{rqss()} and plots
the component smooth functions that make up the ANOVA decomposition.
Since the components "omit the intercept" the estimated intercept is added back
in -- this facilitates the comparison of quantile fits particularly.
For models with a partial linear component or several \code{qss} components
it may be preferable to plot the output of \code{predict.rqss}.
}
\usage{
\method{plot}{rqss}(x, \dots)
\method{plot}{qss1}(x, \dots)
\method{plot}{qss2}(x, render = "contour", ncol = 100, zcol = NULL, \dots)
}
\arguments{
  \item{x}{a fitted \code{rqss} object produced by \code{\link{rqss}()}.}
  \item{...}{additional arguments for the plotting algorithm}
  \item{render}{a character specifying the rendering for bivariate fits;
    either \code{"contour"} (default) or \code{"rgl"}.  The latter
    requires package \pkg{rgl}.}
  \item{ncol, zcol}{Only for \code{render = "rgl"}: number of colors and
    z values for color construction.}%% FIXME: be more specific
}
\value{
    The function produces plots for the ANOVA components as a side effect.
}
\author{ Roger Koenker }
\seealso{ \code{\link{rqss}}}
\examples{
n <- 200
x <- sort(rchisq(n,4))
z <- x + rnorm(n)
y <- log(x)+ .1*(log(x))^2 + log(x)*rnorm(n)/4 + z
plot(x,y-z)
fN <- rqss(y~qss(x,constraint="N")+z)
plot(fN)
fI <- rqss(y~qss(x,constraint="I")+z)
plot(fI,  col="blue")
fCI <- rqss(y~qss(x,constraint="CI")+z)
plot(fCI, col="red")
%%keep objects for inspection : do not rm(n,x,y,z,fit)

## A bivariate example
data(CobarOre)
fCO <- rqss(z~qss(cbind(x,y),lambda=.08), data = CobarOre)
plot(fCO)
}
\keyword{regression}
\keyword{smooth}
\keyword{iplot}
