\name{rq.fit.lasso}
\alias{rq.fit.lasso}
\title{
Lasso Penalized Quantile Regression 
}
\description{
  The fitting method implements the lasso penalty of Tibshirani for
  fitting quantile regression models.  The penalty function is the l1
  norm of the last (p-1) coefficients, under the presumption that the
  first coefficient is an intercept parameter that should not be subject
  to the penalty.  There should be a sparse version of this, but isn't (yet).
}
\usage{
rq.fit.lasso(x, y, tau = 0.5, lambda = 1, beta = .9995, eps = 1e-06)
}
\arguments{
\item{x}{
  the design matrix
}
\item{y}{
  the response variable
}
\item{tau}{
  the quantile desired, defaults to 0.5.
}
\item{lambda}{
  the value of the penalty parameter that deterimines how much shrinkage is done.
}
\item{beta}{
  step length parameter for Frisch-Newton method.
}
\item{eps}{
 tolerance parameter for convergence. 
}
}
\value{
  Returns a list with a coefficient and residual components.  
  When called from \code{"rq"} as intended the returned object
  has class "lasso".  
}
\references{
Koenker, R. (2005 \emph{Quantile Regression}, CUP.
}
\author{R. Koenker}
\seealso{
\code{\link{rq}}}
\examples{
set.seed(2345)
}
\keyword{regression}
