"summary.fcrqs" <-
function (object, ...) {
        taus <- object$tau
        xsum <- as.list(taus)
        for(i in 1:length(taus)){
                xi <- object
                xi$coefficients <- xi$coefficients[,i]
                xi$residuals <- xi$residuals[,i]
                xi$tau <- xi$tau[i]
                class(xi) <- "fcrq"
                xsum[[i]] <- summary(xi, ...)
                }
        class(xsum) <- "summary.rqs"
        xsum
        }

"summary.fcrq" <-
# There are two options for "se":
#	4.  "ker" which uses a kernel estimate of the sandwich as proposed by Powell.
#	5.  "boot" which uses a bootstrap method:
#		"xy"	uses xy-pair method 
#		"bcy"	uses the parzen-wei-ying method 
#
function (object, se = "boot", covariance = TRUE, ...) 
{
    mt <- terms(object)
    m <- model.frame(object)
    y <- model.response(m)
    x <- model.matrix(mt,m,contrasts = object$contrasts)
    wt <- model.weights(object$model)
    tau <- object$tau
    eps <- .Machine$double.eps^(2/3)
    coef <- coefficients(object)
    if (is.matrix(coef)) 
        coef <- coef[, 1]
    vnames <- dimnames(x)[[2]]
    resid <- object$residuals
    n <- length(resid)
    p <- length(coef)
    rdf <- n - p
    if (!is.null(wt)) {
        resid <- resid * wt
        x <- x * wt
        y <- y * wt
    }
    if (missing(se)) {
            se <- "boot"
    }
    if (se == "ker") {
	stop("ker method not yet implemented for fcen")
        h <- bandwidth.rq(tau, n, hs = "hs")
        if (tau + h > 1) 
            stop("tau + h > 1:  error in summary.fcrq")
        if (tau - h < 0) 
            stop("tau - h < 0:  error in summary.fcrq")
        uhat <- c(y - x %*% coef)
        h <- (qnorm(tau + h) - qnorm(tau - h))*
		min(sqrt(var(uhat)), ( quantile(uhat,.75)- quantile(uhat, .25))/1.34 )
        f <- dnorm(uhat/h)/h
        fxxinv <- diag(p)
        fxxinv <- backsolve(qr(sqrt(f) * x)$qr[1:p, 1:p], fxxinv)
        fxxinv <- fxxinv %*% t(fxxinv)
        cov <- tau * (1 - tau) * fxxinv %*% crossprod(x) %*% 
            fxxinv
        serr <- sqrt(diag(cov))
    }
    else if (se == "boot") {
	s <- y > x %*% coef
        B <- boot.rq(x[s,], y[s], tau, ...)
        cov <- cov(B)
        serr <- sqrt(diag(cov))
    }
    coef <- array(coef, c(p, 4))
    dimnames(coef) <- list(vnames, c("Value", "Std. Error", "t value", "Pr(>|t|)"))
    coef[, 2] <- serr
    coef[, 3] <- coef[, 1]/coef[, 2]
    coef[, 4] <- ifelse(rdf > 0, 2 * (1 - pt(abs(coef[, 3]), rdf)),NA)
    object <- object[c("call", "terms")]
    if (covariance == TRUE) {
        object$cov <- cov
        if (se %in% c("nid", "ker")) {
            object$Hinv <- fxxinv
            object$J <- crossprod(x)
        }
        else if (se == "boot") {
            object$B <- B
        }
    }
    object$coefficients <- coef
    object$rdf <- rdf
    object$tau <- tau
    class(object) <- "summary.rq"
    object
}
