\name{rq.fit.scad}
\alias{rq.fit.scad}
\title{
SCADPenalized Quantile Regression 
}
\description{
  The fitting method implements the smoothly clipped absolute deviation
  penalty of Fan and Li for fitting quantile regression models.  
  There should be a sparse version of this, but isn't (yet).
}
\usage{
rq.fit.scad(x, y, tau = 0.5, alpha = 3.2, lambda = 1, start="rq", 
	beta = .9995, eps = 1e-06)
}
\arguments{
\item{x}{
  the design matrix
}
\item{y}{
  the response variable
}
\item{tau}{
  the quantile desired, defaults to 0.5.
}
\item{alpha}{
  tuning parameter of the scad penalty.
}
\item{lambda}{
  the value of the penalty parameter that deterimines how much shrinkage is done.
}
\item{start}{
  starting method, default method 'rq' uses the unconstrained rq estimate, while
  method 'lasso' uses the corresponding lasso estimate with the specified lambda.
}
\item{beta}{
  step length parameter for Frisch-Newton method.
}
\item{eps}{
 tolerance parameter for convergence. 
}
}
\value{
  Returns a list with a coefficient and residual components.  
  When called from \code{"rq"} as intended the returned object
  has class "lasso".  
}
\references{
Koenker, R. (2005 \emph{Quantile Regression}, CUP.
}
\author{R. Koenker}
\seealso{
\code{\link{rq}}}
}
\examples{
set.seed(2345)
}
\keyword{regression}
