\name{predict.rqss}
\alias{predict.rqss}
\alias{predict.qss1}
\alias{predict.qss2}
\title{ Predict from fitted nonparametric quantile regression smoothing
spline models}
\description{
Additive models for nonparametric quantile regression using total
variation penalty methods can be fit with the \code{\link{rqss}}
function.  Univarariate and bivariate components can be predicted
using these functions.  }
\usage{
predict.rqss(object, newdata, ...)
predict.qss1(object, newdata, ...)
predict.qss2(object, newdata, ...)
}
\arguments{
\item{object}{ is a fitted object produced by \code{\link{rqss}} }
\item{newdata}{ a data frame describing the observations at which
	prediction is to be made.  For qss components newdata should
	lie in strictly within the convex hull of the fitting data.  Newdata
	corresponding to the partially linear component of the model
	may require caution concerning the treatment of factor levels,
	if any.}
\item{\dots}{ optional arguments }
}
\details{
For both univariate and bivariate prediction linear interpolation is
done.  In the bivariate case, this involves computing barycentric
coordinates of the new points relative to their enclosing triangles.
It may be of interest to plot individual components of fitted rqss
models:  this is usually best done by fixing the values of other
covariates at reference values typical of the sample data and
predicting the response at varying values of one qss term at a
time.   Direct use of the
\code{\link{predict.qss1}} and \code{\link{predict.qss2}} functions.  
is discouraged since it usually corresponds to predicted values
at absurd  reference values of the other covariates, i.e. zero.
}
\value{
A vector of predictions.  
}
\author{ R. Koenker }
\seealso{  \code{\link{rqss}}}
\examples{ 
n <- 200
x <- sort(rchisq(n,4))
z <- exp(rnorm(n)) + x
y <- log(x)+ .1*(log(x))^2 + z/4 +  log(x)*rnorm(n)/4
plot(x,y - z/4 + mean(z)/4)
fit <- rqss(y~qss(x,constraint="I")+z)
xz <- cbind(mean(z),seq(min(x)+.01,max(x)-.01,by=.25))
xz <- data.frame(xz)
dimnames(xz)[[2]] <- c("z","x")
lines(xz[["x"]],predict(fit,xz),col=2)
title("Predicted Median Response at Mean Value of z")
rm(x,y,z,xz,fit)

data(CobarOre)
attach(CobarOre)
fit <- rqss(z~qss(cbind(x,y),lambda=.08),data=CobarOre)
plot(fit,col="grey")
ndum <- 100
u <- runif(ndum)
v <- runif(ndum)
xd <- min(x) + u * (max(x) - min(x))
yd <- min(y) + v * (max(y) - min(y))
T <- tri.mesh(x, y)
s <- in.convex.hull(T, xd, yd)
nd <- data.frame(cbind(xd[s], yd[s]))
dimnames(nd)[[2]] <- c("x","y")
pred <- predict(fit,nd)
contour(interp(xd[s],yd[s],pred),col="red",add=TRUE)
}
\keyword{regression}
\keyword{smooth}
\keyword{robust}
