\name{rq.fit.fcen}
\alias{rq.fit.fcen}
\title{
Censored Quantile Regression Fitting a la Powell (1986)
}
\description{
  This function implements Fitzenberger's algorithm for computing 
  Powell's estimator for quantile regression models with fixed censoring.
  This function would normally be invoked automatically from \code{rq()}
  with optional additional arguments passed
  via the \code{\dots{}} argument of \code{rq()}.
}
\usage{
rq.fit.fcen(x, y, yc, beta, tau = 0.5, left = TRUE)
}
\arguments{
\item{x}{
  the design matrix
}
\item{y}{
  the response variable
}
\item{yc}{
  the censoring points for the response variable, defaults to zero.
}
\item{beta}{
  the starting value for the parameter, defaults to vector of zeros.
}
\item{tau}{
  the quantile desired, defaults to 0.5.
}
\item{left}{
  Logical flag if TRUE - left censoring is indicated, if FALSE then
  right censoring is indicated.
}
}
\value{
  Returns a list with a coefficient and residual components.  
  When called from \code{"rq"} as intended the returned object
  has class "crq".  See \code{\link{rq.object}} and 
  \code{\link{rq.process.object}} for further details.
}
\details{
  Powell (1986) introduced a quantile regression estimator for data
  with fixed censoring.  Fitzenberger (1996) describes details of
  the algorithm.  Either left censoring and right censoring can be
  handled.  Setting with both left and right censoring have not been
  implemented (yet).  The default censoring vector is zero for all
  observations, otherwise this vector must be specified by the user.
}
\references{
Powell, J. (1986) ``Censored Regression Quantiles,'' \emph{J.
Econometrics}, 32, 143--155.

Fitzenberger, B.  (1996): ``A Guide to Censored Quantile
Regressions,'' in \emph{Handbook of Statistics}, ed. by C.~Rao,   and
G.~Maddala. North-Holland: New York.

}
\author{B. Fitzenberger}
\seealso{
\code{\link{rq}}}
}
\examples{
set.seed(2345)
x <- sqrt(rnorm(100)^2)
y <-  -0.5 + x +(.25 + .25*x)*rnorm(100)
plot(x,y, type="n")
s <- (y > 0)
points(x[s],y[s],cex=.9,pch=16)
points(x[!s],y[!s],cex=.9,pch=1)
yLatent <- y
y <- pmax(0,y)
for(tau in (1:4)/5){
	f <- rq(y ~ x, yc = rep(0,100), tau = tau, method = "fcen")
	xs <- sort(x)
	lines(xs,pmax(0,cbind(1,xs)\%*\%f$coef),col="red")
	abline(rq(y ~ x, tau = tau), col="blue")
	abline(rq(yLatent ~ x, tau = tau), col="green")
	}
legend(.15,2.5,c("Naive QR","Censored QR","Omniscient QR"),
	lty=rep(1,3),col=c("red","blue","green"))

}
\keyword{regression}
