# Function to implement (Powell) Type 1 censored quantile regression based on the the 
# BRCEN algorithm of Fitzenberger (1996, 1997) (Created 12/07/98, last modified 09/09/05)
#
# INPUTS: x matrix of regressors; y vector of responses; yc vector of censoring
#	values of y; beta initial values of coeffs; tau quantile to be estimated;
#	int flag for intercept;	left flag for left (right) censoring problem;
#	toler tolerance parameter. If beta is missing, it is initialized at 0
# OUTPUT: coef estimated vector of coefficients; obj optimal value of the obj. function


rq.fit.fcen <- function(x, y, yc, beta, tau=0.5, left=TRUE){

 tol  <- .Machine$double.eps^(2/3)
 x <- as.matrix(x)
 y <-as.vector(y)
 if(missing(yc)) yc <- rep(0,n) 
 yc <- as.vector(yc)
 n <- nrow(x)
 p <- ncol(x)
 if(left) {
	x <- -x
	y <- -y
	yc <- -yc
	tau <- 1-tau
	}

 cens <- rep(0, n)
 cens[ (yc - y ) < tol ] <- 1


if(missing(beta)) beta <- rep(0,p) 
beta <- as.vector(beta) 

optimum <- FALSE
 
qrc <- .Fortran("qrcens", 
	as.double(x),
	as.double(y),
	as.double(yc),
	as.integer(p),
	as.integer(n),
	coef = as.double(beta),
	double((n+1)*(p+2)),
	as.integer(n + 1),
	as.integer(p + 2),
	double(n),
	double(n),
	integer(n),
	as.integer(cens),
	integer(n),
	integer(p),
	as.double(tol),
	as.logical(optimum),
	as.double(tau),
	eflag = as.integer(0),
	wflag = as.integer(0),
	PACKAGE = "quantreg")

if(qrc$eflag!=0)
	stop(switch(qrc$eflag, "Censoring indicator is incorrect ",
		"x and beta don't match "))
if(qrc$wflag!=0) 
	warning(switch(qrc$wflag, "Max iterations reached",
		"Solution may be nonunique","Tabcheck problem"))

	residuals <- as.matrix(y - pmin(yc, x %*% qrc$coef))

return (list(coefficients= qrc$coef, residuals = residuals))
}
