\name{predict.rq}
\alias{predict.rq}
\alias{predict.rqs}
\title{Quantile Regression Prediction}
\description{
Prediction based on fitted quantile regression model
}
\usage{
predict.rq(object, newdata, se.fit = FALSE, na.action = na.pass, ...)
}
\arguments{
  \item{object}{ object of class rq produced by \code{rq} }
  \item{newdata}{An optional data frame in which to look for variables with
    which to predict.  If omitted, the fitted values are used.}
  \item{se.fit}{Flag indicating whether standard errors are
    desired, not yet implemented.}
  \item{na.action}{ function determining what should be done with missing values
    in 'newdata'.  The default is to predict 'NA'.}
  \item{\dots}{ Further arguments passed to or from other methods.}
}
\details{
     Produces predicted values, obtained by evaluating the quantile
     regression function in the frame 'newdata' (which defaults to
     'model.frame(object)'.  These predictions purport to estimate
    the conditional quantile function of the response variable of
    the fitted model evaluated at the covariate values specified
    in "newdata" and the quantile(s) specified by the "tau" argument.
}
\value{
     Produces a vector of predictions or a matrix of
     predictions if multiple taus are specified.

}
\references{ }
\author{R. Koenker}
\seealso{ \code{\link{rq}}}
\examples{
data(airquality)
airq <- airquality[143:150,]
f <- rq(Ozone ~ ., data=airquality)
predict(f,newdata=airq)
f <- rq(Ozone ~ ., data=airquality,tau=1:3/4)
predict(f,newdata=airq)
  }
}
\keyword{regression}
