
#Demo for a plot of two quantile functions of food expenditure

data(engel)
attach(engel)

x.poor <- quantile(x,.1) #Poor is defined as at the .1 quantile of the sample distn
x.rich <- quantile(x,.9) #Rich is defined as at the .9 quantile of the sample distn
ps <- z$sol[1,]
qs.poor <- c(c(1,x.poor)%*%z$sol[4:5,])
qs.rich <- c(c(1,x.rich)%*%z$sol[4:5,])
#now plot the two quantile functions to compare
par(mfrow = c(1,2))
plot(c(ps,ps),c(qs.poor,qs.rich),type="n",xlab=expression(tau),ylab="quantile")
plot(stepfun(ps,c(qs.poor[1],qs.poor)),do.points=FALSE,add=TRUE)
plot(stepfun(ps,c(qs.poor[1],qs.rich)),do.points=FALSE,add=TRUE,
        col.hor = "gray", col.vert = "gray")
#now plot associated conditional density estimates
ap <-  akj(qs.poor,qs.poor,diff(ps))
ar <-  akj(qs.rich,qs.rich,diff(ps))
plot(c(qs.poor,qs.rich),c(ap$dens,ar$dens),type="n",
xlab= "Food Expenditure", ylab= "Density")
lines(qs.rich,ar$dens,col="gray")
lines(qs.poor,ap$dens,col="black")
legend(750,.006,c("poor","rich"),lty = c(1,1),col=c("black","gray"))

