#Demo of nonlinear quantile regression model based on Frank copula

        n <- 200
        df <- 8
        delta <- 8
        x <- sort(rt(n,df))
        u <- runif(n)
        v <- -log(1-(1-exp(-delta))/(1+exp(-delta*pt(x,df))*((1/u)-1)))/delta
        y <- qt(v,df)
        plot(x,y,pch="o",col="blue",cex = .25)
        us <- c(.25,.5,.75)
        for(i in 1:length(us)){
                u <- us[i]
                v <- -log(1-(1-exp(-delta))/
                        (1+exp(-delta*pt(x,df))*((1/u)-1)))/delta
                lines(x,qt(v,df))
                }
        Dat <- NULL
        Dat$x <- x
        Dat$y <- y
        deltas <- matrix(0,3,length(us))
        FrankModel <- function(x,delta,mu,sigma,df,tau){
                z <- qt(-log(1-(1-exp(-delta))/
                        (1+exp(-delta*pt(x,df))*((1/tau)-1)))/delta,df)
                mu + sigma*z
                }
        for(i in 1:length(us)){
                tau = us[i]
                fit <- nlrq(y~FrankModel(x,delta,mu,sigma,df=8,tau=tau),
                        data=Dat,tau= tau, start=list(delta=5,
                        mu = 0, sigma = 1),trace=TRUE)
                lines(x, predict(fit, newdata=x), lty=2, col="red")
                deltas[i,] <- coef(fit)
		}
