\name{qrisk}
\alias{qrisk}
\alias{rq.fit.hogg}
\title{ Function to compute Choquet portfolio weights}
\description{
This function solves a weighted quantile regression problem to find the
optimal portfolio weights minimizing a Choquet risk criterion described
in Bassett, Koenker, and Kordas (2002).
}
\usage{
qrisk(x, alpha = c(0.1, 0.3), w = c(0.7, 0.3), mu = 0.07, R = NULL, r = NULL, lambda = 10000)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{n by q matrix of historical or simulated asset returns }
  \item{alpha}{vector of alphas receiving positive weights in the Choquet criterion}
  \item{w}{weights associated with alpha in the Choquet criterion  }
  \item{mu}{targeted rate of return for the portfolio}
  \item{R}{matrix of constraints on the parameters of the quantile regression, see below }
  \item{r}{rhs vector of the constraints described by R}
  \item{lambda}{Lagrange multiplier associated with the constraints}
}
\details{
The function calls \code{rq.fit.hogg} which in turn calls the constrained Frisch
Newton algorithm.  The constraints Rb=r are intended to apply only to the slope
parameters, not the intercept parameters.  The user is completely is expected to
specify constraints that are consistent, ie that have at least one feasible point.
}
\value{
  \item{pihat}{the optimal portfolio weights}
  \item{muhat }{the in-sample mean return of the optimal portfolio}
  \item{qrisk}{the in-sample Choquet risk of the optimal portfolio}
}
\references{http://www.econ.uiuc.edu/~roger/research/risk/risk.html}
\author{ R. Koenker }
\note{ ~~further notes~~ }

 ~Make other sections like WARNING with \section{WARNING }{....} ~

\seealso{ ~~objects to SEE ALSO as \code{\link{~~fun~~}}, ~~~ }

\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	     or do  help(data=index)  for the standard data sets.

## The function is currently defined as
function(x, alpha=c(.1,.3), w = c(.7,.3), mu = .07, R = NULL, r = NULL, lambda = 10000){
#
# find optimal Choquet-risk portfolios given:
#
#	x 	(n by p) matrix of asset returns
#	alphas	alphas defining a Choquet capacity risk function
#	w	w defining weights for Choquet capacity risk function
#	R	Matrix defining constraints on the parameters 
#	r	rhs defining constraints on the parameters 
#	mu	required mean rate of return	
#	lambda	Lagrange multiplier for RoR constraint 
#
	n <- nrow(x)
	p <- ncol(x)
	m <- length(alpha)
	if(length(w)!=m)return("length of w doesn't match length of alpha")
	xbar <- apply(x,2,mean)
	y <- x[,1]
	r <- c(r,lambda*(xbar[1]-mu), -lambda*(xbar[1]-mu))
	X <- x[,1]-x[,-1]
	R <- rbind(R,lambda*(xbar[1]-xbar[-1]), -lambda*(xbar[1]-xbar[-1]))
	R <- cbind(matrix(0,nrow(R),m),R)
	fit <- rq.fit.hogg(X,y,taus=alpha,w=w,R=R,r=r)
	pihat <- c(1-sum(fit[-(1:m)]),fit[-(1:m)])
	yhat <- x%*%pihat
	etahat <- quantile(yhat,alpha)
	muhat <- mean(yhat)
	qrisk <- 0
	for(i in 1:length(alpha))
		qrisk <- qrisk + w[i]*sum(yhat[yhat<etahat[i]])/(n*alpha[i]) 
	return(pihat,muhat,qrisk)
  }
}
\keyword{regression}
