\name{KWopt}
\alias{KWopt}
\title{
Stochastic approximation a la Kiefer-Wolfowitz (1952)
}
\description{
Stochastic approximation a la Kiefer-Wolfowitz (1952) to estimate the
maximizing value for a one dimensional noisey objective function. 
}
\usage{
KWopt(f, n, x0 = 15, a0 = 1, a = -1, c0 = 3, c = -1/6)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{f}{ the function to be maximized }
  \item{n}{ the number of iterations of the procedure desired.  }
  \item{x0}{ the initial value of the control parameter }
  \item{a0}{ the gain scale parameter, see code }
  \item{a}{ the gain parameter, see code }
  \item{c0}{ the step size scale parameter } 
  \item{c}{ the step size rate parameter }
}
\details{ The function code provides a concise description of the details. 
Be forewarned that the procedure can be rather sensitive to choices of starting values
and its tuning parameters.  It might be worthwhile to extend this a bit so that
the fixed constant a adapted to the problem;  it should be the the gradient
step is scaled by an estimate of the information number.
}
\value{Returns a data-frame with n rows and columns with the x values and
the auxiliary values x + h and x - h, denoted xm and xp respectively, which
might be useful in reading the entrails of the iterations.}
\references{
Kiefer, J. and J. Wolfowitz, (1952)
Stochastic Estimation of the Maximum of a Regression Function, 
Annals of Mathematical Statistics 23, 462--466.
}
\author{ R. Koenker }
\examples{ 
# Monopoly pricing with an unknown demand curve
set.seed(1968)
n <- 100
H <- KWopt(Profit,n = n)
# Now recover the demand observations generated by the KW iteration
set.seed(1968)
p <- unlist(H[-1,2:3])
x <- Demand(p)
plot(p,x,xlab = "Price", ylab = "Demand", cex = .2)
f <- lm(log(x) ~ log(p) + I(log(p)^2))
summary(f)
u <- 50:180/10
g <- predict(f, newdata=list(p = u))
lines(u,exp(g))
abline(v = H[n,1],col = "red")
title("Demand Scatter and Least-Squares Fit", 
	paste("Profit Maximizing Price  ",round(H[n,1], 2)))
}
\keyword{ optimization }
