\name{Demand}
\alias{Demand}
\title{
Demand Function for Monopoly Problem
}
\description{
Demand function for the monopoly problem. 
}
\usage{
Demand(p)
}
\arguments{
  \item{p}{ price of the monopoly product }
}
\details{
Demand is subject to random shocks;  the functional form of the demand curve
is known to be log quadratic, but the parameters are hidden from view.
}
\value{returns a vector of output quantities corresponding to the prices
given as input.  Depends on the state of .Random.seed.
}
\author{
R. Koenker
}

\seealso{
\code{Cost}, \code{Profit} 
}
\examples{
# Plot a (random) demand curve
p <- 1:400/10
plot(p, Demand(p), type = "l")
}

\keyword{ design }
