# Monopoly pricing with an unknown demand curve
     set.seed(1968)
     n <- 101
     H <- KWopt(Profit,n = n)
     # Now recover the demand observations generated by the KW iteration
     set.seed(1968)
     p <- unlist(H[-1,])	
     P <- matrix(p,n-1,3)
     p <- c(t(P))
     x <- Demand(p)
     plot(p,x,xlab = "Price", ylab = "Demand", cex = .2)
     lines(p[(1:(n-1))*3 - 2], x[(1:(n-1))*3 - 2])
     f <- lm(log(x) ~ log(p) + I(log(p)^2))
     summary(f)
     u <- 50:180/10
     g <- predict(f, newdata=list(p = u))
     lines(u,exp(g),col = "blue")
     abline(v = H[n,1],col = "red")
