subroutine testeq(a,b,eps,value)

# Test for the equality of a and b in a fairly
# robust way.
# Called by trifnd, circen, stoke.

implicit double precision(a-h,o-z)
logical value

# If b is essentially 0, check whether a is essentially zero also.
# The following is very sloppy!  Must fix it!
if(dabs(b)<=eps) {
        if(dabs(a)<=eps) value = .true.
        else value = .false.
        return
}

# Test if a is a `lot different' from b.  (If it is
# they're obviously not equal.)  This avoids under/overflow
# problems in dividing a by b.
if(dabs(a)>10.*dabs(b)|dabs(a)<0.1*dabs(b)) {
        value = .false.
        return
}

# They're non-zero and fairly close; compare their ratio with 1.
c = a/b
if(dabs(c-1.)<=eps) value = .true.
else value = .false.

return
end
