subroutine qtest(h,i,j,k,shdswp,x,y,ntot,eps,nerror)

# Test whether the LOP is satisified; i.e. whether vertex j is
# outside the circumcircle of vertices h, i, and k of the
# quadrilateral.  Vertex h is the vertex being added; i and k are the
# vertices of the quadrilateral which are currently joined; j is the
# vertex which is ``opposite'' the vertex being added.  If the LOP is
# not satisfied, the shdswp ("should-swap") is true, i.e. h and j
# should be joined, rather than i and k.
# Called by swap.

implicit double precision(a-h,o-z)
dimension x(-3:ntot), y(-3:ntot)
integer h
logical shdswp

nerror = -1

# Look for ideal points.
if(i<=0) ii = 1
else ii = 0
if(j<=0) jj = 1
else jj = 0
if(k<=0) kk = 1
else kk = 0
ijk = ii*4+jj*2+kk
switch(ijk) {

# All three corners other than h (the point currently being
# added) are ideal --- so h, i, and k are co-linear; so don't swap.
        case 7:
		shdswp = .false.
                return

# If i and j are ideal, find out which of h and k is closer to the
# intersection point of the two diagonals, and choose the diagonal
# emanating from that vertex.  (I.e. if h is closer, swap.)
# Unless swapping yields a non-convex quadrilateral!!!
        case 6:
                ja = -j
                xh = x(h)
                yh = y(h)
                xk = x(k)
                yk = y(k)
                test =(xh*yk+xk*yh-xh*yh-xk*yk)*(-1)**ja
                if(test>0) shdswp = .true.
                else shdswp = .false.
# Check for convexity:
		if(shdswp) call acchk(j,k,h,shdswp,x,y,ntot,eps)
                return

# Vertices i and k are ideal --- can't happen, but if it did, we'd
# increase the minimum angle ``from 0 to more than 2*0'' by swapping,
# and the quadrilateral would definitely be convex, so let's say swap.
        case 5:
		shdswp = .true.
                return

# If i is ideal we'd increase the minimum angle ``from 0 to more than
# 2*0'' by swapping, so just check for convexity:
        case 4:
                call acchk(j,k,h,shdswp,x,y,ntot,eps)
                return

# If j and k are ideal, this is like unto case 6.
        case 3:
                ja = -j
                xi = x(i)
                yi = y(i)
                xh = x(h)
                yh = y(h)
                test = (xh*yi+xi*yh-xh*yh-xi*yi)*(-1)**ja
                if(test>0.) shdswp = .true.
                else shdswp = .false.
# Check for convexity:
		if(shdswp) call acchk(h,i,j,shdswp,x,y,ntot,eps)
                return

# If j is ideal we'd decrease the minimum angle ``from more than 2*0
# to 0'', by swapping; so don't swap.
        case 2:
                shdswp = .false.
                return

# If k is ideal, this is like unto case 4.
        case 1:
                call acchk(i,j,h,shdswp,x,y,ntot,eps) # This checks
                                                      # for convexity.
                return

# If none of the `other' three corners are ideal, do the Lee-Schacter
# test for the LOP.
        case 0:
                call qtest1(h,i,j,k,x,y,ntot,eps,shdswp,nerror)
                return

        default:  # This CAN'T happen.
		nerror = 7
		return

}

end
