subroutine penalty(delsgs,ndel,nadj,madj,x,y,ntot,ind,nerror)

# Output the coefficients of the penalty component of the triogram design
# Called by master.

implicit double precision(a-h,o-z)
dimension nadj(-3:ntot,0:madj), x(-3:ntot), y(-3:ntot)
dimension inddel(4,1), ind(1)
logical value

# Loop over edges
do i1 = 1,ndel {

	#skip boundary edges
	if(delsgs(i1,7) < 1  | delsgs(i1,8) < 1) next
	do i = 1,4{
		xx(i)= x(ind(indel(i1,i)))
		yy(i)= y(ind(indel(i1,i)))
		}
	call triar(xx(1),yy(1),xx(2),yy(2),xx(3),yy(3),det1)
	call triar(xx(1),yy(1),xx(2),yy(2),xx(4),yy(4),det2)

	g(1) = - (yy(1) - yy(2))
	g(2) =   (xx(1) - xx(2))
	
	w(1, 1) = (yy(2) - yy(3))/det1 - (yy(2) - yy(4))/det2
        w(2, 1) = (xx(3) - xx(2))/det1 - (xx(4) - xx(2))/det2
        w(1, 2) = (yy(3) - yy(1))/det1 - (yy(4) - yy(1))/det2
        w(2, 2) = (xx(1) - xx(3))/det1 - (xx(1) - xx(4))/det2
        w(1, 3) = (yy(1) - yy(2))/det1
        w(2, 3) = (xx(2) - xx(1))/det1
        w(1, 4) = (yy(2) - yy(1))/det2
        w(2, 4) = (xx(1) - xx(2))/det2
	
	#now multiply g'w

	do i =1,4{
		(i1,i) = w(1,i)*g(1) + w(2,i)*g(2)

return
end
