subroutine delseg(delsgs,ndel,nadj,madj,x,y,ntot,ind,nerror)

# Output the endpoints of the line segments joining the
# vertices of the Delaunay triangles.  And find for each
# edge the adjacent vertices of the Delaunay quadralateral
# Then compute the coefficients of the contribution of each edge
# to the Triogram penalty term.  On return, barring an error
# the array delsgs consists of 12 columns, one row for each edge.
#
#	[xi,yi,xj,yj,i,j,ks,kp,h(i),h(j),h(ks),h(kp)]
#
# Called by master.  Revised: May 1999 by R. Koenker

implicit double precision(a-h,o-z)
dimension nadj(-3:ntot,0:madj), x(-3:ntot), y(-3:ntot)
dimension delsgs(12,1), ind(1), g(2),w(2,4)
logical value

# For each distinct pair of points i and j, if they are adjacent
# then put their endpoints into the output array.
npd = ntot-4
two = 2.0d0
kseg = 0
do i1 = 2,npd {
	i = ind(i1)
        do j1 = 1,i1-1 {
		j = ind(j1)
                call adjchk(i,j,value,nadj,madj,ntot,nerror)
		if(nerror>0) return
                if(value) {
			kseg = kseg+1
			if(kseg > ndel) {
				nerror = 14
				return
			}
			#find other indices of the ij edge quadralateral
			call succ(ks,i,j,nadj,madj,ntot,nerror)
			if(nerror>0)return
			call pred(kp,i,j,nadj,madj,ntot,nerror)
			if(nerror>0)return
			ks1=0
			kp1=0
			do k1 = 1,npd{
				if(ks == ind(k1))ks1=k1
				if(kp == ind(k1))kp1=k1
				}
			delsgs(1,kseg) = x(i)
			delsgs(2,kseg) = y(i)
			delsgs(3,kseg) = x(j)
			delsgs(4,kseg) = y(j)
			delsgs(5,kseg) = i1
			delsgs(6,kseg) = j1
			delsgs(7,kseg) = ks1
			delsgs(8,kseg) = kp1

			#compute interior entries for penalty term
			#zero out the boundary edges
			if(ks1<1 | kp1<1){
        			do iq =1,4
                			delsgs(iq+8,kseg) = 0
				next
				}
        		call triar(x(i),y(i),x(j),y(j),x(ks),y(ks),dets)
        		call triar(x(i),y(i),x(j),y(j),x(kp),y(kp),detp)

			#Divide by 2 to make dets from signed areas
		        g(1) = - (y(i) - y(j))/two
       			g(2) =   (x(i) - x(j))/two

        		w(1, 1) = (y(j) - y(ks))/dets - (y(j) - y(kp))/detp
        		w(2, 1) = (x(ks) - x(j))/dets - (x(kp) - x(j))/detp
        		w(1, 2) = (y(ks) - y(i))/dets - (y(kp) - y(i))/detp
        		w(2, 2) = (x(i) - x(ks))/dets - (x(i) - x(kp))/detp
        		w(1, 3) = (y(i) - y(j))/dets
        		w(2, 3) = (x(j) - x(i))/dets
        		w(1, 4) = (y(j) - y(i))/detp
        		w(2, 4) = (x(i) - x(j))/detp

        		#now multiply g'w
        		do iq =1,4
                		delsgs(iq+8,kseg) = w(1,iq)*g(1) + w(2,iq)*g(2)

                }
        }
}
ndel = kseg 

return
end
