subroutine swindle(n,m,z,s)
#on input z is N(0,1) and s is sqrt(rchisq()/df)
#on output z is a matrix of swindled t variates see Simon(1976, Ap.Stat)
double precision z(n,m),s(n,m),a,b,c,d,dsqrt,dfloat,ddot
integer n,m
do i=1,m{
	c=ddot(n,z(1,i),1,s(1,i),1)
	d=ddot(n,s(1,i),1,s(1,i),1)
	a=c/d
	b=ddot(n,z(1,i),1,z(1,i),1)
	b=b-c*c/d
	b=dsqrt(b/dfloat(n-1))
	do j=1,n{
		z(j,i)=(z(j,i)/s(j,i) -a)/b
		}
	}
return
end
