#A linear equation solver for falstaff function
subroutine drd(n,m,p,r,d,b,g)
integer i,j,k,l,m,n,p
double precision r(n,m),d(n,p),g(p,m),h(100),ddot,d3dot,b(p,m)
#on input
#	r is a matrix of squared residual vectors
#	d is the design matrix
#	b is the matrix of 1st stage coefs
#	g is a matrix with row one = ones and zeros elsewhere
#on ouput
#	g[,i] is (d'r[,i] d) ^{-1} g
do i=1,m{
	l=0
	do j=1,p{
		do k=j,p{
			l=l+1
			h(l)=d3dot(n,r(1,i),d(1,j),d(1,k))
			}
		}
	call dsyle(p,h,g(1,i),p,1)
	g(1,i)=ddot(p,g(1,i),1,b(1,i),1)/g(1,i)
	}
return
end
double precision function d3dot(n,a,b,c)
double precision a(n),b(n),c(n),zero,s,d3dot
data zero/0.0d0/
s=zero
do i=1,n{
	s=s+a(i)*b(i)*c(i)
	}
d3dot=s
return
end
double precision function d2dot(n,a,b)
double precision a(n),b(n),zero,s,d2dot
data zero/0.0d0/
s=zero
do i=1,n{
	s=s+a(i)*b(i)
	call dblepr("s=",2,s,1)
	}
d2dot=s
return
end

	
