# Another attempt at EB CIs with Efron

BDE <- function(y, T = 300, df = 5, c0 = 0.1){
    # Bayesian Deconvolution Estimator: Efron (B'ka, 2016)
    require(splines)
    eps <- 1e-04
    if(length(T) == 1) T <- seq(min(y)-eps, max(y)+eps, length = T)
    X <- ns(T, df = df)
    a0 <- rep(0, ncol(X))
    A <- dnorm(outer(y,T,"-"))
    qmle <- function(a, X, A, c0){
        g <- exp(X %*% a)
        g <- g/sum(g)
        f <- A %*% g
        -sum(log(f)) + c0 * sum(a^2)^.5
    }
    ahat <- nlm(qmle, a0, X=X, A=A, c0 = c0)$estimate
    g <- exp(X %*% ahat)
    #g <- g/integrate(approxfun(T,g),min(T),max(T))$value
    g <- c(g/sum(g * diff(T)[1]))
    z <- list(x = T,y = g, sigma = 1)
    class(z) <- "GLmix"
    z
}
# Attempt to rerun Bruce Hansen's simulation see slides and random.R for his setup

R = 1000
Ns = c(100,200,500,1000)
Vs = c(0.1,0.5,1,2)
A = array(NA, c(3, length(Vs), length(Ns), R))
require(REBayes)
set.seed(1492)
sessionInfo()

# Experiment 1:  Normal-Normal Model
for(i in 1:length(Vs)){
    s = sqrt(Vs[i])
    for(j in 1:length(Ns)){
	n = Ns[j]
	for(k in 1:R){
	    t = rnorm(n)*s
	    y = t + rnorm(n)
	    f = BDE(y)
	    yhat = predict(f, y)
	    cu = predict(f, y, Loss = 0.975)
	    cl = predict(f, y, Loss = 0.025)
	    mse = sqrt(mean((t - yhat)^2))
	    coverage = mean((cl < t) & (t < cu))
	    cilength = mean(cu - cl)
	    A[,i,j,k] = c(mse, coverage, cilength)
	}
    }
}
	

