# Attempt to rerun Bruce Hansen's simulation see slides and random.R for his setup

R = 1000
Ns = c(100,200,500,1000)
Vs = c(0.1,0.5,1,2)
A = array(NA, c(3, length(Vs), length(Ns), R))
require(REBayes)

# Experiment 2:  Normal-Outlier Model
for(i in 1:length(Vs)){
    v = Vs[i]
    for(j in 1:length(Ns)){
	n = Ns[j]
	n2 = ceiling(n/10)
	for(k in 1:R){
	    t = rep(0,n)
	    t[1:n2] = sqrt(n*v/n2)
	    y = t + rnorm(n)
	    f = GLmix(y)
	    yhat = predict(f, y)
	    cu = predict(f, y, Loss = 0.975)
	    cl = predict(f, y, Loss = 0.025)
	    mse = mean((t - yhat)^2)
	    coverage = mean((cl < t) & (t < cu))
	    cilength = mean(cu - cl)
	    A[,i,j,k] = c(mse, coverage, cilength)
	}
    }
}
	

