# Simulation exercise to compare KWEB to the Martin-Walker Procedure
# Replace discrete mixing with Gaussian mixing distribution

require(doMC) #loads multicore and foreach automatically.
require(REBayes)

system("hostname")
date()
sessionInfo()
set.seed(1968)
opt <- list(set.seed = FALSE)

Odelta <- function(y,f){
    A <- dnorm(outer(y,f$v, "-"))
    (A %*% (f$fv * f$v))/(A %*% f$fv)
}
n <- 1000
R <- 1000
as <- 2:7
registerDoMC(length(as)) 
A <- matrix(0,R, 2)
AK <- foreach(k = 1:length(as), .options.multicore = opt) %dopar% {
    a <- as[k]
	f <- list(v = c(0,10,a), fv = c(.9,10/n,90/n))
	m <- sample(c(0,10,a),n,prob = c(.9,10/n,90/n), replace = TRUE) 
	for(i in 1:R){
	    x <- m + rnorm(n)
	    A[i,1] <- mean((Odelta(x,f) - m)^2)
	    A[i,2] <- mean((GLmix(x)$dy - m)^2)
	}
    A
}
