
# Simulation exercise to compare KWEB to the Martin-Walker Procedure
# Replace discrete mixing with Gaussian mixing distribution

require(doMC) #loads multicore and foreach automatically.
require(REBayes)

system("hostname")
date()
sessionInfo()
set.seed(1968)
opt <- list(set.seed = FALSE)


# A revised version of the Martin Walker code that might be faster
MWGibbs <- function(x, k = .99 , a = 0.25, v = 100, M = 1000) {
  # Added Martin-Walker defaults, see ebsparse.R in this directory
  n <- length(x)
  A <- matrix(0, M, n)
  for(i in 1:M) {
    if(i == 1) D <- sum(abs(x) <= sqrt(2 * log(n))) 
    else D <- sum(A[i-1,] == 0)
    w <- rbeta(1, a * n + D, 1 + n - D)
    u <- runif(n)
    p1 <- w * exp(-k * x^2 / 2) 
    p2 <- (1 - w) / sqrt(1 + k * v)
    p <- p1 / (p1 + p2)
    z <- rnorm(n, x, sqrt(v / (1 + k * v))) 
    A[i,] <- (u > p) * z
  }
  apply(A, 2, mean)
}

n <- 1000
R <- 1000
as <- 2:7
registerDoMC(length(as)) 
A <- matrix(0,R, 2)
AK <- foreach(k = 1:length(as), .options.multicore = opt) %dopar% {
    a <- as[k]
	m <- c(rep(10,10),rep(a,90),rep(0,900))
	for(i in 1:R){
	    x <- m + rnorm(n)
	    A[i,1] <- mean((MWGibbs(x) - m)^2)
	    A[i,2] <- mean((GLmix(x)$dy - m)^2)
	}
    A
}


