# An oracle estimator for the Gaussian mixture problem 


Odelta <- function(y,f){
    # Two point mass mixtures
    A <- dnorm(outer(y,f$v, "-"))
    (A %*% (f$fv * f$v))/(A %*% f$fv)
}
g <- function(y,a,v) a * dnorm(y) + (1 - a) * dnorm(y, v, sqrt(2))
gp <- function(y,a,v) -y * a * dnorm(y) - (1 - a) * (y - v) * dnorm(y, v, sqrt(2))/2
Tweedie <- function(y,a,v){
    # Gaussian signal plus point mass at zero Tweedie formula
    y + gp(y,a,v)/g(y,a,v)
}
require(REBayes)
n <- 500
if(FALSE){
f <- list(v = c(0,5), fv = c(.8,.2))
m <- sample(c(0,5),n,prob = c(.8,.2), replace = TRUE) 
} else {
    a <- .8
    v <- 5
    m <- sample(0:1,n,prob = c(a,1-a), replace = TRUE)*rnorm(n,v)
}
y <- rnorm(n, m) 
#t0 <- system.time(m0 <- mean((Odelta(y,f)-m)^2))
t0 <- system.time(m0 <- mean((Tweedie(y,a,v)-m)^2))
t1 <- system.time(m1 <- mean((GLmix(y)$dy-m)^2))
print(c(m0,m1))
