# Test function for fortran implementation 
dpr <- function(D, fortran = TRUE, tol = 1e-6){
    X <- (model.matrix(~ T1 - 1, data = D) - model.matrix(~ T2 - 1, data = D))[,-1]
    Y <- with(D,cbind(W, L))
    f <- glm(Y ~ X - 1, family = binomial("logit"))
    COV <- vcov(f)
    bhat = c(0,f$coef)
    g <- GLmix(bhat[-1], sigma = sqrt(diag(COV)))
    gs <- KWsmooth(g, bw = bwKW(g,0.2))
    gs <- list(x = gs$x, y = gs$y/sum(gs$y))		

    n <- length(bhat)
    teams = t(combn(n, 2))
    R <- data.frame(i = teams[,1], j = teams[,2], dpr = NA)
    A <- dnorm(outer(bhat[-1], g$x, "-"), sd = sqrt(diag(COV)))
    R$dpr[R$i==1] = A %*%((gs$x>=0) * gs$y)/A%*%gs$y

    gr = list(x = gs$x[gs$y>tol], y = gs$y[gs$y>tol]/sum(gs$y[gs$y>tol]))
gridr <- expand.grid(u1 = gr$x, u2 = gr$x)
fgridr <- expand.grid(f1 = gr$y, f2 = gr$y)
ffr <- apply(fgridr,1,function(x) x[1]*x[2])

    if(fortran){
	t <- t(teams)
	b <- bhat
	Gx <- rbind(gridr$u1, gridr$u2)
	Gy <- rbind(fgridr$f1, fgridr$f2)
	p <- n
	m <- ncol(Gx)
	p2 <- p*(p-1)/2
	z <- .Fortran("fdpr",
			  as.integer(p),
			  as.integer(m),
			  as.integer(p2),
			  as.double(b),
			  as.integer(t),
			  as.double(COV),
			  as.double(Gx),
			  as.double(Gy),
			  r = double(p2)
			  )
	r <- c(R$dpr[1:(p-1)], z$r[p:p2])
    }
    else{
      for (j in n:nrow(teams)){
			A = apply(gridr,1,function(s) dmvn(bhat[teams[j,]], s, sigma = COV[teams[j,]-1, teams[j,]-1]))
		R$dpr[j] = (A %*% (((gridr[,1] <= gridr[,2])+0) * ffr))/A %*% ffr	
	}
    r <- R$dpr
    }
    r
}

require(REBayes)
require(Rfast)
require(mvnfast)

source("../setup.R")
dyn.load("MakeA.so")
set.seed(1729)
n <- 50
m <- 50000
a <- sort((exp(rnorm(n))+2))
a <- a/a[1]
D <- dgps(1,a,m)
Tf <- system.time(Rf <- dpr(D))
TR <- system.time(RR <- dpr(D, fortran = FALSE))
plot(RR,Rf)
